package com.namasoft.common.layout.metadata;

import com.namasoft.common.NaMaDTO;
import com.namasoft.common.utilities.NamaObject;
import com.namasoft.common.utilities.ObjectChecker;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import java.math.BigDecimal;

@XmlAccessorType(XmlAccessType.PROPERTY)
public class DTOCmnFontInfo extends NaMaDTO implements NamaObject
{
	private String fontColor;
	private String fontName;
	private String fontSize;
	private String disabledFontColor;
	private String disabledFontName;
	private String disabledFontSize;
	private String menuFontColor;
	private String menuFontName;
	private String menuFontSize;

	public String getFontColor()
	{
		return fontColor;
	}

	public String getFontName()
	{
		return fontName;
	}

	public String getFontSize()
	{
		return fontSize;
	}

	public void setFontColor(String fontColor)
	{
		this.fontColor = fontColor;
	}

	public void setFontName(String fontName)
	{
		this.fontName = fontName;
	}

	public void setFontSize(String fontSize)
	{
		this.fontSize = fontSize;
	}

	public String getMenuFontColor()
	{
		return menuFontColor;
	}

	public void setMenuFontColor(String menuFontColor)
	{
		this.menuFontColor = menuFontColor;
	}

	public String getMenuFontName()
	{
		return menuFontName;
	}

	public void setMenuFontName(String menuFontName)
	{
		this.menuFontName = menuFontName;
	}

	public String getMenuFontSize()
	{
		return menuFontSize;
	}

	public void setMenuFontSize(String menuFontSize)
	{
		this.menuFontSize = menuFontSize;
	}

	public String getDisabledFontColor()
	{
		return disabledFontColor;
	}

	public void setDisabledFontColor(String disabledFontColor)
	{
		this.disabledFontColor = disabledFontColor;
	}

	public String getDisabledFontName()
	{
		return disabledFontName;
	}

	public void setDisabledFontName(String disabledFontName)
	{
		this.disabledFontName = disabledFontName;
	}

	public String getDisabledFontSize()
	{
		return disabledFontSize;
	}

	public void setDisabledFontSize(String disabledFontSize)
	{
		this.disabledFontSize = disabledFontSize;
	}

	@Override
	public boolean isEmpty()
	{
		return ObjectChecker.areAllEmptyOrNull(getFontColor(), getFontName(), getFontSize(), getMenuFontColor(), getMenuFontName(), getMenuFontSize(),
				getDisabledFontColor(), getDisabledFontName(), getDisabledFontSize());
	}

	public String calcFontSize(String fontSize)
	{
		try
		{
			new BigDecimal(fontSize);
		}
		catch (Exception e)
		{
			return fontSize;
		}
		return fontSize + "pt";
	}
}
