package com.namasoft.common.layout.metadata;

import java.io.Serializable;
import java.util.List;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;

import com.namasoft.common.utilities.NamaObject;

@XmlAccessorType(XmlAccessType.PROPERTY)
public class EnumMetaData implements Serializable, NamaObject
{
	private static final long serialVersionUID = -6427230469608212908L;
	private String enumName;
	private String enumClassName;
	private List<String> allowedValues;

	@Override
	public boolean isEmpty()
	{
		return false;
	}

	public String getEnumName()
	{
		return enumName;
	}

	public void setEnumName(String enumName)
	{
		this.enumName = enumName;
	}

	public String getEnumClassName()
	{
		return enumClassName;
	}

	public void setEnumClassName(String enumClassName)
	{
		this.enumClassName = enumClassName;
	}

	public List<String> getAllowedValues()
	{
		return allowedValues;
	}

	public void setAllowedValues(List<String> allowedValues)
	{
		this.allowedValues = allowedValues;
	}
}
