package com.namasoft.common.layout.metadata;

import java.util.HashMap;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;

import com.namasoft.common.NaMaDTO;

@XmlRootElement
@XmlAccessorType(XmlAccessType.PROPERTY)
public class FieldsAllowedValuesMetadata extends NaMaDTO
{
	private HashMap<String, FieldAllowedValueInfo> entityTypeFieldValuesMap = new HashMap<>();

	public HashMap<String, FieldAllowedValueInfo> getEntityTypeFieldValuesMap()
	{
		return entityTypeFieldValuesMap;
	}

	public void setEntityTypeFieldValuesMap(HashMap<String, FieldAllowedValueInfo> entityTypeFieldValuesMap)
	{
		this.entityTypeFieldValuesMap = entityTypeFieldValuesMap;
	}

	public FieldAllowedValueInfo findMetadataFor(String entityType, String fieldId)
	{
		if (entityTypeFieldValuesMap == null)
			entityTypeFieldValuesMap = new HashMap<>();
		return entityTypeFieldValuesMap.get(entityType + "." + fieldId);
	}

	public void put(String entityType, String fieldId, FieldAllowedValueInfo info)
	{
		if (entityTypeFieldValuesMap == null)
			entityTypeFieldValuesMap = new HashMap<>();
		entityTypeFieldValuesMap.put(entityType + "." + fieldId, info);
	}

}
