package com.namasoft.common.utilities;

import com.namasoft.common.flatobjects.EntityReferenceData;

public interface Converter<Source, Destination>
{
	@SuppressWarnings("rawtypes")
	Converter<Enum, String> ENUM_NAME_CONVERTER = new Converter<Enum, String>()
	{
		@Override
		public String convert(Enum object)
		{
			return object.name();
		}
	};
	Converter<Object, String> TOSTRING_CONVERTER = ObjectChecker::toStringOrEmpty;
	Converter<EntityReferenceData, String> REF_ID_CONVERTER = object -> {
		if (object == null)
			return "";
		return object.getId();
	};

	Destination convert(Source object);
}
