package com.namasoft.common.utils;

import com.namasoft.common.constants.*;
import com.namasoft.common.criteria.*;
import com.namasoft.common.fieldids.*;
import com.namasoft.common.flatobjects.DataTypes;
import com.namasoft.common.layout.OwnerType;
import com.namasoft.common.layout.edit.*;
import com.namasoft.common.layout.metadata.*;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.common.utils.dashboard.DashboardConstants;

import java.io.IOException;
import java.lang.reflect.*;
import java.nio.file.*;
import java.util.*;

public class CommonGenJSConstantFiles
{
	public static void main(String[] args)
	{
		generate();
	}

	public static void generate()
	{
		generate(ExpressionRelationship.class);
		generate(ExpressionValType.class);
		generate(CommonConstants.class);
		generate(NestConstants.class);
		generate(URLRequestParameters.class);
		generate(StringConstants.class);
		generate(PlaceTokens.class);
		generate(CommonFieldIds.class);
		generate(FieldType.class);
		generate(FieldSubType.class);
		generate(EditScreenFieldLayout.class);
		generate(Operator.class);
		generate(GUI2Operations.class);
		generate(ViewMode.class);
		generate(GenericActions.class);
		generate(GenerationType.class);
		generate(DataTypes.class);
		generate(GridSize.class);
		generate(ApprovalDecision.class);
		generate(EntitiesWithLedgerEffectsOrWithParents.class);
		generate(DomainBaseEntities.class);
		generate(SimpleEntities.class);
		generate(ConstantViewNames.class);
		generate(GridAction.class);
		generate(ShowImageIn.class);
		generate(BarCodeConstants.class);
		generate(PrintingOption.class);
		generate(DownloadPurpose.class);
		generate(BSCEntities.class);
		generate(OutputFormat.class);
		generate(OwnerType.class);
		generate(EditScreenListLinkType.class);
		generate(DashboardConstants.class);
		generate(ApplicationVersion.class);
	}

	public static void generate(Class<?> klass)
	{
		String lineSeparator = System.lineSeparator();
		StringJoiner joiner = new StringJoiner(";".concat(lineSeparator), "", ";");
		String declarationFormat = "export const ";
		if (klass.isEnum())
		{
			List<?> constants = Arrays.asList(klass.getEnumConstants());
			Collections.sort(constants, Comparator.comparing(Object::toString));
			constants.forEach(c -> {
				joiner.add(declarationFormat + toValidJSVarName(c.toString()) + " = `" + c.toString().replace("`", "\\`") + "`");
			});
		}
		else
		{
			List<Field> fields = Arrays.asList(klass.getDeclaredFields());
			Collections.sort(fields, Comparator.comparing(Field::getName));
			fields.forEach(f -> {
				if (Modifier.isStatic(f.getModifiers()) && isValidDataType(f.getType()))
					joiner.add(declarationFormat + toValidJSVarName(f.getName()) + " = " + getFieldValue(f) + "");
			});
		}
		if (joiner.toString().length() <= 1)
			return;
		String jsPath = ProjectPathUtil.NAMA_GUI2_ROOT + "src/main/js/constants/" + klass.getSimpleName() + ".js";
		String tsPath = ProjectPathUtil.NAMA_GUI2_ROOT + "src/main/vue/src/utils/constants/" + klass.getSimpleName() + ".ts";
		writeConstantsToJSFile("//Generated File " + lineSeparator + joiner, jsPath);
		writeConstantsToJSFile(
				"//Generated File " + lineSeparator + "export default class " + klass.getSimpleName() + "{\n" + joiner.toString().replace("export const ",
						"\tstatic readonly ") + "\n}", tsPath);
	}

	private static String toValidJSVarName(String name)
	{
		if ("delete".equals(name))
			return "$delete";
		return name;
	}

	private static void writeConstantsToJSFile(String data, String path)
	{
		try
		{
			Files.write(Paths.get(path), Collections.singletonList(data));
		}
		catch (IOException e)
		{
			e.printStackTrace();
		}
	}

	private static String getFieldValue(Field f)
	{
		try
		{
			f.setAccessible(true);
			Object value = f.get(null);
			return renderJSValueOf(value);
		}
		catch (IllegalAccessException e)
		{
			e.printStackTrace();
			return null;
		}
	}

	private static String renderJSValueOf(Object value)
	{
		if (value instanceof Number || value.getClass().isPrimitive())
			return value.toString();
		if (value instanceof Collection)
		{
			StringJoiner joiner = new StringJoiner(", ", "[", "]");
			for (Object subValue : (Collection) value)
			{
				joiner.add(renderJSValueOf(subValue));
			}
			return joiner.toString();
		}
		if (value.getClass().isArray())
		{
			StringJoiner joiner = new StringJoiner(", ", "[", "]");
			for (Object subValue : (Object[]) value)
			{
				joiner.add(renderJSValueOf(subValue));
			}
			return joiner.toString();
		}
		return "`" + ObjectChecker.toStringOrEmpty(value).replace("`", "\\`") + "`";
	}

	private static boolean isValidDataType(Class<?> type)
	{
		if (ObjectChecker
				.isAnyEqualToFirst(type, byte.class, int.class, long.class, boolean.class, double.class, float.class, short.class, char.class))
			return true;
		if (Number.class.isAssignableFrom(type))
			return true;
		if (CharSequence.class.isAssignableFrom(type))
			return true;
		if (Collection.class.isAssignableFrom(type))
			return true;
		if(type.isArray())
			return true;
		return false;
	}
}
