package com.namasoft.common.utils;

import static java.nio.file.StandardWatchEventKinds.*;

import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.WatchEvent;
import java.nio.file.WatchEvent.Kind;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;

import com.namasoft.common.utilities.NaMaLogger;

public class FileWatcher implements Runnable
{
	public static interface FileWatcherEventHandler
	{
		void onChange(Kind<?> kind);
	}

	private final Path file;
	private final FileWatcherEventHandler handler;

	@SuppressWarnings("unchecked")
	static <T> WatchEvent<T> cast(WatchEvent<?> event)
	{
		return (WatchEvent<T>) event;
	}

	public FileWatcher(Path file, FileWatcherEventHandler handler) throws IOException
	{
		this.file = file;
		this.handler = handler;
	}

	@Override
	public void run()
	{
		try
		{
			WatchService watcher = FileSystems.getDefault().newWatchService();
			file.getParent().register(watcher, ENTRY_CREATE, ENTRY_DELETE, ENTRY_MODIFY);
			for (;;)
			{
				WatchKey key;
				try
				{
					key = watcher.take();
				}
				catch (InterruptedException x)
				{
					return;
				}

				for (WatchEvent<?> event : key.pollEvents())
				{
					Kind<?> kind = event.kind();

					if (kind == OVERFLOW)
					{
						continue;
					}
					WatchEvent<Path> ev = cast(event);
					Path name = ev.context();
					Path child = file.getParent().resolve(name);
					key.reset();
					if (!file.equals(child))
						continue;
					try
					{
						handler.onChange(kind);
					}
					catch (Exception e)
					{
						NaMaLogger.error(e);
					}
				}

			}
		}
		catch (Exception e)
		{
			e.printStackTrace();
		}
	}

	public static void watch(Path file, FileWatcherEventHandler handler) throws IOException
	{
		new Thread(new FileWatcher(file, handler)).start();
	}
}