package com.namasoft.common.utils;

public class MobileQrInfoCreator
{
	private MobileQrInfo info = new MobileQrInfo();
	private boolean encrypted;

	public MobileQrInfoCreator code(String code)
	{
		info.setIdOrCode(code);
		return this;
	}

	public MobileQrInfoCreator id(Object id)
	{
		info.setIdOrCode(ServerStringUtils.toUUIDStr(id));
		return this;
	}

	public MobileQrInfoCreator addParam(String paramId, Object paramValue)
	{
		info.getParams().put(paramId, paramValue);
		return this;
	}

	public MobileQrInfoCreator encrypted()
	{
		this.encrypted = true;
		return this;
	}

	@Override
	public String toString()
	{
		String json = NaMaLayersConnector.getInstance().toJson(info);
		if (encrypted)
			return CryptoUtils.encryptAndAddPrefix(json);
		return json;
	}
}
