package com.namasoft.common.utils;

import com.namasoft.common.*;
import com.namasoft.common.constants.*;
import com.namasoft.common.exceptions.NaMaServiceExcepption;
import com.namasoft.common.flatobjects.EntityReferenceData;
import com.namasoft.common.hijri.HijriDate;
import com.namasoft.common.layout.metadata.ReportMetadata;
import com.namasoft.common.utilities.*;
import com.namasoft.common.utils.translation.MessageTranslator;

import java.io.*;
import java.math.BigDecimal;
import java.util.*;

public abstract class NaMaLayersConnector
{

	private static List<NaMaLayersConnectorHelper> helpers = new ArrayList<>();
	private static NaMaLayersConnector instance;

	public static void addHelper(NaMaLayersConnectorHelper helper)
	{
		helpers.add(helper);
	}

	public static void setInstance(NaMaLayersConnector instance)
	{
		NaMaLayersConnector.instance = instance;
	}

	public static NaMaLayersConnector getInstance()
	{
		return instance;
	}


	public abstract Long nextMessageSequence();

	public final BigDecimal getItemPriceById(Object itemId)
	{
		for (NaMaLayersConnectorHelper helper : helpers)
		{
			if (helper.supportsItemPrice())
				return helper.getItemPriceById(itemId);
		}
		return BigDecimal.ZERO;
	}

	public final BigDecimal getItemPriceByCode(Object itemCode)
	{
		for (NaMaLayersConnectorHelper helper : helpers)
		{
			if (helper.supportsItemPrice())
				return helper.getItemPriceByCode(itemCode);
		}
		return BigDecimal.ZERO;
	}

	public final BigDecimal getNetPurchaseValue(Object itemCode)
	{
		for (NaMaLayersConnectorHelper helper : helpers)
		{
			if (helper.supportsPurchaseValue())
				return helper.getNetPurchaseValue(itemCode);
		}
		return BigDecimal.ZERO;
	}

	public BigDecimal getItemPriceForCustomer(Object item, Object customer)
	{
		for (NaMaLayersConnectorHelper helper : helpers)
		{
			if (helper.supportsItemPrice())
				return helper.getItemPriceForCustomer(item, customer);
		}
		return BigDecimal.ZERO;
	}

	public BigDecimal getItemDiscountForCustomer(Object item, Object customer, Object discountIndex)
	{
		for (NaMaLayersConnectorHelper helper : helpers)
		{
			if (helper.supportsItemPrice())
				return helper.getItemDiscountForCustomer(item, customer, discountIndex);
		}
		return BigDecimal.ZERO;
	}

	public Object getPricesForCustomer(Object itemIdOrCode, Object customerIdOrCode, Object uom, Object qty)
	{
		for (NaMaLayersConnectorHelper helper : helpers)
		{
			if (helper.supportsItemPrice())
				return helper.getPricesForCustomer(itemIdOrCode, customerIdOrCode, uom, qty);
		}
		return null;
	}

	public Object getPricesForCustomer(Object itemIdOrCode, Object customerIdOrCode, Object uom, Object qty, Object classificationIdOrCode)
	{
		for (NaMaLayersConnectorHelper helper : helpers)
		{
			if (helper.supportsItemPrice())
				return helper.getPricesForCustomer(itemIdOrCode, customerIdOrCode, uom, qty, classificationIdOrCode);
		}
		return null;
	}

	public Object getPricesForCustomer(Object itemIdOrCode, Object customerIdOrCode, Object uom, Object qty, Object classificationIdOrCode,
			Object date)
	{
		for (NaMaLayersConnectorHelper helper : helpers)
		{
			if (helper.supportsItemPrice())
				return helper.getPricesForCustomer(itemIdOrCode, customerIdOrCode, uom, qty, classificationIdOrCode, date);
		}
		return null;
	}

	public Object getPricesForCustomer(Object itemIdOrCode, Object customerIdOrCode, Object uom, Object qty, Object classificationIdOrCode,
			Object date, Object legalEntityIdOrCode)
	{
		for (NaMaLayersConnectorHelper helper : helpers)
		{
			if (helper.supportsItemPrice())
				return helper.getPricesForCustomer(itemIdOrCode, customerIdOrCode, uom, qty, classificationIdOrCode, date, legalEntityIdOrCode);
		}
		return null;
	}

	public Object getPricesForCustomer(Object itemIdOrCode, Object customerIdOrCode, Object uom, Object qty, Object classificationIdOrCode,
			Object date, Object legalEntityIdOrCode, Object sectorIdOrCode, Object branchIdOrCode, Object analysisSetIdOrCode,
			Object departmentIdOrCode, Object revisionIdCode, Object colorCode, Object sizeCode)
	{
		for (NaMaLayersConnectorHelper helper : helpers)
		{
			if (helper.supportsItemPrice())
				return helper.getPricesForCustomer(itemIdOrCode, customerIdOrCode, uom, qty, classificationIdOrCode, date, legalEntityIdOrCode,
						sectorIdOrCode, branchIdOrCode, analysisSetIdOrCode, departmentIdOrCode, revisionIdCode, colorCode, sizeCode);
		}
		return null;
	}

	public Object getPricesForCustomer(Map parametersMap, Object itemIdOrCode, Object customerIdOrCode, Object oUom, Object oQty,
			Object classificationIdOrCode, Object date, Object legalEntityIdOrCode, Object sectorIdOrCode, Object branchIdOrCode,
			Object analysisSetIdOrCode, Object departmentIdOrCode, Object revisionIdCode, Object colorCode, Object sizeCode)
	{
		for (NaMaLayersConnectorHelper helper : helpers)
		{
			if (helper.supportsItemPrice())
				return helper.getPricesForCustomer(parametersMap, itemIdOrCode, customerIdOrCode, oUom, oQty, classificationIdOrCode, date,
						legalEntityIdOrCode, sectorIdOrCode, branchIdOrCode, analysisSetIdOrCode, departmentIdOrCode, revisionIdCode, colorCode,
						sizeCode);
		}
		return null;
	}

	public Object getPricesForCustomer(Map parametersMap, Object itemIdOrCode, Object customerIdOrCode, Object oUom, Object oQty,
			Object classificationIdOrCode, Object date, Object legalEntityIdOrCode, Object sectorIdOrCode, Object branchIdOrCode,
			Object analysisSetIdOrCode, Object departmentIdOrCode, Object revisionIdCode, Object colorCode, Object sizeCode,
			Object priceClassifier1IdOrCode, Object priceClassifier2IdOrCode, Object priceClassifier3IdOrCode, Object priceClassifier4IdOrCode,
			Object priceClassifier5IdOrCode)
	{
		for (NaMaLayersConnectorHelper helper : helpers)
		{
			if (helper.supportsItemPrice())
				return helper.getPricesForCustomer(parametersMap, itemIdOrCode, customerIdOrCode, oUom, oQty, classificationIdOrCode, date,
						legalEntityIdOrCode, sectorIdOrCode, branchIdOrCode, analysisSetIdOrCode, departmentIdOrCode, revisionIdCode, colorCode,
						sizeCode, priceClassifier1IdOrCode, priceClassifier2IdOrCode, priceClassifier3IdOrCode, priceClassifier4IdOrCode,
						priceClassifier5IdOrCode);
		}
		return null;
	}
	public Object getPurchasePricesForSupplier(Map parametersMap, Object itemIdOrCode, Object customerIdOrCode, Object oUom, Object oQty,
			Object classificationIdOrCode, Object date, Object legalEntityIdOrCode, Object sectorIdOrCode, Object branchIdOrCode,
			Object analysisSetIdOrCode, Object departmentIdOrCode, Object revisionIdCode, Object colorCode, Object sizeCode,
			Object priceClassifier1IdOrCode, Object priceClassifier2IdOrCode, Object priceClassifier3IdOrCode, Object priceClassifier4IdOrCode,
			Object priceClassifier5IdOrCode)
	{
		for (NaMaLayersConnectorHelper helper : helpers)
		{
			if (helper.supportsItemPrice())
				return helper.getPurchasePricesForSupplier(parametersMap, itemIdOrCode, customerIdOrCode, oUom, oQty, classificationIdOrCode, date,
						legalEntityIdOrCode, sectorIdOrCode, branchIdOrCode, analysisSetIdOrCode, departmentIdOrCode, revisionIdCode, colorCode,
						sizeCode, priceClassifier1IdOrCode, priceClassifier2IdOrCode, priceClassifier3IdOrCode, priceClassifier4IdOrCode,
						priceClassifier5IdOrCode);
		}
		return null;
	}

	public Object getPricesForCustomer(Object itemIdOrCode, Object customerIdOrCode)
	{
		for (NaMaLayersConnectorHelper helper : helpers)
		{
			if (helper.supportsItemPrice())
				return helper.getPricesForCustomer(itemIdOrCode, customerIdOrCode);
		}
		return null;
	}

	public abstract SimpleEntry<EntityReferenceData, ReportMetadata> findReportMetadataById(String id);

	public abstract SimpleEntry<EntityReferenceData, ReportMetadata> findReportMetadataByCode(String code);

	public abstract void registerClosable(Closeable closeable);

	public abstract boolean canDisplay(Object o);

	public abstract List<MessageTranslator> getDBTranslators();

	@SuppressWarnings("rawtypes")
	public abstract List runSQLQuery(String query, Object... parameters);

	public abstract InputStream getFile(Object id) throws Exception;

	public abstract String audit(Object entityType, Object id, Object versionNumber, Object actionType, Language language, OutputFormat outputFormat);

	public abstract String toHijri(Date date);

	public HijriDate toHijriDate(Date date)
	{
		return null;
	}

	public String getGuiServerURL()
	{
		return appendSlashIfNeeded(GeneralSettings.getGuiServerURL());
	}

	public static String appendSlashIfNeeded(String url)
	{
		if (ObjectChecker.isEmptyOrNull(url))
			return url;
		if (url.endsWith("/"))
			return url;
		if (url.endsWith(".html"))
			return url;
		return url + "/";
	}

	public abstract boolean isModuleLoaded(String moduleName);

	public abstract BigDecimal getVacationRemainderBalance(Object empCodeOrId, Object vacationTypeIdOrCode, Object atDate);

	public Triple<BigDecimal, Pair<BigDecimal, BigDecimal>, BigDecimal> getVacationAssignedConsumedRemainder(Object empCodeOrId,
			Object vacationTypeCodeOrId, Object atDate)
	{
		return null;
	}

	public Object newGetVacationAssignedConsumedRemainder(Object empCodeOrId, Object vacationTypeCodeOrId, Object atDate)
	{
		return null;
	}

	public List<BigDecimal> getRemainderBalancePerYears(Object empCodeOrId, Object vacationTypeCodeOrId, Object atDate, Object yearsCount)
	{
		return new ArrayList<>();
	}

	public abstract BigDecimal getVacation1RemainderBalance(Object empCodeOrId);

	public abstract BigDecimal getVacation2RemainderBalance(Object empCodeOrId);

	public abstract BigDecimal getVacation3RemainderBalance(Object empCodeOrId);

	public abstract EntityReferenceData findItemByCode(String code);

	public abstract Object getValueFromModuleConfig(String moduleId, String fieldId);

	public abstract <T extends IBaseEntityDTO> T fetchReference(EntityReferenceData ref);

	public abstract boolean usingFrench();

	public void evictCache()
	{
	}

	public String currencyPattern(Object currencyCodeOrId)
	{
		return "#,##0.00";
	}

	public String quantityPattern(Object uomCodeOrId)
	{
		return "#,##0.##";
	}

	public String currencyOrQtyPattern(Object currencyOrUOMCodeOrId)
	{
		return "#,##0.##";
	}

	public String ratePattern()
	{
		return "#,##0.##";
	}

	public String datePattern()
	{
		return "yyyy-MM-dd";
	}

	public String timePattern()
	{
		return "hh:mm a";
	}

	public String dateTimePattern()
	{
		return "yyyy-MM-dd HH:mm:ss";
	}

	public String percentPattern()
	{
		return "#,##0.##";
	}

	public abstract EntityReferenceData refByCode(String entityType, String id);

	public abstract EntityReferenceData refById(String entityType, String id);

	public List<String> unzipSerials(Object serials)
	{
		if (ObjectChecker.isEmptyOrNull(serials))
			return Collections.emptyList();
		for (NaMaLayersConnectorHelper helper : helpers)
		{
			if (helper.supportsItemPrice())
				return helper.unzipSerials(serials);
		}
		return Arrays.asList(ObjectChecker.toStringOrEmpty(serials));
	}

	public String retrieverFileId(Object entityType, Object idOrCode)
	{
		return "NotHandled-Please-Consult-Development-Department";
	}

	public String getAttachmentFileNameIfPossible(String attachmentId)
	{
		return attachmentId;
	}

	public abstract EntityReferenceData findByIdOrCode(String entityType, Object id);

	public String addSecurityConstraints(String fieldEntityType,String tableAlias, String... capabilities)
	{
		return " 0=0 ";
	}

	public ItemPriceCalculator createPriceCalculator()
	{
		for (NaMaLayersConnectorHelper helper : helpers)
		{
			if (helper.supportsItemPrice())
				return helper.createPriceCalculator();
		}
		return null;
	}

	public String zatcaHashedInvoice(Object entityType, Object id)
	{
		return null;
	}

	public String genZatcaQrCodeFromEntity(Object entityType, Object idOrCode)
	{
		return null;
	}

	public String toJson(Object o)
	{
		throw new NaMaServiceExcepption("toJson() not implemented");
	}
}
