package com.namasoft.common.utils;

import com.namasoft.common.utilities.*;

import java.io.*;
import java.util.regex.Pattern;

public class StringDistanceUtil
{
	//	public static int measure1(String a, String b)
	//	{
	//		if (ObjectChecker.isAnyEmptyOrNull(a, b))
	//			return 0;
	//		print(b + "\t\t");
	//		int[] diagonals = new int[a.length() + b.length() - 1];
	//		for (int i = 0; i < a.length(); i++)
	//		{
	//			for (int j = 0; j < b.length(); j++)
	//			{
	//				int index = i >= j ? i - j : a.length() + j - i - 1;
	//				diagonals[index] += a.charAt(i) == b.charAt(j) ? 1 : 0;
	//			}
	//		}
	//		return NaMaMath.max(diagonals) * 50 + NaMaMath.multiplyNonZero(diagonals) * 10 - (Math.abs(a.length() - b.length()) * 5);
	//	}

	public static int measure(String a, String b, int minSubString)
	{
		if (a.contains(b) && b.length() > 3 || b.contains(a) && a.length() > 3)
			return Math.abs(a.length() - b.length()) - (Math.min(a.length(), b.length()) * 32);
		String longestCommonSubStr = findLongestCommonSubStr(a, b);
		if (ObjectChecker.isNotEmptyOrNull(longestCommonSubStr) && longestCommonSubStr.length() >= minSubString)
		{
			String a1 = a.replaceFirst(Pattern.quote(longestCommonSubStr), "");
			String b1 = b.replaceFirst(Pattern.quote(longestCommonSubStr), "");
			int measure = measure(a1, b1, minSubString);
			if (measure == Integer.MAX_VALUE)
				return (a1.length() + b1.length()) * 8 - (longestCommonSubStr.length() * 32);
			return measure - longestCommonSubStr.length() * 32;
		}
		int distance = 0;
		int ai = 0, bi = 0;
		boolean hasAnyCommonality = false;
		for (; ai < a.length() && bi < b.length(); )
		{
			if (a.charAt(ai) == b.charAt(bi))
			{
				bi++;
				ai++;
				hasAnyCommonality = true;
				continue;
			}
			int ad = -1;
			for (int i = ai; i < a.length(); i++)
			{
				if (a.charAt(i) == b.charAt(bi))
				{
					ad = i - ai;
					break;
				}
			}
			int bd = -1;
			for (int i = bi; i < b.length(); i++)
			{
				if (b.charAt(i) == a.charAt(ai))
				{
					bd = i - bi;
					break;
				}
			}
			if (bd == -1 && ad == -1)
			{
				ai++;
				bi++;
				distance += 2;
				continue;
			}
			else if ((ad < bd && ad > -1) || bd < 0)
			{
				distance += ad;
				ai += ad * 2;
				hasAnyCommonality = true;
				continue;
			}
			else
			{
				distance += bd * 2;
				bi += bd;
				hasAnyCommonality = true;
				continue;
			}
		}
		if (hasAnyCommonality == false)
			return Integer.MAX_VALUE;
		return (distance + (a.length() - ai) + (b.length() - bi)) * 16;
	}

	private static String findLongestCommonSubStr(String x, String y)
	{
		int m = x.length();
		int n = y.length();
		// Create a table to store lengths of longest common
		// suffixes of substrings.   Note that LCSuff[i][j]
		// contains length of longest common suffix of X[0..i-1]
		// and Y[0..j-1]. The first row and first column entries
		// have no logical meaning, they are used only for
		// simplicity of program
		int[][] LCSuff = new int[m + 1][n + 1];

		// To store length of the longest common substring
		int len = 0;

		// To store the index of the cell which contains the
		// maximum value. This cell's index helps in building
		// up the longest common substring from right to left.
		int row = 0, col = 0;

        /* Following steps build LCSuff[m+1][n+1] in bottom
           up fashion. */
		for (int i = 0; i <= m; i++)
		{
			for (int j = 0; j <= n; j++)
			{
				if (i == 0 || j == 0)
				{
					LCSuff[i][j] = 0;
				}
				else if (x.charAt(i - 1) == y.charAt(j - 1))
				{
					LCSuff[i][j] = LCSuff[i - 1][j - 1] + 1;
					if (len < LCSuff[i][j])
					{
						len = LCSuff[i][j];
						row = i;
						col = j;
					}
				}
				else
				{
					LCSuff[i][j] = 0;
				}
			}
		}

		// if true, then no common substring exists
		if (len == 0)
		{
			return "";
		}

		String resultStr = "";

		// traverse up diagonally form the (row, col) cell
		// until LCSuff[row][col] != 0
		while (LCSuff[row][col] != 0)
		{
			resultStr = x.charAt(row - 1) + resultStr; // or Y[col-1]
			--len;
			// move diagonally up to previous cell
			row--;
			col--;
		}

		return resultStr;
	}

	private static int measure_(String a, String b)
	{
		return measure(StringUtils.normalizeArabic(a), StringUtils.normalizeArabic(b), 3);
	}

	public static void main(String[] args) throws IOException
	{
		BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
		String val = reader.readLine();
		String val1 = reader.readLine();
		String val2 = reader.readLine();
		System.out.println(measure(StringUtils.normalizeArabic(val), StringUtils.normalizeArabic(val1), 4));
		System.out.println(measure(StringUtils.normalizeArabic(val), StringUtils.normalizeArabic(val2), 4));
	}

	private static void print(Object i)
	{
		System.out.print(i);
	}

	private static void println(Object i)
	{
		System.out.println(i);
	}

	private static boolean wordContainsPatternWithWildCards(String word, int n, String pattern, int m)
	{
		// end of the pattern is reached
		if (m == pattern.length())
		{
			// return true only if the end of the input string is also reached
			return n == word.length();
		}

		// if the input string reaches its end, return when the
		// remaining characters in the pattern are all '*'
		if (n == word.length())
		{
			for (int i = m; i < pattern.length(); i++)
			{
				if (pattern.charAt(i) != '*')
				{
					return false;
				}
			}

			return true;
		}

		// if the current wildcard character is '?' or the current character in
		// the pattern is the same as the current character in the input string
		if (pattern.charAt(m) == '?' || pattern.charAt(m) == word.charAt(n))
		{
			// move to the next character in the pattern and the input string
			return wordContainsPatternWithWildCards(word, n + 1, pattern, m + 1);
		}

		// if the current wildcard character is '*'
		if (pattern.charAt(m) == '*')
		{
			// move to the next character in the input string or
			// ignore '*' and move to the next character in the pattern
			return wordContainsPatternWithWildCards(word, n + 1, pattern, m) || wordContainsPatternWithWildCards(word, n, pattern, m + 1);
		}

		// we reach here when the current character in the pattern is not a
		// wildcard character, and it doesn't match the current
		// character in the input string
		return false;
	}

	// Check if a string matches with a given wildcard pattern
	public static boolean wordContainsPatternWithWildCards(String word, String pattern)
	{
		return wordContainsPatternWithWildCards(word, 0, pattern, 0);
	}
}
