package com.namasoft.common.utils.dm.pojo;

import com.namasoft.common.*;
import com.namasoft.common.flatobjects.GenericValue;
import com.namasoft.common.layout.metadata.FieldType;
import com.namasoft.common.utilities.*;
import com.namasoft.common.exceptions.NaMaServiceExcepption;

import jakarta.xml.bind.annotation.*;
import java.util.Map;

@SuppressWarnings("serial")
@XmlAccessorType(XmlAccessType.PROPERTY)
@XmlRootElement
public class DMProperty extends NaMaDTO implements Comparable<DMProperty>
{
	private String unionCTEAlias;
	private String columnName = "";
	private String fullName = "";
	private String arabicName = "";
	private String englishName = "";
	private String referenceTo = "";
	private String fieldType = "";
	private String className;
	private String joinReferenceToBy;
	private String decimalScaleStrategy = "";
	private Boolean fake;
	private Boolean differentField ;
	@XmlTransient
	public DMPropWithParent originalPropWithParent;

	public DMProperty()
	{
		// TODO Auto-generated constructor stub
	}

	public String getDecimalScaleStrategy()
	{
		return decimalScaleStrategy;
	}

	public void setDecimalScaleStrategy(String decimalScaleStrategy)
	{
		this.decimalScaleStrategy = decimalScaleStrategy;
	}

	public String getColumnName()
	{
		return columnName;
	}

	public String fetchColumnName()
	{
		return ObjectChecker.getFirstNotEmptyObj(unionCTEAlias, columnName);
	}


	public void setColumnName(String columnName)
	{
		this.columnName = columnName;
	}

	public String getFullName()
	{
		return fullName;
	}

	public void setFullName(String fullName)
	{
		this.fullName = fullName;
	}

	public String getArabicName()
	{
		return arabicName;
	}

	public void setArabicName(String arabicName)
	{
		this.arabicName = arabicName;
	}

	public String getEnglishName()
	{
		return englishName;
	}

	public void setEnglishName(String englishName)
	{
		this.englishName = englishName;
	}

	public String getReferenceTo()
	{
		return referenceTo;
	}

	public void setReferenceTo(String referenceTo)
	{
		this.referenceTo = referenceTo;
	}

	public String getFieldType()
	{
		return fieldType;
	}

	public void setFieldType(String fieldType)
	{
		this.fieldType = fieldType;
	}

	public String getJoinReferenceToBy()
	{
		return joinReferenceToBy;
	}

	public void setJoinReferenceToBy(String joinReferenceToBy)
	{
		this.joinReferenceToBy = joinReferenceToBy;
	}

	@Override
	public int compareTo(DMProperty o)
	{
		if (o == null)
			return 1;
		return getFullName().compareTo(o.getFullName());
	}

	public void setClassName(String className)
	{
		this.className = className;
	}

	public String getClassName()
	{
		return className;
	}

	public Class fetchClass()
	{
		try
		{
			return Class.forName(getClassName());
		}
		catch (ClassNotFoundException e)
		{
			throw new RuntimeException(e);
		}
	}

	public DMProperty cloneToADifferentFullName(String newFullName)
	{
		DMProperty p = cloneData();
		p.setFullName(newFullName);
		return p;
	}

	public DMProperty cloneData()
	{
		DMProperty p = new DMProperty();
		p.setColumnName(getColumnName());
		p.setFullName(getFullName());
		p.setArabicName(getArabicName());
		p.setEnglishName(getEnglishName());
		p.setReferenceTo(getReferenceTo());
		p.setFieldType(getFieldType());
		p.setClassName(getClassName());
		p.setDecimalScaleStrategy(getDecimalScaleStrategy());
		p.setDifferentField(getDifferentField());
		p.setFake(getFake());
		p.setJoinReferenceToBy(getJoinReferenceToBy());
		p.setUnionCTEAlias(getUnionCTEAlias());
		return p;
	}

	public String fullNameToCamelCase()
	{
		return StringUtils.toCamelCaseAndReplaceDotsWith_(getFullName());
	}

	public DMProperty prefixWith(String prefixWith)
	{
		if (ObjectChecker.isEmptyOrNull(prefixWith))
			return this;
		return cloneToADifferentFullName(prefixWith + "." + getFullName());
	}

	public DMProperty changeTypeToReferenceAndAppendTypeToFullName(String manualJoin, DMPersister persister)
	{
		if (ObjectChecker.isEmptyOrNull(manualJoin))
			return this;
		DMProperty p = cloneToADifferentFullName(getFullName() + "#" + manualJoin);
		p.setFieldType(FieldType.Reference.name());
		p.setReferenceTo(DMEntity.extractManualJoinEntity(manualJoin));
		if (getColumnName().contains(","))//was generic reference
			p.setColumnName(StringUtils.csvLineToListWithEmpty(getColumnName()).get(3));
		if (manualJoin.contains("{"))
		{
			Map<String, Object> map = (Map<String, Object>) GenericValue.assistant.readJSON("{" + StringUtils.substringAfter(manualJoin, "{"),
					Map.class);
			String joinBy = (String) ObjectChecker.getFirstNotEmptyObj(map.get("joinBy"), map.get("joinby"));
			if (ObjectChecker.isEmptyOrNull(joinBy))
				throw new NaMaServiceExcepption(ResultDTO.fail("The expression " + manualJoin + " does not have joinBy field"));
			DMPropWithParent field = persister.findField(p.getReferenceTo(), joinBy, p.getFullName());
			if (ObjectChecker.areAllTrue(field.getProperty().fieldType.equals("Reference"), field.getJoins().size() > 1) || ObjectChecker.areAllTrue(
					!field.getProperty().fieldType.equals("Reference"), field.getJoins().size() > 0))
				throw new NaMaServiceExcepption(ResultDTO.fail(
						"The expression " + manualJoin + " uses the field " + joinBy + " which is not a direct field of the entity "
								+ p.getReferenceTo()));
			if (field.getProperty().getColumnName().contains(","))//was generic reference
				p.setJoinReferenceToBy(StringUtils.csvLineToList(field.getProperty().getColumnName()).get(3));
			else
				p.setJoinReferenceToBy(field.getProperty().getColumnName());
		}
		return p;
	}

	public HasId toHasId()
	{
		return this::getFullName;
	}

	public Boolean getFake()
	{
		return fake;
	}

	public void setFake(Boolean fake)
	{
		this.fake = fake;
	}

	public Boolean getDifferentField()
	{
		return differentField;
	}

	public void setDifferentField(Boolean differentField)
	{
		this.differentField = differentField;
	}

	public String getUnionCTEAlias()
	{
		return unionCTEAlias;
	}

	public void setUnionCTEAlias(String unionCTEAlias)
	{
		this.unionCTEAlias = unionCTEAlias;
	}
}
