package com.namasoft.common.utils.importer.data;

import com.namasoft.common.NaMaDTO;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.common.utils.importer.parser.DataParser;

import java.util.List;

@SuppressWarnings("serial")
public class Indicator extends NaMaDTO
{
	public static Indicator dataRecordOrError(List<String> errors)
	{
		return ObjectChecker.isEmptyOrNull(errors) ? dataRecord() : error();
	}

	public static enum IndicatorType
	{
		Commented, Inserted, RecordHeader, DetailHeader, DataRecord, EndDetail, Error
	}

	private IndicatorType type;
	private String headerId;

	private Indicator()
	{
	}

	private Indicator(IndicatorType type, String headerId)
	{
		this();
		this.type = type;
		this.headerId = headerId;
	}

	public static Indicator commented()
	{
		return new Indicator(IndicatorType.Commented, "");
	}

	public static Indicator inserted()
	{
		return new Indicator(IndicatorType.Inserted, "");
	}

	public static Indicator error()
	{
		return new Indicator(IndicatorType.Error, "");
	}

	public static Indicator dataRecord()
	{
		return new Indicator(IndicatorType.DataRecord, "");
	}

	public static Indicator recordHeader(String entityType)
	{
		return new Indicator(IndicatorType.RecordHeader, entityType);
	}

	public static Indicator detailHeader(String detailId)
	{
		return new Indicator(IndicatorType.DetailHeader, detailId);
	}

	public static Indicator endDetail()
	{
		return new Indicator(IndicatorType.EndDetail, "");
	}

	@Override
	public String toString()
	{
		switch (type)
		{
		case Commented:
			return "//";
		case DataRecord:
			return "";
		case DetailHeader:
			return DataParser.DETAILS_HEADER + headerId;
		case EndDetail:
			return DataParser.POP_LAST_DETAIL;
		case Inserted:
			return DataParser.INSERTED;
		case Error:
			return DataParser.ERROR;
		case RecordHeader:
			return DataParser.RECORD_HEADR + headerId;
		}
		throw new RuntimeException("Unhandled type: " + type);
	}

	public IndicatorType getType()
	{
		return type;
	}

	public void setType(IndicatorType type)
	{
		this.type = type;
	}

	public String getHeaderId()
	{
		return headerId;
	}

	public void setHeaderId(String headerId)
	{
		this.headerId = headerId;
	}

}
