package com.namasoft.common.utils.translation;

import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.common.utils.TomcatLibLoader;
import org.apache.commons.io.IOUtils;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

public class TranslationsFixer
{
	public static void main(String[] args) throws IOException
	{
		TomcatLibLoader.loadTomcatLibIfNeeded();
		//		int[] lines = {};
		//		if (lines.length > 0)
		//		{
		//			System.out.println("Please confirm you want to delete " + lines.length + " lines ");
		//			System.in.read();
		//		}
		//		removeLines("src/main/resources/text/cmn-fr.properties", lines);
		MessageTranslatorFromFile.fixingWhat = MessageTranslatorFromFile.FixingWhat.All;
		MessageTranslatorFromFile fr = MessageTranslatorFromFile.fromPhysicalFiles("src/main/resources/text/cmn-fr.properties", null, 1);
		MessageTranslatorFromFile.fixingWhat = MessageTranslatorFromFile.FixingWhat.None;
		MessageTranslatorFromFile ar = MessageTranslatorFromFile.fromPhysicalFiles("src/main/resources/text/cmn-ar.properties", null, 1);
		MessageTranslatorFromFile en = MessageTranslatorFromFile.fromPhysicalFiles("src/main/resources/text/cmn-en.properties", null, 1);
		List<String> missing = new ArrayList<>();
		List<String> missingFull = new ArrayList<>();
		List<String> concatenationsAndReferences = new ArrayList<>();
		for (int i = 0; i < ar.getKeys().size(); i++)
		{
			String key = ar.getKeys().get(i);

			if (fr.getArabicMap().get(key) == null)
			{
				String arValue = ar.getArabicMap().get(key).trim();
				String enValue = en.getArabicMap().get(key);
				if (arValue.startsWith("#") || arValue.startsWith("@"))
				{
					concatenationsAndReferences.add(key + "=" + arValue);
				}
				else
				{
					if (ObjectChecker.isEmptyOrNull(enValue) && key.contains(" "))
						enValue = key;
					missing.add(key + "=" + ObjectChecker.getFirstNotEmptyObj(enValue, arValue));
					missingFull.add(key + "\t" + arValue + "\t" + ObjectChecker.getFirstNotEmptyObj(enValue, arValue));
				}
			}
		}
		writeToFile(missing, "src/main/resources/text/cmn-fr-missing.properties");
		writeToFile(missingFull, "src/main/resources/text/cmn-fr-missing.tsv");
		writeToFile(concatenationsAndReferences, "src/main/resources/text/cmn-fr-references.properties");
		//		MessageTranslatorFromFile mfgAr = MessageTranslatorFromFile
		//				.fromPhysicalFiles("src/main/resources/text/mfg-ar.properties", "src/main/resources/text/mfg-ar.properties", 1);
		//		MessageTranslatorFromFile mfgEn = MessageTranslatorFromFile
		//				.fromPhysicalFiles("src/main/resources/text/mfg-en.properties", "src/main/resources/text/mfg-en.properties", 1);
	}

	private static void writeToFile(List<String> lines, String fileName) throws IOException
	{
		lines.sort(Comparator.naturalOrder());
		FileWriter writer = new FileWriter(fileName);
		IOUtils.writeLines(lines, "\n", writer);
		writer.close();
	}

	private static void removeLines(String file, int[] indices) throws IOException
	{
		List list = IOUtils.readLines(new FileInputStream(file), "utf-8");
		Arrays.sort(indices);
		for (int i = indices.length - 1; i >= 0; i--)
			list.remove(indices[i] - 1);
		FileOutputStream os = new FileOutputStream(file);
		IOUtils.writeLines(list, "\n", os, "utf-8");
		os.close();
	}
}
