package com.namasoft.taxauthority;

import jakarta.xml.bind.annotation.*;

@XmlRootElement
@XmlAccessorType(XmlAccessType.PROPERTY)
public class TaxAuthorityIssuerAddress extends TaxAuthorityAddress
{
	private String branchId;

	public String getBranchId()
	{
		return branchId;
	}

	public void setBranchId(String branchId)
	{
		this.branchId = branchId;
	}

	@Override
	public void copyFrom(TaxAuthorityAddress address)
	{
		super.copyFrom(address);
		if (!(address instanceof TaxAuthorityIssuerAddress))
			return;
		this.branchId = ((TaxAuthorityIssuerAddress) address).branchId;
	}

	public void updateBranchId(String branchId)
	{
		setBranchId(branchId);
	}

	public String fetchBranchId()
	{
		return getBranchId();
	}
}