/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.modules.supplychain.contracts.valueobjects;

import com.namasoft.common.flatobjects.EntityReferenceData;
import com.namasoft.common.flatobjects.IHasPriceListDefaultPrice;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.modules.supplychain.contracts.details.DTOSCMeasuresFactorsLine;
import com.namasoft.modules.supplychain.contracts.valueobjects.GeneratedDTOSupplyChainConfigurations;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.PROPERTY)
public class DTOSupplyChainConfigurations
extends GeneratedDTOSupplyChainConfigurations
implements Serializable,
IHasPriceListDefaultPrice {
    public BigDecimal calcMeasuresFactorForEntityType(String entityType, EntityReferenceData uom) {
        DTOSupplyChainConfigurations config = this;
        BigDecimal factor = config.getMeasuresFactor();
        List<DTOSCMeasuresFactorsLine> factorsLines = config.getMFactors();
        for (DTOSCMeasuresFactorsLine line : factorsLines) {
            if (ObjectChecker.isNotEmptyOrNull((Object)line.getUom()) && ObjectChecker.areNotEqual((Object)line.getUom(), (Object)uom) || !ObjectChecker.areEqual((Object)entityType, (Object)line.getEntityType())) continue;
            factor = line.getFactor();
            break;
        }
        if (ObjectChecker.isEmptyOrNull((Object)factor) || ObjectChecker.isZero((BigDecimal)factor)) {
            factor = BigDecimal.ONE;
        }
        return factor;
    }
}

