/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.mail.resolver;

import jakarta.activation.DataSource;
import jakarta.activation.FileDataSource;
import java.io.File;
import java.io.IOException;
import org.apache.commons.mail.resolver.DataSourceBaseResolver;

public class DataSourceFileResolver
extends DataSourceBaseResolver {
    private final File baseDir;

    public DataSourceFileResolver() {
        this.baseDir = new File(".");
    }

    public DataSourceFileResolver(File baseDir) {
        this.baseDir = baseDir;
    }

    public DataSourceFileResolver(File baseDir, boolean lenient) {
        super(lenient);
        this.baseDir = baseDir;
    }

    public File getBaseDir() {
        return this.baseDir;
    }

    @Override
    public DataSource resolve(String resourceLocation) throws IOException {
        return this.resolve(resourceLocation, this.isLenient());
    }

    @Override
    public DataSource resolve(String resourceLocation, boolean isLenient) throws IOException {
        FileDataSource result = null;
        if (!this.isCid(resourceLocation)) {
            File file = new File(resourceLocation);
            if (!file.isAbsolute()) {
                File file2 = file = this.getBaseDir() != null ? new File(this.getBaseDir(), resourceLocation) : new File(resourceLocation);
            }
            if (file.exists()) {
                result = new FileDataSource(file);
            } else if (!isLenient) {
                throw new IOException("Cant resolve the following file resource :" + file.getAbsolutePath());
            }
        }
        return result;
    }
}

