/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.modules.basic.contracts.entities;

import com.namasoft.common.constants.Language;
import com.namasoft.common.flatobjects.EntityReferenceData;
import com.namasoft.common.implementationrepo.DTOImplRepo;
import com.namasoft.common.implementationrepo.ImplRepoCodeAndNames;
import com.namasoft.common.utilities.CollectionsUtility;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.common.utilities.StringUtils;
import com.namasoft.common.utils.translation.TranslationUtil;
import com.namasoft.contracts.common.dtos.DTOLargeData;
import com.namasoft.modules.basic.contracts.entities.GeneratedDTOImplementationRepository;
import com.namasoft.modules.commonbasic.contracts.details.DTOImplRepositoryKeywordLine;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.Serializable;
import java.util.List;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.PROPERTY)
public class DTOImplementationRepository
extends GeneratedDTOImplementationRepository
implements Serializable {
    public DTOImplRepo toDTOImplRepoWithContents() {
        DTOImplRepo repo = this.toDTOImplRepo();
        repo.setReportContent(this.getContents());
        return repo;
    }

    public DTOImplRepo toDTOImplRepo() {
        DTOImplRepo i = new DTOImplRepo();
        i.setId(this.getId());
        i.setReportType(this.getReportType());
        i.setScreenshot(DTOImplementationRepository.downloadURL(this.getScreenshot()));
        i.setPdfSample(DTOImplementationRepository.downloadURL(this.getPdfSample()));
        i.setAttachment1(DTOImplementationRepository.downloadURL(this.getAttachment1()));
        i.setAttachment2(DTOImplementationRepository.downloadURL(this.getAttachment2()));
        i.setAttachment3(DTOImplementationRepository.downloadURL(this.getAttachment3()));
        i.setAttachment4(DTOImplementationRepository.downloadURL(this.getAttachment4()));
        i.setAttachment5(DTOImplementationRepository.downloadURL(this.getAttachment5()));
        i.setRemarks(this.getRemarks());
        i.setCode(this.getCode());
        i.setName1(this.getName1());
        i.setModuleName(this.getModuleName());
        i.setName2(this.getName2());
        i.setRelatedToEntity1(this.translate(this.getRelatedToEntity1()));
        i.setRelatedToEntity2(this.translate(this.getRelatedToEntity2()));
        i.setRelatedToModule1(this.translate(this.getRelatedToModule1()));
        i.setRelatedToModule2(this.translate(this.getRelatedToModule2()));
        i.setSystemReport(this.getSystemReport());
        i.setReviewedAndApproved(this.getReviewedAndApproved());
        i.setKeywords(StringUtils.concatNonEmptyObjectsAsCSV((List)CollectionsUtility.convert(this.getKeywordLines(), DTOImplRepositoryKeywordLine::csvKeyword)));
        i.setGroup(ImplRepoCodeAndNames.fromRef((EntityReferenceData)this.getGroup()));
        i.setReportGroup(ImplRepoCodeAndNames.fromRef((EntityReferenceData)this.getReportGroup()));
        i.setType(this.getType());
        return i;
    }

    private ImplRepoCodeAndNames translate(String str) {
        if (ObjectChecker.isEmptyOrNull((Object)str)) {
            return null;
        }
        return new ImplRepoCodeAndNames(str, TranslationUtil.translate((Language)Language.Arabic, (String)str, (Object[])new Object[0]), TranslationUtil.translate((Language)Language.English, (String)str, (Object[])new Object[0]));
    }

    public static String downloadURL(DTOLargeData attachment) {
        if (attachment == null || attachment.getAttachmentInfo() == null || ObjectChecker.isEmptyOrNull((Object)attachment.getAttachmentInfo().getFileId())) {
            return null;
        }
        String url = "file.download?fileID=" + attachment.getAttachmentInfo().getFileId() + "&entitytype=&locale=ar&filename=" + attachment.getAttachmentInfo().getFileName();
        return url;
    }
}

