/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.namacontrols;

import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.namacontrols.IHasFont;
import com.namasoft.pos.application.POSResourcesUtil;
import com.namasoft.pos.util.POSImgUtil;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.input.MouseEvent;

public class NamaButton
extends Button
implements IHasFont {
    private String originalText;

    public NamaButton(String text) {
        super(POSResourcesUtil.id(text, new Object[0]));
        this.originalText = text;
        this.addEventHandler(MouseEvent.MOUSE_ENTERED, event -> {
            DropShadow shadow = new DropShadow();
            this.setEffect((Effect)shadow);
        });
        this.addEventHandler(MouseEvent.MOUSE_EXITED, event -> this.setEffect(null));
        this.setWrapText(true);
    }

    public NamaButton() {
        this("");
    }

    public NamaButton(String text, String namaStyle) {
        this(text);
        this.setStyle(namaStyle);
        this.setWrapText(true);
    }

    @Override
    public void refreshContent() {
        this.setText(POSResourcesUtil.id(ObjectChecker.toStringOrEmpty((Object)this.originalText), new Object[0]));
    }

    public void setOriginalText(String originalText) {
        this.originalText = originalText;
        this.setText(POSResourcesUtil.id(originalText, new Object[0]));
    }

    public String getOriginalText() {
        return this.originalText;
    }

    public void setSVGIcon(String svgName) {
        this.getStyleClass().add((Object)"icon");
        this.setGraphic((Node)POSImgUtil.createSVGImageView(svgName));
    }
}

