/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.namacontrols;

import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.namacontrols.NamaDialog;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Task;
import javafx.concurrent.Worker;
import javafx.scene.Node;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ProgressBar;

public class NamaProgressBarDialog
extends NamaDialog<ButtonType> {
    private ProgressBar progressBar;
    private boolean closeAfterTask;

    public NamaProgressBarDialog() {
        super("");
    }

    public ProgressBar getProgressBar() {
        return this.progressBar;
    }

    public void constructNamaProgressBarDialog(Task task) {
        this.progressBar = new ProgressBar(0.0);
        this.progressBar.setProgress(0.0);
        this.progressBar.setMaxHeight(50.0);
        this.getDialogPane().setPrefWidth(400.0);
        this.getDialogPane().setPrefHeight(170.0);
        this.content((Node)this.progressBar);
        this.addCancelButton("");
        this.fetchCancelBtn().setDisable(true);
        this.setOnShown(e -> this.runTask(task));
    }

    private void runTask(Task task) {
        task.stateProperty().addListener((observable, oldValue, newValue) -> {
            if (ObjectChecker.isAnyEqualToFirst((Object)newValue, (Object[])new Object[]{Worker.State.SUCCEEDED, Worker.State.CANCELLED, Worker.State.FAILED}) && this.closeAfterTask) {
                this.close();
            }
            this.fetchCancelBtn().setDisable(false);
        });
        this.getDialogPane().headerTextProperty().bind((ObservableValue)task.titleProperty());
        this.progressBar.progressProperty().bind((ObservableValue)task.progressProperty());
        this.setOnCloseRequest(e -> task.cancel());
        Thread thread = new Thread((Runnable)task, "removeExpiredDocs");
        thread.setPriority(10);
        thread.setDaemon(true);
        thread.start();
    }

    public void closeAfterTask() {
        this.closeAfterTask = true;
        this.fetchCancelBtn().setVisible(false);
    }
}

