/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.namacontrols;

import com.namasoft.common.NamaSingleValue;
import com.namasoft.common.constants.Language;
import com.namasoft.common.utilities.NaMaLogger;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.common.utilities.StringUtils;
import com.namasoft.erp.guiserver.ServiceLoginProvider;
import com.namasoft.namacontrols.NamaButton;
import com.namasoft.namacontrols.NamaText;
import com.namasoft.namacontrols.NamaVBox;
import com.namasoft.pos.application.POSResourcesUtil;
import com.namasoft.pos.application.POSTooltip;
import com.namasoft.pos.util.POSGeneralSettings;
import com.namasoft.pos.util.POSResult;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ContentDisplay;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.Duration;

public class POSErrorAndInfoMessagesUtil {
    private static POSTooltip errorTooltip;
    private static POSTooltip infoTooltip;
    private static Timeline timer;
    private static StringBuilder msgBuilder;
    private static NamaSingleValue<POSResult> resultContainer;
    private static NamaText errorMsgTextController;
    private static NamaText infoMsgTextController;

    public static void showError(POSResult result, Stage stage) {
        POSErrorAndInfoMessagesUtil.initTooltipAndTimeIfNeeded();
        POSErrorAndInfoMessagesUtil.show(errorTooltip, errorMsgTextController, result, stage);
    }

    public static void showError(String message, Stage stage) {
        POSErrorAndInfoMessagesUtil.initTooltipAndTimeIfNeeded();
        POSResult posResult = new POSResult();
        posResult.failure(message, new Object[0]);
        POSErrorAndInfoMessagesUtil.show(errorTooltip, errorMsgTextController, posResult, stage);
    }

    public static void showInfo(POSResult result, Stage stage) {
        POSErrorAndInfoMessagesUtil.initTooltipAndTimeIfNeeded();
        POSErrorAndInfoMessagesUtil.show(infoTooltip, infoMsgTextController, result, stage);
    }

    public static void showInfo(String message, Stage stage) {
        POSErrorAndInfoMessagesUtil.initTooltipAndTimeIfNeeded();
        POSResult posResult = new POSResult();
        String translatedMsg = POSResourcesUtil.id(message, new Object[0]);
        posResult.setArMessage(translatedMsg);
        posResult.setEnMessage(translatedMsg);
        POSErrorAndInfoMessagesUtil.show(infoTooltip, infoMsgTextController, posResult, stage);
    }

    private static void show(POSTooltip toolTip, NamaText text, POSResult result, Stage stage) {
        String[] msgs = POSErrorAndInfoMessagesUtil.resultToMessage(result).split("\n");
        int rowNo = 1;
        for (String msg : msgs) {
            if (ObjectChecker.isEmptyOrNull((Object)msg)) continue;
            msgBuilder.append(rowNo + "- " + msg + "\n");
            ++rowNo;
        }
        if (stage == null) {
            NaMaLogger.error((String)"Can not show error because stage not yet initialized: {0}", (Object[])new Object[]{msgBuilder.toString()});
            return;
        }
        if (ObjectChecker.isEmptyOrNull((Object)msgBuilder.toString())) {
            return;
        }
        resultContainer.setValue((Object)result);
        text.setText(msgBuilder.toString());
        text.setWrappingWidth(stage.getWidth() / 1.3);
        toolTip.setPrefWidth(stage.getWidth() * 0.25);
        toolTip.setMaxWidth(stage.getWidth() / 1.5);
        toolTip.show((Window)stage);
        timer.playFromStart();
    }

    private static void initTooltipAndTimeIfNeeded() {
        if (errorTooltip != null) {
            return;
        }
        errorTooltip = POSErrorAndInfoMessagesUtil.createTooltip();
        errorTooltip.setId("error-tool-tip");
        infoTooltip = POSErrorAndInfoMessagesUtil.createTooltip();
        infoTooltip.setId("info-tool-tip");
        timer = new Timeline(new KeyFrame[]{new KeyFrame(Duration.seconds((double)POSGeneralSettings.getMessageDisplayTime()), event -> {
            errorTooltip.hide();
            infoTooltip.hide();
        }, new KeyValue[0])});
        errorTooltip.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
        errorTooltip.setGraphic((Node)POSErrorAndInfoMessagesUtil.createTooltipGraphics(errorMsgTextController));
        infoTooltip.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
        infoTooltip.setGraphic((Node)POSErrorAndInfoMessagesUtil.createTooltipGraphics(infoMsgTextController));
    }

    private static POSTooltip createTooltip() {
        POSTooltip tooltip = new POSTooltip("");
        tooltip.setAutoFix(true);
        tooltip.setAutoHide(true);
        tooltip.setHideOnEscape(true);
        tooltip.centerOnScreen();
        tooltip.setWrapText(true);
        tooltip.addEventHandler(KeyEvent.KEY_PRESSED, e -> tooltip.hide());
        tooltip.setOnHiding(e -> msgBuilder.setLength(0));
        return tooltip;
    }

    private static Pane createTooltipGraphics(NamaText text) {
        NamaButton copyError = new NamaButton();
        copyError.setSVGIcon("tooltip-msg-copy.svg");
        copyError.setId("error-msg-copy-btn");
        copyError.setOnMouseClicked(event -> {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            if (ObjectChecker.isFalseOrNull((Boolean)ServiceLoginProvider.getTrackLogs())) {
                clipboard.setContents(new StringSelection(msgBuilder.toString()), null);
            } else {
                clipboard.setContents(new StringSelection(StringUtils.toCSVLineWithSepWithoutEmptyObjects((String)"\n***************************\n", (Object[])new Object[]{msgBuilder.toString(), ((POSResult)resultContainer.getValue()).getLog()})), null);
            }
        });
        text.getStyleClass().add((Object)"massage-text");
        NamaVBox.setVgrow((Node)text, (Priority)Priority.ALWAYS);
        StackPane container = new StackPane(new Node[]{text, copyError});
        container.getStyleClass().add((Object)"massage-text-container");
        StackPane.setAlignment((Node)copyError, (Pos)Pos.TOP_RIGHT);
        return container;
    }

    private static String resultToMessage(POSResult result) {
        if (ObjectChecker.areEqual((Object)POSResourcesUtil.getCurrentLang(), (Object)Language.Arabic)) {
            return result.getArMessage();
        }
        return result.getEnMessage();
    }

    static {
        msgBuilder = new StringBuilder();
        resultContainer = new NamaSingleValue(null);
        errorMsgTextController = new NamaText("", new Object[0]);
        infoMsgTextController = new NamaText("", new Object[0]);
    }
}

