/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.namacontrols;

import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.modules.namapos.contracts.common.DTOPOSConfiguration;
import com.namasoft.modules.namapos.enums.FavouriteItemDisplayMethod;
import com.namasoft.namacontrols.NamaButton;
import com.namasoft.pos.application.POSResourcesUtil;
import com.namasoft.pos.application.POSTotalsShowPanel;
import com.namasoft.pos.application.POSUISettingsUtil;
import com.namasoft.pos.application.TinyColor;
import com.namasoft.pos.domain.POSLiteMasterFile;
import com.namasoft.pos.domain.POSMasterFile;
import javafx.scene.Node;
import javafx.scene.control.ContentDisplay;
import javafx.scene.image.ImageView;

public abstract class POSFavouriteBtn<T extends POSMasterFile>
extends NamaButton {
    private boolean hasNoChildren = false;
    protected POSLiteMasterFile currentRecord;
    private boolean resetBreadCrumbWithAction = false;

    public POSLiteMasterFile getCurrentRecord() {
        return this.currentRecord;
    }

    public boolean hasNoChildren() {
        return this.hasNoChildren;
    }

    public void setHasNoChildren(boolean hasNoChildren) {
        this.hasNoChildren = hasNoChildren;
    }

    public POSFavouriteBtn(POSLiteMasterFile currentRecord) {
        this.setWrapText(true);
        this.currentRecord = currentRecord;
        this.setId("favourite-item");
        this.setPrefWidth(POSUISettingsUtil.getPosUISettingsOptions().fetchFavouriteItemBtnWidth());
        this.wrapTextProperty().setValue(Boolean.valueOf(true));
    }

    protected void setBGColor() {
        String bgColor = this.calcFavouriteBgColor(this.currentRecord);
        if (bgColor == null) {
            return;
        }
        String textFill = "#000000";
        if (TinyColor.isDark(bgColor)) {
            textFill = "#ffffff";
        }
        this.setStyle("-fx-background-color: " + bgColor + "; -fx-text-fill: " + textFill + ";");
    }

    private String calcFavouriteBgColor(POSLiteMasterFile currentRecord) {
        String bgColor = null;
        if (ObjectChecker.isEmptyOrNull((Object)currentRecord) || ObjectChecker.isEmptyOrNull((Object)currentRecord.getColorCode())) {
            return bgColor;
        }
        if (ObjectChecker.isFalseOrNull((Boolean)POSResourcesUtil.fetchMainRegister().getUseFavouritesColorCodeAsBG())) {
            return bgColor;
        }
        return currentRecord.getColorCode();
    }

    public void btnByImg(POSLiteMasterFile item) {
        double favouriteBtnW = POSUISettingsUtil.getPosUISettingsOptions().fetchFavouriteItemBtnWidth();
        double favouriteBtnH = POSUISettingsUtil.getPosUISettingsOptions().fetchFavouriteItemBtnHeight();
        DTOPOSConfiguration posConfig = POSResourcesUtil.fetchPOSConfig();
        this.setText(item.nameByLanguage());
        if (ObjectChecker.areEqual((Object)posConfig.getFavItemDisplayMethod(), (Object)FavouriteItemDisplayMethod.NameOnly.toString())) {
            return;
        }
        if (item.getHasImage().booleanValue() && POSResourcesUtil.getUseItemsImage()) {
            ImageView imgView = new ImageView();
            Double imgW = favouriteBtnW;
            Double imgH = favouriteBtnH - this.fetchImgButtonTextHeight();
            POSTotalsShowPanel.fetchItemImageIntoView_(item.getId().toString(), this.currentRecord.getNamaEntityType(), imgW.intValue(), null, image -> {
                if (ObjectChecker.isEmptyOrNull((Object)image)) {
                    return;
                }
                this.setId("favourite-item-with-image");
                if (image.getWidth() > imgW) {
                    imgView.setFitWidth(imgW.doubleValue());
                } else {
                    imgView.setFitWidth(image.getWidth());
                }
                if (image.getHeight() > imgH) {
                    imgView.setFitHeight(imgH.doubleValue());
                } else {
                    imgView.setFitHeight(image.getHeight() - this.fetchImgButtonTextHeight());
                }
                if (ObjectChecker.isNotEmptyOrNull((Object)image)) {
                    if (ObjectChecker.areEqual((Object)posConfig.getFavItemDisplayMethod(), (Object)FavouriteItemDisplayMethod.ImageOnly.toString())) {
                        this.setText("");
                    }
                    imgView.setImage(image);
                    imgView.setPreserveRatio(true);
                    imgView.setSmooth(true);
                    imgView.setStyle("-fx-background-color: transparent;");
                    this.setGraphic((Node)imgView);
                    this.setContentDisplay(ContentDisplay.TOP);
                }
            });
        }
    }

    private double fetchImgButtonTextHeight() {
        DTOPOSConfiguration posConfig = POSResourcesUtil.fetchPOSConfig();
        if (ObjectChecker.areEqual((Object)posConfig.getFavItemDisplayMethod(), (Object)FavouriteItemDisplayMethod.ImageOnly.toString())) {
            return 0.0;
        }
        return 35.0;
    }

    public void setResetBreadCrumbWithAction(boolean resetBreadCrumbWithAction) {
        this.resetBreadCrumbWithAction = resetBreadCrumbWithAction;
    }

    public boolean isResetBreadCrumbWithAction() {
        return this.resetBreadCrumbWithAction;
    }

    @Override
    public void refreshContent() {
        this.setText(this.currentRecord.nameByLanguage());
    }
}

