/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.namacontrols;

import com.namasoft.common.utilities.Callback;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.namacontrols.NamaComboBox;
import com.namasoft.namacontrols.NamaHBox;
import com.namasoft.namacontrols.NamaLabel;
import com.namasoft.namacontrols.NamaSearchBox;
import com.namasoft.pos.application.IHasToolBar;
import com.namasoft.pos.application.POSPaymentReciptScreen;
import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.application.POSResourcesUtil;
import com.namasoft.pos.application.POSSavable;
import com.namasoft.pos.domain.POSMasterFile;
import com.namasoft.pos.domain.entities.POSCreditNote;
import com.namasoft.pos.domain.entities.POSCustomer;
import com.namasoft.pos.domain.entities.POSEmployee;
import com.namasoft.pos.domain.entities.POSGenReference;
import com.namasoft.pos.domain.entities.POSLocation;
import com.namasoft.pos.domain.entities.POSRegistery;
import com.namasoft.pos.domain.entities.POSVendor;
import com.namasoft.pos.domain.entities.PosCancelReservation;
import java.util.List;
import java.util.stream.Collectors;
import javafx.beans.Observable;
import javafx.scene.Node;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.util.StringConverter;

public class POSGenericRefSearchBox
extends NamaHBox {
    private final IHasToolBar screen;
    private NamaComboBox<String> typeCombo;
    private NamaSearchBox refField;
    private List<String> allowedValues;
    private boolean lineRef = false;
    private Callback<Observable> onRefSelection;
    private final Label label;
    private boolean showNameField = false;

    public POSGenericRefSearchBox(IHasToolBar screen, String label) {
        this(screen, (Callback<Observable>)Callback.NULL, label, null);
    }

    public POSGenericRefSearchBox(IHasToolBar screen, Callback<Observable> onRefSelection, List<String> allowedValues) {
        this(screen, onRefSelection, "ref", allowedValues);
    }

    public POSGenericRefSearchBox(IHasToolBar screen, Callback<Observable> onRefSelection, String label, List<String> allowedValues) {
        this.screen = screen;
        this.onRefSelection = onRefSelection;
        this.label = new NamaLabel(label);
        this.allowedValues = allowedValues;
        this.draw(label);
    }

    public void setLineRef(boolean lineRef) {
        this.lineRef = lineRef;
    }

    public boolean isLineRef() {
        return this.lineRef;
    }

    public void setAllowedValues(List<String> allowedValues) {
        this.allowedValues = allowedValues;
    }

    public Label getRefLabel() {
        return this.label;
    }

    public void setOnRefSelection(Callback<Observable> onRefSelection) {
        this.onRefSelection = onRefSelection;
    }

    public void draw(String label) {
        this.typeCombo = new NamaComboBox(this.screen, "ref.entityType");
        this.refField = new NamaSearchBox(POSGenReference.class, this.screen, label, this.screen.fetchStage(), true);
        this.refField.getCodeBox().setPrefWidth(120.0);
        this.refField.getCodeBox().textProperty().addListener(e -> {
            if (this.onRefSelection != null) {
                this.onRefSelection.done((Object)e);
            }
        });
        this.typeCombo.setConverter((StringConverter)new StringConverter<String>(this){

            public String toString(String object) {
                return POSResourcesUtil.id(object, new Object[0]);
            }

            public String fromString(String string) {
                return string;
            }
        });
        this.typeCombo.setStyle("-fx-font-size: 16.0;");
        this.typeCombo.setPrefWidth(120.0);
        if (ObjectChecker.isEmptyOrNull(this.allowedValues)) {
            this.typeCombo.getItems().addAll((Object[])new String[]{"Register", "Employee", "Customer", "Vendor"});
        }
        List<String> posGenRefTypes = ObjectChecker.isNotEmptyOrNull(this.allowedValues) ? this.allowedValues : POSResourcesUtil.fetchPosGenRef();
        posGenRefTypes = posGenRefTypes.stream().filter(t -> !this.typeCombo.getItems().contains((Object)POSPaymentReciptScreen.namaWithPosSubsidType(t))).collect(Collectors.toList());
        this.typeCombo.getItems().addAll(posGenRefTypes);
        this.typeCombo.getSelectionModel().selectFirst();
        this.typeCombo.setOnAction(e -> this.onTypeValueChanged());
        this.onTypeValueChanged();
        this.getChildren().addAll((Object[])new Node[]{this.typeCombo, this.refField});
    }

    private void onTypeValueChanged() {
        this.refField.setOnKlass(POSGenericRefSearchBox.fetchKlassByType((String)this.typeCombo.getValue()));
        this.refField.setCustomeType((String)this.typeCombo.getValue());
        if (!this.showNameField) {
            this.refField.hideName();
        } else {
            this.refField.showName();
        }
        this.refField.clear();
    }

    public static Class<? extends POSSavable> fetchKlassByType(String type) {
        if (type == null) {
            return null;
        }
        return switch (type) {
            case "Register" -> POSRegistery.class;
            case "Employee" -> POSEmployee.class;
            case "Customer" -> POSCustomer.class;
            case "Vendor" -> POSVendor.class;
            case "Locator" -> POSLocation.class;
            case "POSCreditNote", "NamaPOSCreditNote" -> POSCreditNote.class;
            case "PosCancelReservation" -> PosCancelReservation.class;
            default -> POSGenReference.class;
        };
    }

    public void clear_() {
        this.refField.clear();
        this.typeCombo.clear();
    }

    public POSMasterFile getReference() {
        String code = this.refField.getCodeBox().getText();
        if (ObjectChecker.isEmptyOrNull((Object)code)) {
            return null;
        }
        String type = (String)this.typeCombo.getValue();
        Class<? extends POSSavable> klassByType = POSGenericRefSearchBox.fetchKlassByType(type);
        if (klassByType == null) {
            return null;
        }
        return POSPersister.findByCode(klassByType, code);
    }

    public NamaSearchBox getRefField() {
        return this.refField;
    }

    public ComboBox<String> getTypeCombo() {
        return this.typeCombo;
    }

    public void setType(String type) {
        if (this.typeCombo == null) {
            return;
        }
        this.typeCombo.getSelectionModel().select((Object)type);
    }

    public String getType() {
        return (String)this.typeCombo.getSelectionModel().getSelectedItem();
    }

    public void updateFromRecord(POSMasterFile masterFile) {
        if (this.refField == null) {
            return;
        }
        this.refField.updateFromRecord(masterFile);
    }

    public void refresh() {
        this.clear_();
        this.typeCombo.getSelectionModel().selectFirst();
    }

    public void setShowNameField(boolean showNameField) {
        this.showNameField = showNameField;
    }
}

