/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.namacontrols;

import com.namasoft.common.utilities.ObjectChecker;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.layout.GridPane;

public class POSGridUtil {
    public static void focusNextRowFirstNode(int row, GridPane grid, Control nextControl) {
        if (row > POSGridUtil.getRowCount(grid) - 1) {
            if (nextControl != null) {
                nextControl.requestFocus();
            }
            return;
        }
        Node nextNode = POSGridUtil.getNodeByRowColumnIndex(row, 1, grid);
        if (nextNode == null) {
            POSGridUtil.focusNextRowFirstNode(row + 1, grid, nextControl);
        }
        if (nextNode != null) {
            nextNode.requestFocus();
        }
    }

    public static int getRowCount(GridPane pane) {
        int numRows = pane.getRowConstraints().size();
        for (int i = 0; i < pane.getChildren().size(); ++i) {
            Integer rowIndex;
            Node child = (Node)pane.getChildren().get(i);
            if (!child.isManaged() || (rowIndex = GridPane.getRowIndex((Node)child)) == null) continue;
            numRows = Math.max(numRows, rowIndex + 1);
        }
        return numRows;
    }

    public static int getRowsCountInCol(GridPane pane, int colIndex) {
        List nodesInColumn = pane.getChildren().stream().filter(child -> child.isManaged() && GridPane.getColumnIndex((Node)child) == colIndex).collect(Collectors.toList());
        return ObjectChecker.isEmptyOrNull(nodesInColumn) ? 0 : nodesInColumn.size();
    }

    public static int getColCount(GridPane pane) {
        int numCols = pane.getColumnConstraints().size();
        for (int i = 0; i < pane.getChildren().size(); ++i) {
            Integer columnIndex;
            Node child = (Node)pane.getChildren().get(i);
            if (!child.isManaged() || (columnIndex = GridPane.getColumnIndex((Node)child)) == null) continue;
            numCols = Math.max(numCols, columnIndex + 1);
        }
        return numCols;
    }

    public static Node getNodeByRowColumnIndex(int row, int column, GridPane gridPane) {
        Node result = null;
        ObservableList childrens = gridPane.getChildren();
        for (Node node : childrens) {
            if (GridPane.getRowIndex((Node)node) != row) continue;
            if (GridPane.getColumnIndex((Node)node) != column) continue;
            result = node;
            break;
        }
        return result;
    }

    public static void deleteColFromGrid(GridPane grid, int col, boolean reOrderNextCols) {
        HashSet<Node> deleteNodes = new HashSet<Node>();
        for (Node child : grid.getChildren()) {
            int c;
            Integer colIndex = GridPane.getColumnIndex((Node)child);
            int n = c = colIndex == null ? 0 : colIndex;
            if (c > col) {
                if (!reOrderNextCols) break;
                GridPane.setColumnIndex((Node)child, (Integer)(c - 1));
                continue;
            }
            if (c != col) continue;
            deleteNodes.add(child);
        }
        grid.getChildren().removeAll(deleteNodes);
    }
}

