/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.namacontrols;

import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.namacontrols.NamaHBox;
import com.namasoft.namacontrols.NamaLabel;
import com.namasoft.namacontrols.POSLabeledField;
import javafx.scene.Node;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;

public class POSLabeledLabel
extends POSLabeledField {
    private NamaLabel label;

    public POSLabeledLabel(String relatedToField, String initialValue) {
        super(relatedToField);
        this.setId("labeled-label");
        this.label = new NamaLabel();
        this.label.setId("labeled-field");
        this.label.setText(initialValue);
        NamaHBox.setHgrow((Node)this.getLabel(), (Priority)Priority.ALWAYS);
        NamaHBox.setHgrow((Node)this.label, (Priority)Priority.ALWAYS);
        this.getChildren().addAll((Object[])new Node[]{this.getLabel(), this.label});
        this.setSpacing(5.0);
    }

    public POSLabeledLabel(String relatedToField) {
        this(relatedToField, "");
    }

    @Override
    public Region getField() {
        return this.label;
    }

    @Override
    public void setValue(Object value) {
        this.label.setText(ObjectChecker.toStringOrEmpty((Object)value));
    }

    @Override
    public Object getValue() {
        return this.label.getText();
    }

    public void style(String style) {
        this.getLabel().setStyle(this.getLabel().getStyle() + style);
        this.getField().setStyle(this.getLabel().getStyle() + style);
    }
}

