/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.namacontrols;

import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.namacontrols.NamaSearchBox;
import com.namasoft.namacontrols.POSErrorAndInfoMessagesUtil;
import com.namasoft.namacontrols.POSHallsTablesButton;
import com.namasoft.namacontrols.POSHallsTablesViewer;
import com.namasoft.pos.application.AbsPosSalesScreen;
import com.namasoft.pos.application.MultiTableDialog;
import com.namasoft.pos.application.POSResourcesUtil;
import com.namasoft.pos.application.POSTooltip;
import com.namasoft.pos.application.POSUISettingsUtil;
import com.namasoft.pos.domain.details.PosTableLine;
import com.namasoft.pos.domain.entities.POSTable;
import com.namasoft.pos.domain.entities.PosTableEntry;
import com.namasoft.pos.util.POSImgUtil;
import com.namasoft.pos.util.POSResult;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import javafx.scene.image.ImageView;

public class POSTableButton
extends POSHallsTablesButton {
    private POSTable table;
    private boolean isBusy = false;
    private boolean isReserved = false;
    private boolean selected = false;

    public POSTableButton(POSTable table, POSHallsTablesViewer viewer) {
        super(table);
        this.table = table;
        MultiTableDialog relatedTableDialog = null;
        if (viewer != null) {
            relatedTableDialog = viewer.getSearchBox().getRelatedTableDialog();
        }
        if (relatedTableDialog != null) {
            List<PosTableLine> tableLines = viewer.getTableLines();
            this.setState(tableLines);
        } else {
            this.setState(new ArrayList<PosTableLine>());
        }
        POSResult posResult = new POSResult();
        this.setOnAction(event -> {
            this.selected = !this.selected;
            this.currentTablesStyle();
            NamaSearchBox searchBox = viewer.getSearchBox();
            if (this.isBusy) {
                posResult.failure("Busy table", new Object[0]);
            }
            if (this.isReserved) {
                posResult.failure("Reserved table", new Object[0]);
            }
            if (posResult.isFailed().booleanValue()) {
                POSErrorAndInfoMessagesUtil.showError(posResult, searchBox.getScreen().fetchStage());
            } else if (searchBox.getRelatedTableDialog() == null) {
                searchBox.updateFromRecord(table);
            } else {
                viewer.addOrRemoveTable(table, this.selected);
            }
            if (ObjectChecker.isFalseOrNull((Boolean)POSUISettingsUtil.getPosUISettingsOptions().getUseMultiTableAsDefault())) {
                viewer.close();
            }
        });
    }

    @Override
    protected ImageView fetchButtonImage() {
        return POSImgUtil.createSVGImageView("table.svg");
    }

    public boolean isBusy() {
        return this.isBusy;
    }

    public boolean isReserved() {
        return this.isReserved;
    }

    public POSTable getTable() {
        return this.table;
    }

    public boolean isSelected() {
        return this.selected;
    }

    private void setState(List<PosTableLine> tableLines) {
        AbsPosSalesScreen currentScreen;
        PosTableEntry reservationEntry;
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd");
        SimpleDateFormat format = new SimpleDateFormat("yy/MM/dd HH:mm");
        PosTableEntry busyEntry = POSResourcesUtil.fetchTableBusyEntry(this.table);
        if (ObjectChecker.isNotEmptyOrNull((Object)busyEntry)) {
            this.setStyle("-fx-background-color: red;-fx-text-fill: #000;-fx-font-size: 13");
            String invoiceDesc = busyEntry.getDocumentCode();
            if (ObjectChecker.isNotEmptyOrNull((Object)invoiceDesc)) {
                this.setText(this.getText() + " - " + dateFormat.format(busyEntry.getValueDate()) + "\n" + invoiceDesc);
            }
            this.isBusy = true;
        }
        if (ObjectChecker.isNotEmptyOrNull((Object)(reservationEntry = POSResourcesUtil.fetchTableReservedEntry(this.table, (currentScreen = (AbsPosSalesScreen)POSResourcesUtil.currentScreen).fetchReservationFromTime(), currentScreen.fetchReservationToTime())))) {
            this.setStyle("-fx-background-color: yellow;-fx-text-fill: #000;-fx-font-size: 10;-fx-font-weight: bold");
            String orderDesc = reservationEntry.getDocumentCode() + " from\n" + format.format(reservationEntry.getReservationFrom()) + " to " + format.format(reservationEntry.getReservationTo());
            if (ObjectChecker.isNotEmptyOrNull((Object)orderDesc)) {
                this.setText(this.getText() + " - " + orderDesc);
            }
            this.isReserved = true;
        } else if (!this.isReserved & !this.isBusy) {
            this.setText(this.getTextId());
            if (ObjectChecker.isNotEmptyOrNull(tableLines) && tableLines.stream().filter(l -> ObjectChecker.areEqual((Object)l.getTableID(), (Object)this.table.getId())).count() > 0L) {
                this.selected = true;
                this.currentTablesStyle();
            }
        }
        this.setTooltip(new POSTooltip(this.getText()));
    }

    private void currentTablesStyle() {
        if (this.isBusy || this.isReserved) {
            return;
        }
        if (this.selected) {
            this.setStyle("-fx-background-color: #037F91FF");
        } else {
            this.setStyle("-fx-background-color: -fx-main-color");
        }
    }
}

