/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.namacontrols;

import com.namasoft.namacontrols.NamaLabel;
import com.namasoft.pos.application.POSResourcesUtil;
import java.util.Map;
import java.util.Optional;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.stage.Modality;

public class PosAppFilesInfoDialog
extends Dialog<ButtonType> {
    private ButtonType copyPathButtonType = new ButtonType(POSResourcesUtil.id("copyPath", new Object[0]), ButtonBar.ButtonData.OTHER);
    private ButtonType cancelButtonType = new ButtonType(POSResourcesUtil.id("cancel", new Object[0]), ButtonBar.ButtonData.CANCEL_CLOSE);

    public PosAppFilesInfoDialog() {
        this.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{this.copyPathButtonType, this.cancelButtonType});
        this.initModality(Modality.APPLICATION_MODAL);
    }

    public void showDialogAndWait(String msgPrefix, String path) {
        this.setResizable(true);
        NamaLabel content = new NamaLabel(msgPrefix + path);
        this.getDialogPane().setContent((Node)content);
        this.getDialogPane().setPrefWidth(500.0);
        Optional result = this.showAndWait();
        if (result.isPresent() && result.get() == this.copyPathButtonType) {
            Clipboard clipboard = Clipboard.getSystemClipboard();
            ClipboardContent clipboardContent = new ClipboardContent();
            clipboardContent.putString(path);
            clipboard.setContent((Map)clipboardContent);
            Alert alert = new Alert(Alert.AlertType.INFORMATION);
            alert.setTitle("Copying path");
            alert.setHeaderText(null);
            alert.setContentText("Done");
            alert.showAndWait();
        } else {
            this.hide();
        }
    }
}

