/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.namacontrols;

import com.namasoft.common.layout.edit.NaMaText;
import com.namasoft.common.layout.metadata.FieldTooltipInfo;
import com.namasoft.common.layout.metadata.PMap;
import com.namasoft.common.utilities.CollectionsUtility;
import com.namasoft.common.utilities.MultiKeyHash;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.contracts.common.dtos.requests.RunTooltipReq;
import com.namasoft.contracts.common.dtos.requests.SendRequest;
import com.namasoft.contracts.common.dtos.results.GetResult;
import com.namasoft.contracts.common.services.ModuleWS;
import com.namasoft.erp.guiserver.ServiceUtility;
import com.namasoft.pos.application.IHasToolBar;
import com.namasoft.pos.application.IPOSFieldInfo;
import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.application.POSResourcesUtil;
import com.namasoft.pos.application.POSTooltip;
import com.namasoft.pos.domain.entities.POSFieldTooltipInfo;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import javafx.application.Platform;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.control.ContentDisplay;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;
import javafx.stage.Screen;
import javafx.stage.Window;

public class PosCustomToolTipUtil {
    private static ExecutorService TOOLTIP_EXECUTOR = Executors.newSingleThreadExecutor();
    private static HashMap<MultiKeyHash, List<POSFieldTooltipInfo>> tooltipInfos = new HashMap();
    private static AtomicBoolean isTooltipTaskRunning = new AtomicBoolean(false);
    private static POSTooltip tooltip = null;

    public static void clearTooltipInfosMap() {
        tooltipInfos.clear();
    }

    public static List<POSFieldTooltipInfo> fetchTooltipInfoForField(String entityType, String fieldId, boolean autoTooltip) {
        if (tooltipInfos.get(MultiKeyHash.of((Object[])new Object[]{entityType, fieldId, autoTooltip})) != null) {
            return tooltipInfos.get(MultiKeyHash.of((Object[])new Object[]{entityType, fieldId, autoTooltip}));
        }
        List<?> tooltips = POSPersister.searchFor("from " + POSFieldTooltipInfo.class.getSimpleName() + " where entityType = :type and fieldId = :field and automaticTooltip = :automaticTooltip", POSPersister.params("type", entityType, "field", fieldId, "automaticTooltip", autoTooltip));
        tooltipInfos.put(MultiKeyHash.of((Object[])new Object[]{entityType, fieldId, autoTooltip}), tooltips);
        return tooltipInfos.get(MultiKeyHash.of((Object[])new Object[]{entityType, fieldId, autoTooltip}));
    }

    public static void showCustomTooltipIfNeeded(boolean automaticTooltip, IHasToolBar screen, String id) {
        String fieldId;
        if (screen == null) {
            return;
        }
        String entityType = screen.fetchScreenEntityType();
        List<POSFieldTooltipInfo> tooltips = PosCustomToolTipUtil.fetchTooltipInfoForField(entityType, fieldId = ObjectChecker.isNotEmptyOrNull((Object)screen.fetchFieldsMap().get(id)) ? screen.fetchFieldsMap().get(id).namaField() : id, automaticTooltip);
        if (ObjectChecker.isEmptyOrNull(tooltips)) {
            return;
        }
        TOOLTIP_EXECUTOR.submit(() -> {
            try {
                if (!isTooltipTaskRunning.compareAndSet(false, true)) {
                    return;
                }
                POSTooltip tooltip = PosCustomToolTipUtil.fetchToolTip(screen);
                if (ObjectChecker.isNotEmptyOrNull(tooltips.get(0))) {
                    POSFieldTooltipInfo tooltipInfo = (POSFieldTooltipInfo)tooltips.get(0);
                    FieldTooltipInfo info = new FieldTooltipInfo();
                    info.setTooltipId(tooltipInfo.getTooltipId());
                    info.setP1(tooltipInfo.getP1());
                    info.setP2(tooltipInfo.getP2());
                    info.setP3(tooltipInfo.getP3());
                    info.setP4(tooltipInfo.getP4());
                    info.setP5(tooltipInfo.getP5());
                    info.setP6(tooltipInfo.getP6());
                    info.setP7(tooltipInfo.getP7());
                    info.setP8(tooltipInfo.getP8());
                    info.setP9(tooltipInfo.getP9());
                    HashMap<String, String> parameters = new HashMap<String, String>();
                    PosCustomToolTipUtil.add(tooltipInfo.getP1(), parameters, screen);
                    PosCustomToolTipUtil.add(tooltipInfo.getP2(), parameters, screen);
                    PosCustomToolTipUtil.add(tooltipInfo.getP3(), parameters, screen);
                    PosCustomToolTipUtil.add(tooltipInfo.getP4(), parameters, screen);
                    PosCustomToolTipUtil.add(tooltipInfo.getP5(), parameters, screen);
                    PosCustomToolTipUtil.add(tooltipInfo.getP6(), parameters, screen);
                    PosCustomToolTipUtil.add(tooltipInfo.getP7(), parameters, screen);
                    PosCustomToolTipUtil.add(tooltipInfo.getP8(), parameters, screen);
                    PosCustomToolTipUtil.add(tooltipInfo.getP9(), parameters, screen);
                    RunTooltipReq req = new RunTooltipReq(entityType, CollectionsUtility.asList((Object[])new FieldTooltipInfo[]{info}), parameters);
                    ModuleWS moduleWS = ServiceUtility.getModuleServiceClient((String)"namapos");
                    GetResult runTooltip = moduleWS.runTooltip(new SendRequest((Object)req));
                    if (ObjectChecker.isNotEmptyOrNull((Object)runTooltip.getData())) {
                        Platform.runLater(() -> {
                            String content = "";
                            content = POSResourcesUtil.isArabic() ? (String)ObjectChecker.getFirstNotEmptyObj((Object[])new String[]{((NaMaText)runTooltip.getData()).getArabicText(), ((NaMaText)runTooltip.getData()).getEnglishText()}) : (String)ObjectChecker.getFirstNotEmptyObj((Object[])new String[]{((NaMaText)runTooltip.getData()).getEnglishText(), ((NaMaText)runTooltip.getData()).getArabicText()});
                            if (content.contains("/>") || content.contains("</")) {
                                tooltip.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
                                WebView web = new WebView();
                                WebEngine webEngine = web.getEngine();
                                webEngine.loadContent(content);
                                web.setPrefHeight(screen.fetchStage().getHeight() / 7.0);
                                web.setPrefWidth(screen.fetchStage().getWidth());
                                tooltip.setGraphic((Node)web);
                            } else {
                                tooltip.setText(content);
                            }
                            tooltip.show((Window)screen.fetchStage());
                        });
                    }
                }
            }
            finally {
                isTooltipTaskRunning.set(false);
            }
        });
    }

    private static POSTooltip fetchToolTip(IHasToolBar screen) {
        if (tooltip != null) {
            return tooltip;
        }
        tooltip = new POSTooltip("");
        Rectangle2D boundsInScreen = Screen.getPrimary().getVisualBounds();
        tooltip.setAutoFix(true);
        tooltip.setAutoHide(true);
        tooltip.setHideOnEscape(true);
        tooltip.setWrapText(true);
        if (POSResourcesUtil.isArabic()) {
            tooltip.setX(0.0);
        } else {
            tooltip.setX(screen.fetchScene().getWidth());
        }
        tooltip.setY(25.0);
        tooltip.setMaxWidth(screen.fetchScene().getWidth() - boundsInScreen.getMinX());
        return tooltip;
    }

    private static void add(PMap p, HashMap<String, String> map, IHasToolBar screen) {
        if (ObjectChecker.isEmptyOrNull((Object)p.getField())) {
            return;
        }
        IPOSFieldInfo fieldInfo = screen.fetchFieldsMap().get(p.getField());
        if (ObjectChecker.isEmptyOrNull((Object)fieldInfo)) {
            return;
        }
        if (ObjectChecker.isEmptyOrNull((Object)fieldInfo.posFieldValue())) {
            return;
        }
        map.put(p.getField(), fieldInfo.posFieldValue());
    }
}

