/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.namacontrols;

import com.namasoft.common.utilities.NaMaLogger;
import com.namasoft.namacontrols.IHasFont;
import com.namasoft.namacontrols.NamaButton;
import com.namasoft.namacontrols.NamaTextField;
import com.namasoft.pos.application.POSTooltip;
import com.namasoft.pos.application.POSUUIDUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.function.Consumer;
import javafx.application.Platform;
import javafx.scene.Node;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;

public class PosFileChooser
extends NamaTextField
implements IHasFont {
    private FileChooser fileChooser;
    private NamaButton chooseFileBtn;
    private NamaButton removeFileBtn;
    private String fileName;
    private String fileAbsolutePath;
    private POSTooltip chooseFileTooltip = new POSTooltip("chooseFile");
    private POSTooltip removeFileTooltip = new POSTooltip("removeFile");

    public PosFileChooser(Stage primaryStage, Consumer<String> chooseFileCallBack) {
        this.getStyleClass().add((Object)"file-chooser");
        this.fileChooser = new FileChooser();
        this.setEditable(false);
        this.chooseFileBtn = new NamaButton("");
        this.chooseFileBtn.setSVGIcon("upload.svg");
        this.removeFileBtn = new NamaButton("");
        this.removeFileBtn.setSVGIcon("cancel.svg");
        this.chooseFileBtn.setTooltip(this.chooseFileTooltip);
        this.removeFileBtn.setTooltip(this.removeFileTooltip);
        this.setPromptText(this.chooseFileTooltip.getText());
        this.chooseFileBtn.setOnAction(e -> {
            File selectedFile = this.fileChooser.showOpenDialog((Window)primaryStage);
            if (selectedFile == null) {
                return;
            }
            Platform.runLater(() -> {
                this.setText(selectedFile.getName());
                this.setRight((Node)this.removeFileBtn);
            });
            this.saveFileToUploadsDir(selectedFile);
            chooseFileCallBack.accept(this.fileAbsolutePath);
        });
        this.removeFileBtn.setOnAction(e -> {
            this.setRight((Node)this.chooseFileBtn);
            this.setText("");
            chooseFileCallBack.accept(null);
        });
        this.chooseFileBtn.setFocusTraversable(true);
        this.setRight((Node)this.chooseFileBtn);
    }

    public NamaTextField getFileNameField() {
        return this;
    }

    public void reset() {
        this.fileChooser = new FileChooser();
        this.setText("");
        this.setTooltip(this.chooseFileTooltip);
        if (!this.getChildren().contains((Object)this.chooseFileBtn)) {
            this.getChildren().add((Object)this.chooseFileBtn);
        }
        if (this.getChildren().contains((Object)this.removeFileBtn)) {
            this.getChildren().remove((Object)this.removeFileBtn);
        }
    }

    private void saveFileToUploadsDir(File selectedFile) {
        try {
            File toDayFolder;
            Date toDayDate = new Date();
            SimpleDateFormat smp = new SimpleDateFormat("dd-MM-yyyy");
            String toDayFormatted = smp.format(toDayDate);
            File uploadsFolder = new File("./uploads");
            if (!uploadsFolder.exists()) {
                uploadsFolder.mkdir();
            }
            if (!(toDayFolder = new File("uploads/" + toDayFormatted)).exists()) {
                toDayFolder.mkdir();
            }
            this.fileName = String.valueOf(POSUUIDUtil.genUUID()) + "_#_" + selectedFile.getName();
            File destFile = new File(toDayFolder.getAbsolutePath() + "/" + this.fileName);
            this.fileAbsolutePath = destFile.getAbsoluteFile().getAbsolutePath();
            Files.copy(selectedFile.toPath(), destFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            NaMaLogger.error((Throwable)e);
        }
    }
}

