/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.namacontrols;

import com.namasoft.pos.application.POSResourcesUtil;

public class PosSettingValidation {
    private boolean errorInDBConfig;
    private boolean errorInServerConfig;
    private boolean invalidRegister;
    private boolean invalidSqlServerVersion;
    private boolean hasEmptyProperties;
    private String registerCode;
    private static PosSettingValidation instance;

    public void setInitValues() {
        this.errorInDBConfig = false;
        this.errorInServerConfig = false;
        this.invalidRegister = false;
        this.invalidSqlServerVersion = false;
        this.hasEmptyProperties = false;
    }

    public static PosSettingValidation instance() {
        if (instance == null) {
            instance = new PosSettingValidation();
        }
        return instance;
    }

    public boolean isHasEmptyProperties() {
        return this.hasEmptyProperties;
    }

    public void setHasEmptyProperties(boolean hasEmptyProperties) {
        this.hasEmptyProperties = hasEmptyProperties;
    }

    public void setRegisterCode(String registerCode) {
        this.registerCode = registerCode;
    }

    public boolean isInvalidSqlServerVersion() {
        return this.invalidSqlServerVersion;
    }

    public void setInvalidSqlServerVersion(boolean invalidSqlServerVersion) {
        this.invalidSqlServerVersion = invalidSqlServerVersion;
    }

    public boolean isErrorInDBConfig() {
        return this.errorInDBConfig;
    }

    public void setErrorInDBConfig(boolean errorInDBConfig) {
        this.errorInDBConfig = errorInDBConfig;
    }

    public boolean isErrorInServerConfig() {
        return this.errorInServerConfig;
    }

    public void setErrorInServerConfig(boolean errorInServerConfig) {
        this.errorInServerConfig = errorInServerConfig;
    }

    public boolean isInvalidRegister() {
        return this.invalidRegister;
    }

    public void setInvalidRegister(boolean invalidRegister) {
        this.invalidRegister = invalidRegister;
    }

    public boolean invalidSettings() {
        return this.invalidRegister || this.errorInDBConfig || this.errorInServerConfig || this.invalidSqlServerVersion || this.hasEmptyProperties;
    }

    public String constructErrorMsg() {
        Object msg = "";
        if (this.invalidSqlServerVersion) {
            msg = (String)msg + "Error in SQL Server version is , it should be at least 13 (SQL Server 2016)  \n";
        }
        if (this.errorInServerConfig) {
            msg = (String)msg + POSResourcesUtil.id("There is no connection with server", new Object[0]) + "\n";
        }
        if (this.invalidRegister) {
            msg = (String)msg + POSResourcesUtil.id("There is no register with code", new Object[0]) + " " + this.registerCode + "\n";
        }
        if (this.errorInDBConfig) {
            msg = (String)msg + POSResourcesUtil.id("Error in database configuration", new Object[0]) + "\n";
        }
        if (this.hasEmptyProperties) {
            msg = (String)msg + POSResourcesUtil.id("Please fill required fields", new Object[0]) + "\n";
        }
        return msg;
    }
}

