/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.namacontrols;

import com.namasoft.common.constants.Language;
import com.namasoft.common.utilities.NaMaLogger;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.contracts.common.dtos.requests.SendRequest;
import com.namasoft.contracts.common.dtos.results.GetResult;
import com.namasoft.erp.guiserver.ServiceLoginProvider;
import com.namasoft.namacontrols.IPosCustomField;
import com.namasoft.namacontrols.NamaButton;
import com.namasoft.namacontrols.NamaComboBox;
import com.namasoft.namacontrols.NamaDialog;
import com.namasoft.namacontrols.NamaLabel;
import com.namasoft.namacontrols.NamaPasswordField;
import com.namasoft.namacontrols.NamaTextField;
import com.namasoft.namacontrols.PosSettingValidation;
import com.namasoft.pos.application.IHasToolBar;
import com.namasoft.pos.application.POSFieldType;
import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.application.POSResourcesUtil;
import com.namasoft.pos.application.PosEntryPoint;
import com.namasoft.pos.util.POSGeneralSettings;
import com.namasoft.pos.util.POSWSClient;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.StackPane;

public class PosSettingsDialog<T extends TextField> {
    private IHasToolBar view;
    private T posDbName;
    private T dbUrl;
    private T dbServerPortNum;
    private T dbUser;
    private T dbPassword;
    private T guiServerUrl;
    private T serverUrl;
    private T serverPort;
    private T serverLoginId;
    private T serverLoginPass;
    private T serverApiKey;
    private T registerCode;
    private NamaComboBox<Language> lang;
    private NamaComboBox<String> dbType;
    private NamaTextField writeData;
    private NamaTextField readData;
    private NamaTextField readDataCount;
    private NamaTextField readTime;
    private ProgressIndicator progressIndicator = new ProgressIndicator();

    public PosSettingsDialog(IHasToolBar view) {
        this.view = view;
    }

    public void showSettingsDialog() {
        this.progressIndicator.setVisible(false);
        NamaDialog dialog = new NamaDialog("settings");
        dialog.getDialogPane().setId("settings-dialog");
        dialog.addOkButton("");
        dialog.addCancelButton("");
        NamaButton checkDataBtn = new NamaButton("checkData");
        checkDataBtn.setId("check-data");
        checkDataBtn.setOnAction(e -> {
            this.checkData();
            if (ObjectChecker.isTrue((Boolean)PosSettingValidation.instance().invalidSettings())) {
                dialog.error(PosSettingValidation.instance().constructErrorMsg());
            } else {
                dialog.removeErrors();
            }
        });
        dialog.addButtonToFooter(checkDataBtn);
        dialog.setResizable(true);
        GridPane content = new GridPane();
        content.setId("settings-dialog-content");
        this.posDbName = new NamaTextField(POSFieldType.Text);
        this.posDbName.setPromptText(POSResourcesUtil.id("bdName", new Object[0]));
        NamaLabel dbLabel = new NamaLabel("bdName");
        this.posDbName.setOnKeyPressed(this.moveNext((Node)this.posDbName));
        NamaLabel dbUrlLabel = new NamaLabel("dbUrl");
        content.add((Node)dbUrlLabel, 0, 0);
        this.dbUrl = new NamaTextField(POSFieldType.Text);
        this.dbUrl.setPromptText(POSResourcesUtil.id("dbUrl", new Object[0]));
        this.dbUrl.setOnKeyPressed(this.moveNext((Node)this.dbUrl));
        content.add(this.dbUrl, 1, 0);
        Platform.runLater(() -> this.dbUrl.requestFocus());
        this.dbServerPortNum = new NamaTextField(POSFieldType.Text);
        this.dbServerPortNum.setPromptText(POSResourcesUtil.id("dbServerPortNum", new Object[0]));
        NamaLabel dbServerPortNumLabel = new NamaLabel("dbServerPortNum");
        content.add((Node)dbServerPortNumLabel, 0, 1);
        content.add(this.dbServerPortNum, 1, 1);
        this.dbServerPortNum.setOnKeyPressed(this.moveNext((Node)this.dbServerPortNum));
        this.dbUser = new NamaTextField(POSFieldType.Text);
        this.dbUser.setPromptText(POSResourcesUtil.id("dbUser", new Object[0]));
        NamaLabel dbUserLabel = new NamaLabel("dbUser");
        content.add((Node)dbUserLabel, 0, 2);
        content.add(this.dbUser, 1, 2);
        this.dbUser.setOnKeyPressed(this.moveNext((Node)this.dbUser));
        this.dbPassword = new NamaPasswordField();
        this.dbPassword.setPromptText(POSResourcesUtil.id("dbPassword", new Object[0]));
        this.dbPassword.setOnKeyPressed(this.moveNext((Node)this.dbPassword));
        NamaLabel dbPasswordLabel = new NamaLabel("dbPassword");
        content.add((Node)dbPasswordLabel, 0, 3);
        content.add(this.dbPassword, 1, 3);
        content.add((Node)dbLabel, 0, 4);
        content.add(this.posDbName, 1, 4);
        this.dbType = new NamaComboBox(FXCollections.observableArrayList((Object[])new String[]{"sqlserver", "mysql", "oracle"}), null, "dbType");
        this.dbType.setPrefWidth(300.0);
        this.dbType.setPromptText(POSResourcesUtil.id("dbType", new Object[0]));
        this.dbType.setOnKeyPressed(this.moveNext((Node)this.dbType));
        NamaLabel dbTypeLabel = new NamaLabel("dbType");
        content.add((Node)dbTypeLabel, 0, 5);
        content.add(this.dbType, 1, 5);
        this.guiServerUrl = new NamaTextField(POSFieldType.Text);
        this.guiServerUrl.setPromptText(POSResourcesUtil.id("guiServer", new Object[0]));
        NamaLabel guiServerLabel = new NamaLabel("guiServer");
        content.add((Node)guiServerLabel, 0, 6);
        content.add(this.guiServerUrl, 1, 6);
        this.guiServerUrl.setOnKeyPressed(this.moveNext((Node)this.guiServerUrl));
        NamaLabel writeDataLabel = new NamaLabel("writeData");
        this.writeData = new NamaTextField(POSFieldType.Text);
        this.writeData.setPromptText(POSResourcesUtil.id("writeData", new Object[0]));
        content.add((Node)writeDataLabel, 0, 8);
        content.add((Node)this.writeData, 1, 8);
        this.writeData.setOnKeyPressed(this.moveNext((Node)this.writeData));
        NamaLabel readDataLabel = new NamaLabel("readData");
        this.readData = new NamaTextField(POSFieldType.Text);
        this.readData.setPromptText(POSResourcesUtil.id("readData", new Object[0]));
        content.add((Node)readDataLabel, 0, 7);
        content.add((Node)this.readData, 1, 7);
        this.readData.setOnKeyPressed(this.moveNext((Node)this.readData));
        this.serverUrl = new NamaTextField(POSFieldType.Text);
        this.serverUrl.setPromptText(POSResourcesUtil.id("serverUrl", new Object[0]));
        content.add((Node)new NamaLabel("serverUrl"), 2, 0);
        content.add(this.serverUrl, 3, 0);
        this.serverUrl.setOnKeyPressed(this.moveNext((Node)this.serverUrl));
        this.serverPort = new NamaTextField(POSFieldType.Text);
        this.serverPort.setPromptText(POSResourcesUtil.id("serverPort", new Object[0]));
        content.add((Node)new NamaLabel("serverPort"), 2, 1);
        content.add(this.serverPort, 3, 1);
        this.serverPort.setOnKeyPressed(this.moveNext((Node)this.serverPort));
        this.serverLoginId = new NamaTextField(POSFieldType.Text);
        this.serverLoginId.setPromptText(POSResourcesUtil.id("serverLoginId", new Object[0]));
        content.add((Node)new NamaLabel("serverLoginId"), 2, 2);
        content.add(this.serverLoginId, 3, 2);
        this.serverLoginId.setOnKeyPressed(this.moveNext((Node)this.serverLoginId));
        this.serverLoginPass = new NamaPasswordField();
        this.serverLoginPass.setPromptText(POSResourcesUtil.id("serverLoginPass", new Object[0]));
        this.serverLoginPass.setOnKeyPressed(this.moveNext((Node)this.serverLoginPass));
        content.add((Node)new NamaLabel("serverLoginPass"), 2, 3);
        content.add(this.serverLoginPass, 3, 3);
        this.serverApiKey = new NamaPasswordField();
        this.serverApiKey.setPromptText(POSResourcesUtil.id("apiKey", new Object[0]));
        this.serverApiKey.setOnKeyPressed(this.moveNext((Node)this.serverApiKey));
        content.add((Node)new NamaLabel("apiKey"), 2, 4);
        content.add(this.serverApiKey, 3, 4);
        NamaLabel langLabel = new NamaLabel("language");
        this.lang = new NamaComboBox(FXCollections.observableArrayList((Object[])new Language[]{Language.Arabic, Language.English}), null, "lang");
        this.lang.setPrefWidth(300.0);
        this.lang.setPromptText(POSResourcesUtil.id("language", new Object[0]));
        this.lang.setValue((Language)this.lang.getItems().get(1));
        this.lang.setOnKeyPressed(this.moveNext((Node)this.lang));
        content.add((Node)langLabel, 2, 5);
        content.add(this.lang, 3, 5);
        this.registerCode = new NamaTextField(POSFieldType.Text);
        content.add((Node)new NamaLabel("registeryCode"), 2, 6);
        content.add(this.registerCode, 3, 6);
        this.registerCode.setOnKeyPressed(this.moveNext((Node)this.registerCode));
        this.readDataCount = new NamaTextField(POSFieldType.Text);
        this.readDataCount.setPromptText(POSResourcesUtil.id("readDataCount", new Object[0]));
        this.readDataCount.setOnKeyPressed(this.moveNext((Node)this.readDataCount));
        content.add((Node)new NamaLabel("readDataCount"), 2, 7);
        content.add((Node)this.readDataCount, 3, 7);
        this.readTime = new NamaTextField(POSFieldType.Text);
        this.readTime.setPromptText(POSResourcesUtil.id("readDataTime", new Object[0]));
        this.readTime.setOnKeyPressed(this.moveNext((Node)this.readTime));
        content.add((Node)new NamaLabel("readDataTime"), 2, 8);
        content.add((Node)this.readTime, 3, 8);
        StackPane contentPane = new StackPane(new Node[]{content, this.progressIndicator});
        contentPane.setId("settings-dialog-content-pane");
        dialog.content((Node)contentPane);
        dialog.addFooterPane();
        dialog.addScrollPane();
        this.initConfigDefault(POSGeneralSettings.getProperties());
        dialog.setOkAction(e -> {
            this.checkData();
            if (ObjectChecker.isTrue((Boolean)PosSettingValidation.instance().invalidSettings())) {
                dialog.error(PosSettingValidation.instance().constructErrorMsg());
                e.consume();
            } else {
                this.okAction();
            }
        });
        dialog.showAndWait();
    }

    private void checkData() {
        Platform.runLater(() -> this.progressIndicator.setVisible(true));
        PosSettingValidation.instance().setInitValues();
        POSPersister.checkDataBaseConfig(this.dbUrl.getText(), this.dbServerPortNum.getText(), this.posDbName.getText(), this.dbUser.getText(), this.dbPassword.getText());
        this.checkServerConnection(this.serverUrl.getText(), this.serverPort.getText(), this.serverLoginId.getText(), this.serverLoginPass.getText(), this.serverApiKey.getText());
        this.checkRegister(this.registerCode.getText());
        this.checkIfEmptyProperties();
        Platform.runLater(() -> this.progressIndicator.setVisible(false));
    }

    private void checkIfEmptyProperties() {
        ArrayList<TextField> fieldsToCheck = new ArrayList<TextField>(Arrays.asList(this.dbUrl, this.dbServerPortNum, this.posDbName, this.dbUser, this.dbPassword, this.serverUrl, this.serverLoginId, this.serverLoginPass, this.registerCode));
        if (!this.serverUrl.getText().toLowerCase().startsWith("http://") && !this.serverUrl.getText().toLowerCase().startsWith("https://")) {
            fieldsToCheck.add((TextField)this.serverPort);
        }
        for (TextField field : fieldsToCheck) {
            if (!ObjectChecker.isEmptyOrNull((Object)field.getText())) continue;
            ((IPosCustomField)field).addErrorMarkToField();
            PosSettingValidation.instance().setHasEmptyProperties(true);
        }
    }

    private void checkRegister(String registerCode) {
        try {
            PosSettingValidation.instance().setRegisterCode(registerCode);
            GetResult<Boolean> existRegister = POSWSClient.instance.checkExistRegister((SendRequest<String>)new SendRequest((Object)registerCode));
            if (!((Boolean)existRegister.getData()).booleanValue()) {
                PosSettingValidation.instance().setInvalidRegister(true);
            }
        }
        catch (Exception ex) {
            PosSettingValidation.instance().setInvalidRegister(true);
            NaMaLogger.error((Throwable)ex);
        }
    }

    private void checkServerConnection(String serverUrl, String serverPort, String serverLoginId, String serverLoginPass, String serverApiKey) {
        try {
            String url = PosEntryPoint.buildServerUrl(null, serverPort, serverUrl);
            ServiceLoginProvider.loginIfNotLoggedIn((String)url, (String)serverLoginPass, (String)serverLoginId, (String)serverApiKey);
        }
        catch (Exception exception) {
            PosSettingValidation.instance().setErrorInServerConfig(true);
            NaMaLogger.error((Throwable)exception);
        }
    }

    private void okAction() {
        this.saveSetting(POSGeneralSettings.getProperties());
        if (ObjectChecker.isNotEmptyOrNull((Object)this.view) && ObjectChecker.isNotEmptyOrNull((Object)this.view.fetchPaneCreator())) {
            this.view.fetchPaneCreator().refreshPaneCenter(this.view);
        }
    }

    private EventHandler<KeyEvent> moveNext(Node control) {
        return e -> {
            boolean focusChanged;
            if (!e.getCode().equals((Object)KeyCode.ENTER)) {
                return;
            }
            boolean bl = focusChanged = !control.isFocused();
            if (!focusChanged) {
                for (Node child : control.getParent().getChildrenUnmodifiable()) {
                    if (child.isDisable() || !child.isFocusTraversable()) continue;
                    child.requestFocus();
                    break;
                }
            }
        };
    }

    private void saveSetting(Properties properties) {
        this.saveSetting(properties, POSGeneralSettings.settingsFilePath);
    }

    private void saveSetting(Properties properties, String settingsFilePath) {
        properties.setProperty("invalidSettings", ObjectChecker.toStringOrEmpty((Object)PosSettingValidation.instance().invalidSettings()));
        properties.setProperty("posDbName", ObjectChecker.toStringOrEmpty((Object)this.posDbName.getText()));
        properties.setProperty("dbtype", ObjectChecker.toStringOrEmpty((Object)this.dbType.getValue()));
        properties.setProperty("sever.url", ObjectChecker.toStringOrEmpty((Object)this.serverUrl.getText()));
        properties.setProperty("server.port", ObjectChecker.toStringOrEmpty((Object)this.serverPort.getText()));
        properties.setProperty("db.sever.url", ObjectChecker.toStringOrEmpty((Object)this.dbUrl.getText()));
        properties.setProperty("dbserver.port", ObjectChecker.toStringOrEmpty((Object)this.dbServerPortNum.getText()));
        properties.setProperty("loginid", ObjectChecker.toStringOrEmpty((Object)this.serverLoginId.getText()));
        properties.setProperty("loginpassword", ObjectChecker.toStringOrEmpty((Object)this.serverLoginPass.getText()));
        properties.setProperty("apiKey", ObjectChecker.toStringOrEmpty((Object)this.serverApiKey.getText()));
        properties.setProperty("dbuser", ObjectChecker.toStringOrEmpty((Object)this.dbUser.getText()));
        properties.setProperty("registerycode", ObjectChecker.toStringOrEmpty((Object)this.registerCode.getText()));
        properties.setProperty("dbpassword", ObjectChecker.toStringOrEmpty((Object)this.dbPassword.getText()));
        properties.setProperty("defaultlang", ObjectChecker.toStringOrEmpty((Object)((Language)this.lang.getValue()).toString()));
        properties.setProperty("guiserver", ObjectChecker.toStringOrEmpty((Object)this.guiServerUrl.getText()));
        properties.setProperty("writeData", ObjectChecker.toStringOrEmpty((Object)this.writeData.getText()));
        properties.setProperty("readData", ObjectChecker.toStringOrEmpty((Object)this.readData.getText()));
        properties.setProperty("readDataTime", ObjectChecker.toStringOrEmpty((Object)this.readTime.getText()));
        properties.setProperty("readDataRecordsCount", ObjectChecker.toStringOrEmpty((Object)this.readDataCount.getText()));
        POSGeneralSettings.savePropertiesAsSections((String)settingsFilePath);
    }

    private void initConfigDefault(Properties prop) {
        this.dbType.setValue(prop.getProperty("dbtype"));
        this.posDbName.setText(prop.getProperty("posDbName"));
        this.dbUser.setText(prop.getProperty("dbuser"));
        this.dbPassword.setText(prop.getProperty("dbpassword"));
        this.dbUrl.setText(prop.getProperty("db.sever.url"));
        this.dbServerPortNum.setText(prop.getProperty("dbserver.port"));
        this.serverUrl.setText(prop.getProperty("sever.url"));
        this.serverPort.setText(prop.getProperty("server.port"));
        this.serverLoginId.setText(prop.getProperty("loginid"));
        this.serverLoginPass.setText(prop.getProperty("loginpassword"));
        this.serverApiKey.setText(prop.getProperty("apiKey"));
        this.lang.setValue(Language.valueOf((String)prop.getProperty("defaultlang")));
        this.registerCode.setText(prop.getProperty("registerycode"));
        this.guiServerUrl.setText(prop.getProperty("guiserver"));
        this.writeData.setText(prop.getProperty("writeData"));
        this.readData.setText(prop.getProperty("readData"));
        this.readDataCount.setText(prop.getProperty("readDataRecordsCount"));
        this.readTime.setText(prop.getProperty("readDataTime"));
    }

    public static void threadDumberAction() {
        POSGeneralSettings.reset();
        try {
            POSResourcesUtil.genMemoryAndThreadDump();
        }
        catch (IOException e) {
            Alert alert = new Alert(Alert.AlertType.ERROR);
            alert.setContentText("cannot open thread dump file");
            alert.showAndWait();
            NaMaLogger.error((Throwable)e);
        }
    }
}

