/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.namacontrols;

import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.VBox;
import javafx.util.Duration;

public class StopwatchController
extends VBox {
    private final Label timeLabel = new Label("00:00");
    private static int minutes = 0;
    private static int seconds = 0;
    private static long startTime;
    private static long elapsedTimeBeforeStart;
    private static boolean isRunning;
    private final Timeline timeline;

    public StopwatchController() {
        this.setupUI();
        this.timeline = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)1000.0), e -> this.updateTime(), new KeyValue[0])});
        this.timeline.setCycleCount(-1);
        this.timeline.play();
    }

    private void setupUI() {
        this.timeLabel.setStyle("-fx-font-size: 24px; -fx-font-weight: bold;-fx-text-fill: #dfdfdf;-fx-alignment: CENTER; -fx-font-family: Consolas");
        this.setSpacing(20.0);
        this.setAlignment(Pos.CENTER);
        this.getChildren().addAll((Object[])new Node[]{this.timeLabel});
    }

    public void start() {
        if (!isRunning) {
            startTime = System.nanoTime();
            isRunning = true;
            this.timeline.play();
        }
    }

    public void pause() {
        if (isRunning) {
            elapsedTimeBeforeStart += System.nanoTime() - startTime;
            isRunning = false;
            this.timeline.pause();
        }
    }

    public void reset() {
        seconds = 0;
        minutes = 0;
        elapsedTimeBeforeStart = 0L;
        isRunning = false;
        this.timeline.stop();
        this.updateDisplay();
        this.start();
    }

    private void updateTime() {
        long currentTime = System.nanoTime();
        long elapsedNanos = elapsedTimeBeforeStart + (currentTime - startTime);
        long elapsedMillis = elapsedNanos / 1000000L;
        long elapsedSeconds = elapsedMillis / 1000L;
        seconds = (int)(elapsedSeconds % 60L);
        long elapsedMinutes = elapsedSeconds / 60L;
        minutes = (int)(elapsedMinutes % 60L);
        this.updateDisplay();
    }

    private void updateDisplay() {
        Platform.runLater(() -> this.timeLabel.setText(String.format("%02d:%02d", minutes, seconds)));
    }

    public String getCurrentTime() {
        return this.timeLabel.getText();
    }

    public boolean isRunning() {
        return isRunning;
    }

    static {
        elapsedTimeBeforeStart = 0L;
        isRunning = false;
    }
}

