/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.namacontrols.tablecells;

import com.namasoft.common.utilities.NaMaLogger;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.pos.domain.POSMasterFile;
import java.awt.image.BufferedImage;
import java.io.File;
import javafx.embed.swing.SwingFXUtils;
import javafx.scene.Node;
import javafx.scene.control.TableCell;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javax.imageio.ImageIO;

public class ItemImageCell
extends TableCell<POSMasterFile, String> {
    protected void updateItem(String url, boolean empty) {
        if (ObjectChecker.isEmptyOrNull((Object)url) || url.startsWith("file.download")) {
            this.setGraphic(null);
            return;
        }
        try {
            File imgFile = new File(url);
            if (!imgFile.exists()) {
                return;
            }
            BufferedImage bImg = ImageIO.read(imgFile);
            ImageView imageView = null;
            if (bImg != null) {
                imageView = new ImageView();
                imageView.setImage((Image)SwingFXUtils.toFXImage((BufferedImage)bImg, null));
                imageView.setFitHeight(70.0);
                imageView.setFitWidth(100.0);
                imageView.setSmooth(true);
                imageView.setPreserveRatio(true);
            }
            this.setGraphic((Node)imageView);
        }
        catch (Exception e) {
            NaMaLogger.error((Throwable)e);
        }
    }
}

