/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.namacontrols.tablecells;

import com.namasoft.common.utilities.NaMaMath;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.namacontrols.NamaTextArea;
import com.namasoft.namacontrols.POSSettingsUtil;
import com.namasoft.namacontrols.tablecells.NamaTextFieldTableCell;
import com.namasoft.pos.util.POSMoneyUtils;
import com.namasoft.pos.util.POSScreenSettings;
import java.math.BigDecimal;
import javafx.scene.Node;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.cell.TextFieldTableCell;
import javafx.util.Callback;
import javafx.util.StringConverter;

public class POSTableCell
extends TextFieldTableCell {
    public POSTableCell() {
        POSSettingsUtil.setFonts(POSScreenSettings.getTableCellsFont(), ((Object)((Object)this)).getClass().getClassLoader(), new Node[]{this});
    }

    public POSTableCell(StringConverter converter) {
        super(converter);
        POSSettingsUtil.setFonts(POSScreenSettings.getTableCellsFont(), ((Object)((Object)this)).getClass().getClassLoader(), new Node[]{this});
    }

    public static <T, R> Callback<TableColumn<T, R>, TableCell<T, R>> defaultCellFactory() {
        return list -> new POSTableCell(new StringConverter<R>(){

            public String toString(R item) {
                return ObjectChecker.isEmptyOrNull(item) ? "" : item.toString();
            }

            public R fromString(String string) {
                return string;
            }
        });
    }

    public static <T> Callback<TableColumn<T, BigDecimal>, TableCell<T, BigDecimal>> stringBigDecimalConverter() {
        return POSTableCell.stringBigDecimalConverter(false);
    }

    public static <T> Callback<TableColumn<T, BigDecimal>, TableCell<T, BigDecimal>> stringBigDecimalConverter(final boolean isPercent) {
        StringConverter<BigDecimal> converter = new StringConverter<BigDecimal>(){

            public String toString(BigDecimal object) {
                return ObjectChecker.isNotEmptyOrNull((Object)object) ? NaMaMath.round((BigDecimal)object, (Integer)POSMoneyUtils.displayDecimalPlaces).toString() : "";
            }

            public BigDecimal fromString(String string) {
                if (ObjectChecker.isEmptyOrNull((Object)string)) {
                    return BigDecimal.ZERO;
                }
                BigDecimal decimal = new BigDecimal(string);
                if (isPercent) {
                    return NaMaMath.round((BigDecimal)decimal, (Integer)POSMoneyUtils.getPercentageScale());
                }
                return NaMaMath.round((BigDecimal)decimal, (Integer)POSMoneyUtils.fractionalDecimalPlaces);
            }
        };
        return NamaTextFieldTableCell.forTableColumn(converter);
    }

    public static <T> Callback<TableColumn<T, NamaTextArea>, TableCell<T, NamaTextArea>> stringTextAreaConverter() {
        StringConverter<NamaTextArea> converter = new StringConverter<NamaTextArea>(){

            public String toString(NamaTextArea object) {
                return object != null ? object.getText() : "";
            }

            public NamaTextArea fromString(String string) {
                NamaTextArea area = new NamaTextArea(string, null, null);
                area.setTitle("");
                return area;
            }
        };
        return NamaTextFieldTableCell.forTableColumn(converter);
    }
}

