/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.Migrator;

import com.namasoft.pos.Migrator.POSMigrator;
import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.domain.details.POSShiftCloseLine;
import com.namasoft.pos.domain.details.POSShiftLine;
import com.namasoft.pos.domain.details.POSShiftOpenLine;
import com.namasoft.pos.domain.entities.POSShift;
import com.namasoft.pos.domain.entities.POSShiftClose;
import com.namasoft.pos.domain.entities.POSShiftOpen;
import java.util.ArrayList;
import java.util.List;

public class POSShiftRefactorMigrator
extends POSMigrator {
    @Override
    protected void doMigrate() {
        List<POSShift> posShifts = POSPersister.listAll(POSShift.class);
        for (POSShift posShift : posShifts) {
            POSShiftOpen shiftOpen = new POSShiftOpen();
            shiftOpen.setPosUser(posShift.getPosUser());
            shiftOpen.setCode(posShift.getCode());
            shiftOpen.setRemarks(posShift.getRemarks());
            shiftOpen.setComitBefore(posShift.getComitBefore());
            shiftOpen.setGenericDims(posShift.getGenericDims());
            shiftOpen.setPreventUsage(posShift.getPreventUsage());
            shiftOpen.setName1(posShift.getName1());
            shiftOpen.setName2(posShift.getName2());
            shiftOpen.setWriteFailures(posShift.getWriteFailures());
            shiftOpen.setRegistery(posShift.getRegistery());
            shiftOpen.setSent(posShift.getOpeningSent());
            shiftOpen.setShiftDate(posShift.getShiftDate());
            shiftOpen.setShiftTime(posShift.getShiftTime());
            shiftOpen.setTime(posShift.getTime());
            shiftOpen.getId();
            shiftOpen.setDetails(new ArrayList<POSShiftOpenLine>());
            POSShiftClose shiftClose = null;
            if (posShift.isClosed()) {
                shiftClose = new POSShiftClose();
                shiftClose.setShiftTime(posShift.getShiftTime());
                shiftClose.setCode(posShift.getCode());
                shiftClose.setShiftDate(posShift.getShiftDate());
                shiftClose.setTime(posShift.getTime());
                shiftClose.setSent(posShift.getSent());
                shiftClose.setPosUser(posShift.getPosUser());
                shiftClose.setComitBefore(posShift.getComitBefore());
                shiftClose.setGenericDims(posShift.getGenericDims());
                shiftClose.setName1(posShift.getName1());
                shiftClose.setName2(posShift.getName2());
                shiftClose.setPreventUsage(posShift.getPreventUsage());
                shiftClose.setWriteFailures(posShift.getWriteFailures());
                shiftClose.setRegistery(posShift.getRegistery());
                shiftClose.setRemarks(posShift.getRemarks());
                shiftClose.getId();
                shiftClose.setDetails(new ArrayList<POSShiftCloseLine>());
            }
            for (POSShiftLine shiftLine : posShift.getDetails()) {
                POSShiftOpenLine openLine = new POSShiftOpenLine();
                shiftOpen.getDetails().add(openLine);
                openLine.setDifference(shiftLine.getOpenDifference());
                openLine.setPaymentWay(shiftLine.getPaymentWay());
                openLine.setCurrency(shiftLine.getCurrency());
                openLine.setCurrencyId(shiftLine.getCurrencyId());
                openLine.setPaymentMethodId(shiftLine.getPaymentMethodId());
                openLine.setShift(shiftOpen);
                openLine.setAccountantRemaining(shiftLine.getOpenAccountantRemaining());
                openLine.setActualRemaining(shiftLine.getOpenActualRemaining());
                openLine.assignIds();
                if (!posShift.isClosed()) continue;
                POSShiftCloseLine closeLine = new POSShiftCloseLine();
                shiftClose.getDetails().add(closeLine);
                closeLine.setActualRemaining(shiftLine.getActualRemaining());
                closeLine.setDifference(shiftLine.getDifference());
                closeLine.setAccountantRemaining(shiftLine.getAccountantRemaining());
                closeLine.setPaymentMethodId(shiftLine.getPaymentMethodId());
                closeLine.setShift(shiftClose);
                closeLine.setCurrency(shiftLine.getCurrency());
                closeLine.setCurrencyId(shiftLine.getCurrencyId());
                closeLine.setPaymentWay(shiftLine.getPaymentWay());
                closeLine.assignIds();
            }
            POSPersister.saveOrUpdate(shiftOpen);
            if (shiftClose == null) continue;
            POSPersister.saveOrUpdate(shiftClose);
        }
    }

    @Override
    public Integer getFromVersion() {
        return 6;
    }
}

