/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.Migrator;

import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.common.utils.ServerStringUtils;
import com.namasoft.pos.Migrator.POSMigrator;
import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.domain.POSMasterFile;
import com.namasoft.pos.domain.entities.POSOrderReservation;
import com.namasoft.pos.domain.entities.POSSalesInvoice;
import com.namasoft.pos.domain.entities.POSSalesReplacement;
import com.namasoft.pos.domain.entities.POSSalesReturn;
import com.namasoft.pos.domain.entities.POSScrapDoc;
import com.namasoft.pos.domain.entities.POSShortfallsDoc;
import com.namasoft.pos.domain.entities.POSStockReceipt;
import com.namasoft.pos.domain.entities.POSUser;
import com.namasoft.pos.domain.entities.PosCancelReservation;
import com.namasoft.pos.util.POSSecurityUtil;
import java.util.Date;
import java.util.List;
import java.util.UUID;

public class PosSecurityActionsMigrator
extends POSMigrator {
    @Override
    public Integer getFromVersion() {
        return 43;
    }

    @Override
    protected void doMigrate() {
        PosSecurityActionsMigrator.createActionsLines(POSPersister.executeSelectAndDoNotFail("select capability, actionDate, userCode, invoice_id from POSSalesInvActionLine", "", POSPersister.params(new Object[0])), POSSalesInvoice.class);
        PosSecurityActionsMigrator.createActionsLines(POSPersister.executeSelectAndDoNotFail("select capability, actionDate, userCode, invoice_id from POSSalesReturnActionLine", "", POSPersister.params(new Object[0])), POSSalesReturn.class);
        PosSecurityActionsMigrator.createActionsLines(POSPersister.executeSelectAndDoNotFail("select capability, actionDate, userCode, invoice_id from POSSalesReplacementActionLine", "", POSPersister.params(new Object[0])), POSSalesReplacement.class);
        PosSecurityActionsMigrator.createActionsLines(POSPersister.executeSelectAndDoNotFail("select capability, actionDate, userCode, reservation_id from POSReservationActionLine", "", POSPersister.params(new Object[0])), POSOrderReservation.class);
        PosSecurityActionsMigrator.createActionsLines(POSPersister.executeSelectAndDoNotFail("select capability, actionDate, userCode, cancelReservation_id from POSCancelReservationActionLine", "", POSPersister.params(new Object[0])), PosCancelReservation.class);
        PosSecurityActionsMigrator.createActionsLines(POSPersister.executeSelectAndDoNotFail("select capability, actionDate, userCode, invoice_id from POSReceiptActionLine", "", POSPersister.params(new Object[0])), POSStockReceipt.class);
        PosSecurityActionsMigrator.createActionsLines(POSPersister.executeSelectAndDoNotFail("select capability, actionDate, userCode, scrap_id from POSScrapDocActionLine", "", POSPersister.params(new Object[0])), POSScrapDoc.class);
        PosSecurityActionsMigrator.createActionsLines(POSPersister.executeSelectAndDoNotFail("select capability, actionDate, userCode, shortfalls_id from POSShortfallsDocActionLine", "", POSPersister.params(new Object[0])), POSShortfallsDoc.class);
    }

    private static void createActionsLines(List<Object[]> objects, Class docKlass) {
        for (Object[] object : objects) {
            String capability = ObjectChecker.toStringOrEmpty((Object)object[0]);
            Date actionDate = (Date)object[1];
            String userCode = ObjectChecker.toStringOrEmpty((Object)object[2]);
            UUID docId = ServerStringUtils.strToUUID((String)ServerStringUtils.toUUIDStr((Object)object[3]));
            POSMasterFile doc = (POSMasterFile)POSPersister.findByID(docKlass, docId);
            POSSecurityUtil.addActionLine(capability, doc, actionDate, (POSUser)POSPersister.findByCode(POSUser.class, userCode));
        }
    }
}

