/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.PGW;

import com.fasterxml.jackson.databind.JsonNode;
import com.namasoft.common.utilities.NaMaLogger;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.modules.basic.enums.PaymentGatewayProvider;
import com.namasoft.modules.commonbasic.contracts.valueobjects.DTOPGWProperties;
import com.namasoft.modules.supplychain.contracts.details.DTOSalesPaymentLine;
import com.namasoft.pos.PGW.PGWUtil;
import com.namasoft.pos.application.MultiplePaymentDialog;
import com.namasoft.pos.application.PaymentInfo;
import com.namasoft.pos.controllers.NamaJSON;
import com.namasoft.pos.domain.AbsPOSSales;
import com.namasoft.pos.domain.POSPaymentMethod;
import com.namasoft.pos.domain.entities.POSRegistery;
import com.namasoft.pos.util.POSResult;
import com.namasoft.pos.util.PayRequest;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class NearPay {
    public static POSResult pay(POSRegistery register, AbsPOSSales salesDoc, BigDecimal amount, String pgwResponse) {
        POSResult result = new POSResult();
        try {
            salesDoc.updateRegisterFields(register, null);
            PayRequest payRequest = new PayRequest();
            payRequest.setSalesDoc(salesDoc);
            payRequest.setDocType(salesDoc.docType());
            payRequest.setValue(amount);
            payRequest.setRegister(register);
            NearPay.addPaymentInfoToPayRequest(payRequest, amount, pgwResponse, result);
            if (result.isFailed().booleanValue()) {
                return result;
            }
            result.accumulate(MultiplePaymentDialog.process(payRequest, null));
        }
        catch (Exception e) {
            NaMaLogger.error((Throwable)e);
            result.failure("Please see log for more details.{0}", e.getMessage());
        }
        return result;
    }

    public static void addPaymentInfoToPayRequest(PayRequest payRequest, BigDecimal amount, String pgwResponse, POSResult result) {
        if (ObjectChecker.isEmptyOrNull((Object)pgwResponse) || ObjectChecker.isEmptyOrZero((BigDecimal)amount)) {
            return;
        }
        PGWUtil.TerminalPaymentResp terminalPaymentResp = PGWUtil.paymentLineFromPGWResponse(payRequest.getRegister(), pgwResponse, amount, PaymentGatewayProvider.NearPay);
        PGWUtil.validatePGWResponse(terminalPaymentResp, result);
        if (result.isFailed().booleanValue()) {
            return;
        }
        POSPaymentMethod paymentMethod = terminalPaymentResp.getMethod();
        DTOPGWProperties pgwProperties = terminalPaymentResp.getLine().getPgwProperties();
        PaymentInfo paymentInfo = new PaymentInfo(amount, pgwProperties.getAuthCode());
        paymentInfo.setPgwProperties(pgwProperties);
        paymentInfo.setPaidFromTerminal(true);
        if (payRequest.getPayments() == null) {
            payRequest.setPayments(new HashMap<POSPaymentMethod, List<PaymentInfo>>());
        }
        payRequest.getPayments().computeIfAbsent(paymentMethod, m -> new ArrayList()).add(paymentInfo);
    }

    public static DTOSalesPaymentLine fromJsonToPaymentLine(String json) {
        try {
            JsonNode receipts;
            JsonNode rootNode = NamaJSON.instance().readTree(json);
            JsonNode receipt = receipts = rootNode.path("receipts");
            if (receipts.isArray()) {
                receipt = receipts.get(0);
            }
            String transactionId = receipt.path("transaction_uuid").asText();
            String terminalId = receipt.path("tid").asText();
            String merchantId = receipt.path("merchant").path("id").asText();
            String stan = receipt.path("system_trace_audit_number").asText();
            String retrievalReferenceNumber = receipt.path("retrieval_reference_number").asText();
            String schemeId = receipt.path("card_scheme").path("id").asText();
            String cardType = receipt.path("card_scheme").path("name").path("english").asText();
            String approvalCode = receipt.path("approval_code").path("value").asText();
            String maskedCardNum = receipt.path("pan").asText();
            String responseCode = receipt.path("action_code").asText();
            DTOSalesPaymentLine line = new DTOSalesPaymentLine();
            line.setPgwProperties(new DTOPGWProperties());
            line.getPgwProperties().setAuthCode(approvalCode);
            line.getPgwProperties().setCardType(cardType);
            line.getPgwProperties().setDe55Response("");
            line.getPgwProperties().setEcrRefNum(transactionId);
            line.getPgwProperties().setMaskedCardNumber(maskedCardNum);
            line.getPgwProperties().setMerchantId(merchantId);
            line.getPgwProperties().setPanNum(retrievalReferenceNumber);
            line.getPgwProperties().setRespCode(responseCode);
            line.getPgwProperties().setSchemeId(schemeId);
            line.getPgwProperties().setStanNum(stan);
            line.getPgwProperties().setTerminalId(terminalId);
            line.getPgwProperties().setPaidFromTerminal(Boolean.valueOf(true));
            return line;
        }
        catch (IOException e) {
            NaMaLogger.error((Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

