/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.PGW;

import com.namasoft.common.constants.Operator;
import com.namasoft.common.utilities.NaMaLogger;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.modules.basic.enums.PaymentGatewayProvider;
import com.namasoft.modules.commonbasic.contracts.valueobjects.DTOPGWProperties;
import com.namasoft.modules.supplychain.contracts.details.DTOSalesPaymentLine;
import com.namasoft.pos.PGW.NearPay;
import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.application.POSResourcesUtil;
import com.namasoft.pos.controllers.NamaJSON;
import com.namasoft.pos.domain.POSPaymentMethod;
import com.namasoft.pos.domain.details.PosMethodGroupLine;
import com.namasoft.pos.domain.entities.POSRegistery;
import com.namasoft.pos.domain.entities.PosPGWMethodGroup;
import com.namasoft.pos.domain.entities.PosPaymentTerminal;
import com.namasoft.pos.util.POSResult;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.UUID;

public class PGWUtil {
    public static TerminalPaymentResp paymentLineFromPGWResponse(POSRegistery register, String jsonRespFromGateway, BigDecimal valueToPaid, PaymentGatewayProvider provider) throws RuntimeException {
        PosPaymentTerminal registerTerminal = register.getPaymentTerminal();
        if (registerTerminal == null && POSResourcesUtil.fetchPOSConfig().getPaymentTerminal() == null) {
            return null;
        }
        if (registerTerminal == null) {
            registerTerminal = POSPersister.findByID(PosPaymentTerminal.class, UUID.fromString(POSResourcesUtil.fetchPOSConfig().getPaymentTerminal().getId()));
        }
        NaMaLogger.info((String)"Here is the JSON for Payment Gateway Response {0}", (Object[])new Object[]{jsonRespFromGateway});
        DTOSalesPaymentLine line = PGWUtil.toPaymentLineFromJson(jsonRespFromGateway, provider);
        NaMaLogger.info((String)"Here is the JSON for the parsed  DTOSalesPaymentLine {0}", (Object[])new Object[]{NamaJSON.toString(line)});
        line.setPaymentValue(valueToPaid);
        if (ObjectChecker.isEmptyOrNull((Object)line.getPgwProperties())) {
            line.setPgwProperties(new DTOPGWProperties());
        }
        line.getPgwProperties().setPaidFromTerminal(Boolean.valueOf(true));
        line.setAuthorizationNumber(line.getPgwProperties().getAuthCode());
        PosPaymentTerminal terminal = POSPersister.findByID(PosPaymentTerminal.class, registerTerminal.getId());
        PosPGWMethodGroup methodGroup = terminal.getMethodGroup();
        POSPaymentMethod posPaymentMethod = methodGroup.getDetails().stream().filter(l -> PGWUtil.isMatchedProperty(line.getPgwProperties().getEcrRefNum(), l.getEcrRefNum(), l.getEcrRefNumOperator()) && PGWUtil.isMatchedProperty(line.getPgwProperties().getPanNum(), l.getPanNum(), l.getPanNumOperator()) && PGWUtil.isMatchedProperty(line.getPgwProperties().getSchemeId(), l.getSchemeId(), l.getSchemeIdOperator()) && PGWUtil.isMatchedProperty(line.getPgwProperties().getMerchantId(), l.getMerchantId(), l.getMerchantIdOperator()) && PGWUtil.isMatchedProperty(line.getPgwProperties().getTerminalId(), l.getTerminalId(), l.getTerminalIdOperator()) && PGWUtil.isMatchedProperty(line.getPgwProperties().getStanNum(), l.getStanNum(), l.getStanNumOperator()) && PGWUtil.isMatchedProperty(line.getPgwProperties().getCardType(), l.getCardType(), l.getCardTypeOperator()) && PGWUtil.isMatchedProperty(line.getPgwProperties().getMaskedCardNumber(), l.getMaskedCardNumber(), l.getMaskedCardNumberOperator()) && PGWUtil.isMatchedProperty(line.getPgwProperties().getDe55Response(), l.getDe55Response(), l.getDe55ResponseOperator())).findFirst().map(PosMethodGroupLine::getPaymentMethod).orElse(null);
        return new TerminalPaymentResp(posPaymentMethod, line);
    }

    private static DTOSalesPaymentLine toPaymentLineFromJson(String jsonRespFromGateway, PaymentGatewayProvider provider) throws RuntimeException {
        if (ObjectChecker.areEqual((Object)provider, (Object)PaymentGatewayProvider.NearPay)) {
            return NearPay.fromJsonToPaymentLine(jsonRespFromGateway);
        }
        return PGWUtil.paymentLineFromPGWResponse(jsonRespFromGateway);
    }

    private static DTOSalesPaymentLine paymentLineFromPGWResponse(String jsonRespFromGateway) {
        try {
            return NamaJSON.read(jsonRespFromGateway, DTOSalesPaymentLine.class);
        }
        catch (IOException e) {
            NaMaLogger.error((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private static boolean isMatchedProperty(String respProp, String lineProp, String operator) {
        if (ObjectChecker.isEmptyOrNull((Object)lineProp)) {
            return true;
        }
        lineProp = ObjectChecker.toStringOrEmpty((Object)lineProp).toLowerCase();
        respProp = ObjectChecker.toStringOrEmpty((Object)respProp).toLowerCase();
        if (ObjectChecker.isEmptyOrNull((Object)operator)) {
            operator = Operator.Contains.name();
        }
        if (ObjectChecker.areEqual((Object)operator, (Object)Operator.Contains.name())) {
            return respProp.contains(lineProp);
        }
        if (ObjectChecker.areEqual((Object)operator, (Object)Operator.StartsWith.name())) {
            return respProp.startsWith(lineProp);
        }
        if (ObjectChecker.areEqual((Object)operator, (Object)Operator.EndsWith.name())) {
            return respProp.endsWith(lineProp);
        }
        if (ObjectChecker.areEqual((Object)operator, (Object)Operator.Equal.name())) {
            return ObjectChecker.areEqual((Object)respProp, (Object)lineProp);
        }
        return respProp.contains(lineProp);
    }

    public static void validatePGWResponse(TerminalPaymentResp terminalPaymentResp, POSResult result) {
        POSPaymentMethod paymentMethod = terminalPaymentResp.getMethod();
        DTOPGWProperties pgwProperties = terminalPaymentResp.getLine().getPgwProperties();
        String cardType = pgwProperties.getCardType();
        String authCode = pgwProperties.getAuthCode();
        if (ObjectChecker.isEmptyOrNull((Object)cardType) && (ObjectChecker.isEmptyOrNull((Object)authCode) || authCode.matches("0+"))) {
            result.failure("Purchase Transaction refused", new Object[0]);
        }
        if (ObjectChecker.areAllEmptyOrNull((Object[])new Object[]{pgwProperties.getMerchantId(), pgwProperties.getEcrRefNum(), pgwProperties.getSchemeId(), pgwProperties.getTerminalId(), pgwProperties.getStanNum(), pgwProperties.getPanNum(), authCode, pgwProperties.getCardType(), pgwProperties.getMaskedCardNumber(), pgwProperties.getDe55Response()})) {
            result.failure("Purchase Transaction not completed successfully", new Object[0]);
        }
        if (paymentMethod == null) {
            result.failure("There is no payment method matched pgw properties", new Object[0]);
        }
    }

    public static class TerminalPaymentResp {
        private POSPaymentMethod method;
        private DTOSalesPaymentLine line;

        public TerminalPaymentResp(POSPaymentMethod method, DTOSalesPaymentLine line) {
            this.setMethod(method);
            this.setLine(line);
        }

        public POSPaymentMethod getMethod() {
            return this.method;
        }

        public void setMethod(POSPaymentMethod method) {
            this.method = method;
        }

        public DTOSalesPaymentLine getLine() {
            return this.line;
        }

        public void setLine(DTOSalesPaymentLine line) {
            this.line = line;
        }
    }
}

