/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.application;

import com.namasoft.common.ResultDTO;
import com.namasoft.common.constants.Language;
import com.namasoft.common.exceptions.NaMaServiceExcepption;
import com.namasoft.common.utilities.NaMaLogger;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.namacontrols.IHasFont;
import com.namasoft.namacontrols.NamaBorderPane;
import com.namasoft.namacontrols.NamaButton;
import com.namasoft.namacontrols.NamaDialog;
import com.namasoft.namacontrols.NamaLabel;
import com.namasoft.namacontrols.POSErrorAndInfoMessagesUtil;
import com.namasoft.namacontrols.POSSettingsUtil;
import com.namasoft.pos.application.AbsPosSalesScreen;
import com.namasoft.pos.application.IHasToolBar;
import com.namasoft.pos.application.LoginScreen;
import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.application.POSResourcesUtil;
import com.namasoft.pos.application.POSSlideMenu;
import com.namasoft.pos.application.POSTooltip;
import com.namasoft.pos.application.PosEntryPoint;
import com.namasoft.pos.application.PosScene;
import com.namasoft.pos.application.PosScreenCacheUtil;
import com.namasoft.pos.application.toolbar.IPOSToolBar;
import com.namasoft.pos.application.toolbar.NamaToolBar;
import com.namasoft.pos.application.toolbar.POSNewToolBar;
import com.namasoft.pos.displayPole.DisplayPoleConnectorUtil;
import com.namasoft.pos.domain.entities.POSActionHistory;
import com.namasoft.pos.domain.entities.POSSettingsInfo;
import com.namasoft.pos.domain.entities.POSUser;
import com.namasoft.pos.domain.valueobjects.POSActionType;
import com.namasoft.pos.util.POSDataWriterUtil;
import com.namasoft.pos.util.POSGeneralSettings;
import com.namasoft.pos.util.POSResult;
import com.namasoft.utils.ServerSideExceptionDescriber;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Optional;
import javafx.application.Platform;
import javafx.geometry.NodeOrientation;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Control;
import javafx.scene.control.Dialog;
import javafx.scene.control.PasswordField;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.ToolBar;
import javafx.scene.control.Tooltip;
import javafx.scene.image.ImageView;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.StackPane;
import javafx.scene.shape.ClosePath;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.PathElement;
import javafx.stage.Stage;
import javafx.stage.StageStyle;

public class BorderPaneCreator<Bar extends ToolBar> {
    public NamaBorderPane pane;
    public Bar toolBar;
    public NamaLabel userName = new NamaLabel();
    public static PosEntryPoint entryPoint;
    private static ProgressIndicator progressIndicator;
    protected int index = 0;

    public Bar getToolBar() {
        return this.toolBar;
    }

    public BorderPaneCreator() {
        progressIndicator.setVisible(false);
    }

    public static void setProgressIndicatorVisibility(boolean visibility) {
        if (progressIndicator != null) {
            progressIndicator.setVisible(visibility);
        }
    }

    public NamaBorderPane createBorderPane(IHasToolBar hasToolBar) {
        return this.createBorderPane(hasToolBar, false);
    }

    public NamaBorderPane createBorderPane(IHasToolBar hasToolBar, boolean newToolBar) {
        NamaBorderPane cachedPane;
        IHasToolBar cachedScreen;
        if (hasToolBar instanceof PosEntryPoint) {
            BorderPaneCreator.setEntryPoint((PosEntryPoint)hasToolBar);
        }
        if ((cachedScreen = PosScreenCacheUtil.fetchCachedScreen(hasToolBar.documentType())) != null && (cachedPane = cachedScreen.fetchPane()) != null) {
            cachedScreen.afterCachedScreenReDraw();
            POSResourcesUtil.currentScreen = hasToolBar;
            return cachedPane;
        }
        this.pane = new NamaBorderPane();
        this.pane.setId("main-root");
        hasToolBar.defineControllers();
        hasToolBar.updateLabeledControllersText();
        if (newToolBar) {
            this.toolBar = new POSNewToolBar(hasToolBar);
        } else if (ObjectChecker.isFalse((Boolean)(hasToolBar instanceof PosEntryPoint))) {
            this.toolBar = new NamaToolBar(hasToolBar);
        }
        this.pane.setCenter((Node)new StackPane(new Node[]{hasToolBar.fetchPaneCenter(), progressIndicator}));
        this.pane.setTop((Node)this.toolBar);
        DisplayPoleConnectorUtil.writeIdleMsg(POSResourcesUtil.fetchMainRegister());
        if (!(hasToolBar instanceof LoginScreen) && !(hasToolBar instanceof PosEntryPoint)) {
            POSSlideMenu menu = new POSSlideMenu(hasToolBar);
            this.pane.getChildren().add((Object)menu);
            menu.hide();
        }
        if (ObjectChecker.isNotEmptyOrNull(this.toolBar)) {
            ((IPOSToolBar)this.toolBar).refreshLangBox(false);
        }
        POSResourcesUtil.setOrientation(this.fetchOrentationByLang());
        POSResourcesUtil.currentScreen = hasToolBar;
        POSSettingsUtil.addStyleSheetFor("css/application.css", (Parent)this.pane);
        PosScreenCacheUtil.addScreenIfNeeded(hasToolBar);
        return this.pane;
    }

    public static Node createMenuIcon(IHasToolBar hasToolBar) {
        NamaButton menuBtn = new NamaButton();
        menuBtn.setId("menu-button");
        menuBtn.setTooltip(new POSTooltip("menu"));
        menuBtn.setOnAction(e -> AbsPosSalesScreen.showHelpMenu(hasToolBar));
        Path topLine = new Path();
        topLine.getStyleClass().add((Object)"menu-path");
        topLine.getElements().addAll((Object[])new PathElement[]{new MoveTo(11.5, 15.0), new LineTo(32.5, 15.0), new LineTo(34.0, 14.3284), new LineTo(34.0, 13.5), new LineTo(33.3284, 12.0), new LineTo(32.5, 12.0), new LineTo(11.5, 12.0), new LineTo(10.0, 12.6716), new LineTo(10.0, 13.5), new LineTo(10.6716, 15.0), new LineTo(11.5, 15.0), new ClosePath()});
        Path middleLine = new Path();
        middleLine.getStyleClass().add((Object)"menu-path");
        middleLine.getElements().addAll((Object[])new PathElement[]{new MoveTo(32.5, 19.0), new LineTo(11.5, 19.0), new LineTo(10.0, 19.6716), new LineTo(10.0, 20.5), new LineTo(10.6716, 22.0), new LineTo(11.5, 22.0), new LineTo(32.5, 22.0), new LineTo(34.0, 21.3284), new LineTo(34.0, 20.5), new LineTo(33.3284, 19.0), new LineTo(32.5, 19.0), new ClosePath()});
        Path bottomLine = new Path();
        bottomLine.getStyleClass().add((Object)"menu-path");
        bottomLine.getElements().addAll((Object[])new PathElement[]{new MoveTo(32.5, 26.0), new LineTo(11.5, 26.0), new LineTo(10.0, 26.6716), new LineTo(10.0, 27.5), new LineTo(10.6716, 29.0), new LineTo(11.5, 29.0), new LineTo(32.5, 29.0), new LineTo(34.0, 28.3284), new LineTo(34.0, 27.5), new LineTo(33.3284, 26.0), new LineTo(32.5, 26.0), new ClosePath()});
        Group iconGroup = new Group(new Node[]{topLine, middleLine, bottomLine});
        menuBtn.setGraphic((Node)iconGroup);
        return menuBtn;
    }

    private NodeOrientation fetchOrentationByLang() {
        if (ObjectChecker.areEqual((Object)POSResourcesUtil.getCurrentLang(), (Object)Language.English)) {
            return NodeOrientation.LEFT_TO_RIGHT;
        }
        return NodeOrientation.RIGHT_TO_LEFT;
    }

    public static void setEntryPoint(PosEntryPoint entryPoint) {
        BorderPaneCreator.entryPoint = entryPoint;
    }

    public static void changePassword(Stage stage, IHasToolBar hasToolBar) {
        if (PosScene.noConnection()) {
            POSResult posResult = new POSResult();
            posResult.failure(POSResourcesUtil.id("Connection Failed", new Object[0]), new Object[0]);
            POSErrorAndInfoMessagesUtil.showError(posResult, stage);
        } else {
            GridPane grid = new GridPane();
            grid.setId("change-password-grid");
            PasswordField currentPassword = new PasswordField();
            currentPassword.setPromptText(POSResourcesUtil.id("currentPassword", new Object[0]));
            PasswordField newPassword = new PasswordField();
            newPassword.setPromptText(POSResourcesUtil.id("newPassword", new Object[0]));
            PasswordField confirmPassword = new PasswordField();
            confirmPassword.setPromptText(POSResourcesUtil.id("confirmPassword", new Object[0]));
            grid.add((Node)currentPassword, 0, 0);
            grid.add((Node)newPassword, 0, 1);
            grid.add((Node)confirmPassword, 0, 2);
            NamaDialog<ButtonType> dialog = new NamaDialog<ButtonType>("changePassword");
            dialog.addOkButton("");
            dialog.addCancelButton("");
            dialog.initStyle(StageStyle.UNDECORATED);
            dialog.content((Node)grid);
            Platform.runLater(() -> currentPassword.requestFocus());
            Optional result = dialog.showAndWait();
            if (result.isPresent() && ObjectChecker.areEqual((Object)((ButtonType)result.get()).getButtonData(), (Object)ButtonType.APPLY.getButtonData())) {
                BorderPaneCreator.tryChangingUserPassword(stage, dialog, currentPassword, newPassword, confirmPassword);
            }
        }
    }

    private static void tryChangingUserPassword(Stage stage, Dialog<ButtonType> dialog, PasswordField currentPassword, PasswordField newPassword, PasswordField confirmPassword) {
        POSResult posResult = new POSResult();
        POSUser currentUser = POSSettingsInfo.fetchConfiguration().getCurrentUser();
        if (ObjectChecker.areEqual((Object)currentUser.getUserId(), (Object)POSGeneralSettings.getLoginID())) {
            dialog.close();
            posResult.failure(POSResourcesUtil.id("Please use different user id and password in {0} file", "nama.properties"), new Object[0]);
            POSErrorAndInfoMessagesUtil.showError(posResult, stage);
            return;
        }
        boolean emptyFields = ObjectChecker.isAnyEmptyOrNull((Object[])new Object[]{currentPassword.getText(), newPassword.getText(), confirmPassword.getText()});
        boolean diffPasswords = ObjectChecker.areNotEqual((Object)newPassword.getText(), (Object)confirmPassword.getText());
        if (emptyFields) {
            posResult.failure(POSResourcesUtil.id("Please fill fields", new Object[0]), new Object[0]);
        }
        if (diffPasswords) {
            posResult.failure(POSResourcesUtil.id("Different Passwords", new Object[0]), new Object[0]);
        }
        if (posResult.isFailed().booleanValue()) {
            dialog.close();
            POSErrorAndInfoMessagesUtil.showError(posResult, stage);
            return;
        }
        if (ObjectChecker.areEqual((Object)currentUser.getPassword(), (Object)BorderPaneCreator.hash(currentPassword.getText().trim()))) {
            currentUser.setPassword(newPassword.getText());
            try {
                String userNewPassword = POSDataWriterUtil.writeUser(currentUser);
                if (userNewPassword != null && userNewPassword.startsWith("#**#P")) {
                    userNewPassword = userNewPassword.substring("#**#P".length());
                }
                currentUser.setPassword(userNewPassword);
                POSPersister.saveOrUpdateWithActionHistory(currentUser, null);
                dialog.close();
            }
            catch (NaMaServiceExcepption ex) {
                posResult.failure(ServerSideExceptionDescriber.describeResult((ResultDTO)ex.getFaultInfo(), (Language)Language.English), new Object[0]);
                posResult.setLog(ex.getFaultInfo().getLog());
            }
            catch (Exception e) {
                dialog.setHeaderText("Connection Failed");
                NaMaLogger.error((Throwable)e);
            }
        } else {
            posResult.failure(POSResourcesUtil.id("Invalid current password", new Object[0]), new Object[0]);
        }
        if (posResult.isFailed().booleanValue()) {
            POSErrorAndInfoMessagesUtil.showError(posResult, stage);
        }
    }

    public static String hash(String password) {
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            md5.reset();
            md5.update(password.getBytes(Charset.forName("UTF-8")));
            byte[] digest = md5.digest();
            return BorderPaneCreator.byteArrayToHexString(digest);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Error in cryptography system");
        }
    }

    protected static String byteArrayToHexString(byte[] digest) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < digest.length; ++i) {
            String hex = Integer.toHexString(0xFF & digest[i]);
            if (hex.length() == 1) {
                sb.append('0');
            }
            sb.append(hex);
        }
        return sb.toString();
    }

    public void refreshPaneCenter(IHasToolBar hasToolBar) {
        hasToolBar.fetchScene().setNodeOrientation(POSResourcesUtil.getOrientation());
        this.pane.setNodeOrientation(POSResourcesUtil.getOrientation());
        BorderPaneCreator.refresh((Node)this.pane);
        Bar toolBar = hasToolBar.fetchPaneCreator().toolBar;
        if (ObjectChecker.isNotEmptyOrNull(toolBar)) {
            ((IPOSToolBar)toolBar).updateInformation(hasToolBar.document());
            ((IPOSToolBar)toolBar).refreshLangBox(false);
        }
        hasToolBar.updateLabeledControllersText();
        hasToolBar.updateTableColumnsTitle();
        POSSlideMenu oldMenu = (POSSlideMenu)hasToolBar.fetchPane().lookup("#" + hasToolBar.menuId());
        hasToolBar.fetchPaneCreator().pane.getChildren().remove((Object)oldMenu);
        POSSlideMenu menu = new POSSlideMenu(hasToolBar);
        hasToolBar.fetchPaneCreator().pane.getChildren().add((Object)menu);
        menu.hide();
    }

    public static void refresh(Node child) {
        Control control;
        Tooltip tooltip;
        if (child instanceof Parent) {
            Parent parent = (Parent)child;
            parent.getChildrenUnmodifiable().forEach(c -> BorderPaneCreator.refresh(c));
        }
        if (child instanceof IHasFont) {
            ((IHasFont)child).refreshContent();
        }
        if (child instanceof Control && (tooltip = (control = (Control)child).getTooltip()) instanceof POSTooltip) {
            POSTooltip hasTooltip = (POSTooltip)tooltip;
            hasTooltip.refreshContent();
        }
        if (ObjectChecker.isFalse((Boolean)child.nodeOrientationProperty().isBound()) && ObjectChecker.isFalse((Boolean)(child instanceof ImageView))) {
            child.setNodeOrientation(POSResourcesUtil.getOrientation());
        }
    }

    public void exitToLoginScreen(Stage stage) {
        PosScreenCacheUtil.clearExceptLoginScreen();
        POSResourcesUtil.currentSetting.setCurrentUser(null);
        stage.setMaximized(true);
        BorderPaneCreator<Bar> paneCreator = new BorderPaneCreator<Bar>();
        this.pane = paneCreator.createBorderPane(entryPoint);
        PosScene scene = entryPoint.fetchScene();
        if (scene == null) {
            scene = new PosScene((Parent)this.pane, stage.getWidth(), stage.getHeight(), entryPoint, stage);
        } else {
            scene.setRoot((Parent)this.pane);
        }
        scene.setNodeOrientation(POSResourcesUtil.getOrientation());
        stage.setScene((Scene)scene);
        POSPersister.saveOrUpdate(POSActionHistory.create(null, POSActionType.LogOut));
    }

    static {
        progressIndicator = new ProgressIndicator();
    }
}

