/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.application;

import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.modules.commonbasic.enums.DiscountLocation;
import com.namasoft.namacontrols.tablecells.POSSalesTableFields;
import com.namasoft.pos.domain.details.AbsPOSSalesLine;
import com.namasoft.pos.domain.valueobjects.POSDiscountTax;
import com.namasoft.pos.util.POSScreenSettings;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.function.Function;

public class DiscountTypeInfo {
    private String columnId;
    private String valueColumnId;
    private String percentColumnId;
    private String afterDiscColumnId;
    private String valueColumnScreenSettingsId;
    private String percentColumnScreenSettingsId;
    private String afterDiscColumnScreenSettingsId;
    private String valueColumnWidth;
    private String percentColumnWidth;
    private String afterDiscColumnWidth;
    private String afterDiscColumnTitle;
    private Function<AbsPOSSalesLine, POSDiscountTax> fetchDiscObj;
    private Function<AbsPOSSalesLine, BigDecimal> fetchAfterDiscVal;
    private static HashMap<DiscountLocation, DiscountTypeInfo> discountIDs = new HashMap();

    public DiscountTypeInfo(String columnId, String valueColumnId, String percentColumnId, String afterDiscColumnId, String valueColumnScreenSettingsId, String percentColumnScreenSettingsId, String afterDiscColumnScreenSettingsId, String valueColumnWidth, String percentColumnWidth, String afterDiscColumnWidth, Function<AbsPOSSalesLine, POSDiscountTax> fetchDiscObj, String afterDiscColumnTitle, Function<AbsPOSSalesLine, BigDecimal> fetchAfterDiscVal) {
        this.columnId = columnId;
        this.valueColumnId = valueColumnId;
        this.percentColumnId = percentColumnId;
        this.afterDiscColumnId = afterDiscColumnId;
        this.valueColumnScreenSettingsId = valueColumnScreenSettingsId;
        this.percentColumnScreenSettingsId = percentColumnScreenSettingsId;
        this.afterDiscColumnScreenSettingsId = afterDiscColumnScreenSettingsId;
        this.valueColumnWidth = valueColumnWidth;
        this.percentColumnWidth = percentColumnWidth;
        this.afterDiscColumnWidth = afterDiscColumnWidth;
        this.fetchDiscObj = fetchDiscObj;
        this.afterDiscColumnTitle = afterDiscColumnTitle;
        this.fetchAfterDiscVal = fetchAfterDiscVal;
    }

    public static DiscountTypeInfo fetchDiscountTypeInfo(DiscountLocation discountLocation) {
        if (ObjectChecker.isNotEmptyOrNull(discountIDs)) {
            return discountIDs.get(discountLocation);
        }
        discountIDs.put(DiscountLocation.Discount1, new DiscountTypeInfo(POSSalesTableFields.Disc1_Col, POSSalesTableFields.Disc1_Val_Col, POSSalesTableFields.Disc1_Percent_Col, POSSalesTableFields.After_Disc1_Col, "disc1ValColWidth", "disc1PercentColWidth", "afterDisc1ColWidth", POSScreenSettings.getDisc1ValColWidth(), POSScreenSettings.getDisc1PercentColWidth(), POSScreenSettings.getAfterDisc1ColW(), line -> line.getDiscount1(), "details.afterDisc1", line -> line.getAfterDisc1()));
        discountIDs.put(DiscountLocation.Discount2, new DiscountTypeInfo(POSSalesTableFields.Disc2_Col, POSSalesTableFields.Disc2_Val_Col, POSSalesTableFields.Disc2_Percent_Col, POSSalesTableFields.After_Disc2_Col, "disc2ValColWidth", "disc2PercentColWidth", "afterDisc2ColWidth", POSScreenSettings.getDisc2ValColWidth(), POSScreenSettings.getDisc2PercentColWidth(), POSScreenSettings.getAfterDisc2ColW(), line -> line.getDiscount2(), "details.afterDisc2", line -> line.getAfterDisc2()));
        discountIDs.put(DiscountLocation.Discount3, new DiscountTypeInfo(POSSalesTableFields.Disc3_Col, POSSalesTableFields.Disc3_Val_Col, POSSalesTableFields.Disc3_Percent_Col, POSSalesTableFields.After_Disc3_Col, "disc3ValColWidth", "disc3PercentColWidth", "afterDisc3ColWidth", POSScreenSettings.getDisc3ValColWidth(), POSScreenSettings.getDisc3PercentColWidth(), POSScreenSettings.getAfterDisc3ColW(), line -> line.getDiscount3(), "details.afterDisc3", line -> line.getAfterDisc3()));
        discountIDs.put(DiscountLocation.Discount4, new DiscountTypeInfo(POSSalesTableFields.Disc4_Col, POSSalesTableFields.Disc4_Val_Col, POSSalesTableFields.Disc4_Percent_Col, POSSalesTableFields.After_Disc4_Col, "disc4ValColWidth", "disc4PercentColWidth", "afterDisc4ColWidth", POSScreenSettings.getDisc4ValColWidth(), POSScreenSettings.getDisc4PercentColWidth(), POSScreenSettings.getAfterDisc4ColW(), line -> line.getDiscount4(), "details.afterDisc4", line -> line.getAfterDisc4()));
        discountIDs.put(DiscountLocation.Discount5, new DiscountTypeInfo(POSSalesTableFields.Disc5_Col, POSSalesTableFields.Disc5_Val_Col, POSSalesTableFields.Disc5_Percent_Col, POSSalesTableFields.After_Disc5_Col, "disc5ValColWidth", "disc5PercentColWidth", "afterDisc5ColWidth", POSScreenSettings.getDisc5ValColWidth(), POSScreenSettings.getDisc5PercentColWidth(), POSScreenSettings.getAfterDisc5ColW(), line -> line.getDiscount5(), "details.afterDisc5", line -> line.getAfterDisc5()));
        discountIDs.put(DiscountLocation.Discount6, new DiscountTypeInfo(POSSalesTableFields.Disc6_Col, POSSalesTableFields.Disc6_Val_Col, POSSalesTableFields.Disc6_Percent_Col, POSSalesTableFields.After_Disc6_Col, "disc6ValColWidth", "disc6PercentColWidth", "afterDisc6ColWidth", POSScreenSettings.getDisc6ValColWidth(), POSScreenSettings.getDisc6PercentColWidth(), POSScreenSettings.getAfterDisc6ColW(), line -> line.getDiscount6(), "details.afterDisc6", line -> line.getAfterDisc6()));
        discountIDs.put(DiscountLocation.Discount7, new DiscountTypeInfo(POSSalesTableFields.Disc7_Col, POSSalesTableFields.Disc7_Val_Col, POSSalesTableFields.Disc7_Percent_Col, POSSalesTableFields.After_Disc7_Col, "disc7ValColWidth", "disc7PercentColWidth", "afterDisc7ColWidth", POSScreenSettings.getDisc7ValColWidth(), POSScreenSettings.getDisc7PercentColWidth(), POSScreenSettings.getAfterDisc7ColW(), line -> line.getDiscount7(), "details.afterDisc7", line -> line.getAfterDisc7()));
        discountIDs.put(DiscountLocation.Discount8, new DiscountTypeInfo(POSSalesTableFields.Disc8_Col, POSSalesTableFields.Disc8_Val_Col, POSSalesTableFields.Disc8_Percent_Col, POSSalesTableFields.After_Disc8_Col, "disc8ValColWidth", "disc8PercentColWidth", "afterDisc8ColWidth", POSScreenSettings.getDisc8ValColWidth(), POSScreenSettings.getDisc8PercentColWidth(), POSScreenSettings.getAfterDisc8ColW(), line -> line.getDiscount8(), "details.afterDisc8", line -> line.getAfterDisc8()));
        return discountIDs.get(discountLocation);
    }

    public Function<AbsPOSSalesLine, BigDecimal> getFetchAfterDiscVal() {
        return this.fetchAfterDiscVal;
    }

    public String getAfterDiscColumnTitle() {
        return this.afterDiscColumnTitle;
    }

    public Function<AbsPOSSalesLine, POSDiscountTax> getFetchDiscObj() {
        return this.fetchDiscObj;
    }

    public String getColumnId() {
        return this.columnId;
    }

    public String getValueColumnId() {
        return this.valueColumnId;
    }

    public String getPercentColumnId() {
        return this.percentColumnId;
    }

    public String getAfterDiscColumnId() {
        return this.afterDiscColumnId;
    }

    public String getValueColumnScreenSettingsId() {
        return this.valueColumnScreenSettingsId;
    }

    public String getPercentColumnScreenSettingsId() {
        return this.percentColumnScreenSettingsId;
    }

    public String getAfterDiscColumnScreenSettingsId() {
        return this.afterDiscColumnScreenSettingsId;
    }

    public static HashMap<DiscountLocation, DiscountTypeInfo> getDiscountIDs() {
        return discountIDs;
    }

    public String getValueColumnWidth() {
        return this.valueColumnWidth;
    }

    public String getPercentColumnWidth() {
        return this.percentColumnWidth;
    }

    public String getAfterDiscColumnWidth() {
        return this.afterDiscColumnWidth;
    }
}

