/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.application;

import com.namasoft.common.TriConsumer;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.namacontrols.NamaButton;
import com.namasoft.pos.application.POSNewSalesScreen;
import com.namasoft.pos.application.POSResourcesUtil;
import com.namasoft.pos.application.PosScene;
import com.namasoft.pos.domain.details.POSRegisteryFavouriteDocLine;
import com.namasoft.pos.domain.entities.PosDocCategory;
import java.util.HashMap;
import javafx.event.Event;

public class FavouriteDocBtn
extends NamaButton {
    private String arabicTitle;
    private String englishTitle;
    private static HashMap<String, TriConsumer<Event, POSNewSalesScreen, PosDocCategory>> docTypeWithAction = new HashMap();

    public FavouriteDocBtn(POSRegisteryFavouriteDocLine favouriteDocLine, Number favDocW, Number favDocH, POSNewSalesScreen screen) {
        String entityType = favouriteDocLine.getEntityType();
        this.arabicTitle = favouriteDocLine.getBtnArabicTitle();
        this.englishTitle = favouriteDocLine.getBtnEnglishTitle();
        String title = (String)ObjectChecker.getFirstNotEmptyObj((Object[])new String[]{this.englishTitle, this.arabicTitle, POSResourcesUtil.id(entityType, new Object[0])});
        if (POSResourcesUtil.isArabic()) {
            title = (String)ObjectChecker.getFirstNotEmptyObj((Object[])new String[]{this.arabicTitle, this.englishTitle, POSResourcesUtil.id(entityType, new Object[0])});
        }
        this.setText(title);
        this.setWrapText(true);
        this.setMinHeight(favDocH.doubleValue());
        this.setMinWidth(favDocW.doubleValue());
        this.setId("favourite-doc-btn");
        this.setOnAction(event -> FavouriteDocBtn.docTypeWithAction(entityType).accept((Object)event, (Object)screen, (Object)favouriteDocLine.getDocCategory()));
    }

    private static TriConsumer<Event, POSNewSalesScreen, PosDocCategory> docTypeWithAction(String entityType) {
        if (ObjectChecker.isNotEmptyOrNull(docTypeWithAction)) {
            return docTypeWithAction.get(entityType);
        }
        docTypeWithAction.put("NamaPOSSalesInvoice", (TriConsumer<Event, POSNewSalesScreen, PosDocCategory>)((TriConsumer)(e, screen, docCategory) -> PosScene.drawSalesScreen(screen.fetchStage(), docCategory)));
        docTypeWithAction.put("NamaPOSSalesReturn", (TriConsumer<Event, POSNewSalesScreen, PosDocCategory>)((TriConsumer)(e, screen, docCategory) -> PosScene.drawSalesReturn(screen, screen.fetchStage(), e, docCategory)));
        docTypeWithAction.put("NamaPOSSalesReplacement", (TriConsumer<Event, POSNewSalesScreen, PosDocCategory>)((TriConsumer)(e, screen, docCategory) -> PosScene.drawSalesReplacment(screen, screen.fetchStage(), e, docCategory)));
        docTypeWithAction.put("NamaPOSStockTransferReq", (TriConsumer<Event, POSNewSalesScreen, PosDocCategory>)((TriConsumer)(e, screen, docCategory) -> PosScene.drawStockTransferReq(screen, screen.fetchStage(), e, docCategory)));
        docTypeWithAction.put("NamaPOSStockTakingDetails", (TriConsumer<Event, POSNewSalesScreen, PosDocCategory>)((TriConsumer)(e, screen, docCategory) -> PosScene.drawStockTakingDoc(screen.fetchStage(), docCategory)));
        docTypeWithAction.put("POSPaymentToRegister", (TriConsumer<Event, POSNewSalesScreen, PosDocCategory>)((TriConsumer)(e, screen, docCategory) -> PosScene.createPaymentScreen(screen.fetchStage(), "")));
        docTypeWithAction.put("POSReceiptFromRegister", (TriConsumer<Event, POSNewSalesScreen, PosDocCategory>)((TriConsumer)(e, screen, docCategory) -> PosScene.createReceiptScreen(screen.fetchStage())));
        docTypeWithAction.put("POSShiftOpening", (TriConsumer<Event, POSNewSalesScreen, PosDocCategory>)((TriConsumer)(e, screen, docCategory) -> PosScene.drawShiftsScreen(screen.fetchStage(), screen, e)));
        docTypeWithAction.put("POSShiftClosing", (TriConsumer<Event, POSNewSalesScreen, PosDocCategory>)((TriConsumer)(e, screen, docCategory) -> PosScene.drawShiftsScreen(screen.fetchStage(), screen, e)));
        docTypeWithAction.put("POSCashDrawer", (TriConsumer<Event, POSNewSalesScreen, PosDocCategory>)((TriConsumer)(e, screen, docCategory) -> PosScene.drawCashCountScreen(screen.fetchStage())));
        docTypeWithAction.put("NamaPOSOrderReservation", (TriConsumer<Event, POSNewSalesScreen, PosDocCategory>)((TriConsumer)(e, screen, docCategory) -> PosScene.drawReservationScreen(screen.fetchStage())));
        docTypeWithAction.put("NamaPOSCancelReservation", (TriConsumer<Event, POSNewSalesScreen, PosDocCategory>)((TriConsumer)(e, screen, docCategory) -> PosScene.drawCancelReservationScreen(screen.fetchStage())));
        docTypeWithAction.put("NamaPOSStockReceipt", (TriConsumer<Event, POSNewSalesScreen, PosDocCategory>)((TriConsumer)(e, screen, docCategory) -> PosScene.drawStockReceiptScreen(screen.fetchStage())));
        docTypeWithAction.put("NamaPOSShortfallsDoc", (TriConsumer<Event, POSNewSalesScreen, PosDocCategory>)((TriConsumer)(e, screen, docCategory) -> PosScene.drawShortfallsDoc(screen, screen.fetchStage(), e, docCategory)));
        docTypeWithAction.put("NamaPOSScrapDoc", (TriConsumer<Event, POSNewSalesScreen, PosDocCategory>)((TriConsumer)(e, screen, docCategory) -> PosScene.drawScrapDoc(screen, screen.fetchStage(), e, docCategory)));
        return docTypeWithAction.get(entityType);
    }

    @Override
    public void refreshContent() {
        String title = (String)ObjectChecker.getFirstNotEmptyObj((Object[])new String[]{this.englishTitle, this.arabicTitle, this.getText()});
        if (POSResourcesUtil.isArabic()) {
            title = (String)ObjectChecker.getFirstNotEmptyObj((Object[])new String[]{this.arabicTitle, this.englishTitle, this.getText()});
        }
        this.setText(title);
    }
}

