/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.application;

import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.namacontrols.NamaBorderPane;
import com.namasoft.namacontrols.NamaSearchBox;
import com.namasoft.namacontrols.POSErrorAndInfoMessagesUtil;
import com.namasoft.pos.application.BorderPaneCreator;
import com.namasoft.pos.application.IPOSFieldInfo;
import com.namasoft.pos.application.POSDocumentType;
import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.application.POSResourcesUtil;
import com.namasoft.pos.application.PosScene;
import com.namasoft.pos.application.PosShortcutsUtil;
import com.namasoft.pos.domain.POSMasterFile;
import com.namasoft.pos.domain.entities.POSCustomer;
import com.namasoft.pos.util.POSIdleMonitor;
import com.namasoft.pos.util.POSResult;
import java.util.HashMap;
import javafx.event.Event;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.TableView;
import javafx.stage.Modality;
import javafx.stage.Stage;

public interface IHasToolBar {
    default public Node fetchPaneCenter() {
        return null;
    }

    public PosScene fetchScene();

    public Stage fetchStage();

    default public POSDocumentType documentType() {
        return POSDocumentType.Invoice;
    }

    default public NamaBorderPane fetchPane() {
        return null;
    }

    default public BorderPaneCreator fetchPaneCreator() {
        return null;
    }

    default public String screenTitle() {
        return "";
    }

    default public POSIdleMonitor fetchMonitor() {
        return null;
    }

    default public String fetchScreenEntityType() {
        return "";
    }

    default public void doPostSaveAction() {
    }

    default public void defineControllers() {
    }

    default public void updateLabeledControllersText() {
    }

    default public void updateTableColumnsTitle() {
    }

    default public void fireSelectItemAction(Class<?> onKlass, TableView<POSMasterFile> table, POSMasterFile selectedItem) {
    }

    default public void fireOpenOldDocAction(POSMasterFile selectedItem, Event event) {
    }

    default public TableView fetchScreenTable() {
        return null;
    }

    default public void escapeAction() {
    }

    default public void extraCodeSelectionActions(NamaSearchBox namaSearchBox) {
    }

    default public void terminateAction(Stage stage, Event e) {
        PosShortcutsUtil.terminate(stage, e, this);
    }

    default public void onCustomerAdded(POSCustomer customer) {
    }

    default public <T extends POSMasterFile> T document() {
        return null;
    }

    default public void onCustomerRemoved() {
    }

    default public String menuId() {
        return "new-menu";
    }

    default public Class fetchScreenKlass() {
        return POSMasterFile.class;
    }

    default public void updateSubsidiary(POSMasterFile subsidiary, String subsidiaryType) {
    }

    default public <T extends POSMasterFile> void afterCachedScreenReDraw() {
    }

    public HashMap<String, IPOSFieldInfo> fetchFieldsMap();

    default public boolean saveOrUpdateByUser(POSMasterFile object, Stage stage) {
        POSResult posResult = POSPersister.saveOrUpdateWithActionHistory(object);
        if (posResult.isFailed().booleanValue()) {
            if (ObjectChecker.isNotEmptyOrNull((Object)stage)) {
                POSErrorAndInfoMessagesUtil.showError(posResult, stage);
            } else {
                Alert alert = new Alert(Alert.AlertType.ERROR);
                alert.setHeaderText("Error");
                alert.initModality(Modality.WINDOW_MODAL);
                alert.setContentText(POSResourcesUtil.isArabic() ? posResult.getArMessage() : posResult.getEnMessage());
                alert.showAndWait();
            }
            return false;
        }
        return true;
    }
}

