/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.application;

import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.modules.namapos.enums.POSSecurityCapability;
import com.namasoft.namacontrols.NamaBorderPane;
import com.namasoft.namacontrols.NamaButton;
import com.namasoft.namacontrols.NamaHBox;
import com.namasoft.namacontrols.NamaLabel;
import com.namasoft.namacontrols.NamaPasswordField;
import com.namasoft.namacontrols.NamaText;
import com.namasoft.namacontrols.NamaTextField;
import com.namasoft.namacontrols.NamaVBox;
import com.namasoft.namacontrols.POSErrorAndInfoMessagesUtil;
import com.namasoft.namacontrols.POSSettingsUtil;
import com.namasoft.namacontrols.PosTempDocumentUtil;
import com.namasoft.pos.application.BorderPaneCreator;
import com.namasoft.pos.application.IHasToolBar;
import com.namasoft.pos.application.IPOSFieldInfo;
import com.namasoft.pos.application.POSCodeGenerator;
import com.namasoft.pos.application.POSFieldType;
import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.application.POSResourcesUtil;
import com.namasoft.pos.application.POSSlideMenu;
import com.namasoft.pos.application.POSTooltip;
import com.namasoft.pos.application.PosScene;
import com.namasoft.pos.application.PosShortcutsUtil;
import com.namasoft.pos.application.toolbar.IPOSToolBar;
import com.namasoft.pos.domain.entities.POSActionHistory;
import com.namasoft.pos.domain.entities.POSRegistery;
import com.namasoft.pos.domain.entities.POSSettingsInfo;
import com.namasoft.pos.domain.entities.POSShiftOpen;
import com.namasoft.pos.domain.entities.POSUser;
import com.namasoft.pos.domain.valueobjects.POSActionType;
import com.namasoft.pos.util.LoginUtil;
import com.namasoft.pos.util.POSDataReaderUtil;
import com.namasoft.pos.util.POSImgUtil;
import com.namasoft.pos.util.POSNotificationsTask;
import com.namasoft.pos.util.POSResult;
import com.namasoft.pos.util.POSSecurityUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import javafx.application.Platform;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.stage.Screen;
import javafx.stage.Stage;

public class LoginScreen
implements IHasToolBar {
    private GridPane mainGrid;
    private NamaLabel userNameLabel;
    private NamaTextField userName;
    private NamaLabel passwordLabel;
    private NamaPasswordField password;
    private NamaButton loginBtn;
    private NamaButton mobQrCodeBtn;
    private HBox loginBtnBox;
    private BorderPaneCreator pane;
    private Stage stage;
    private NamaBorderPane root;
    private final double RightSideWidthPercent = 1.9;
    private double LeftSideWidthPercent = 2.1;

    public Pane draw(Stage primaryStage, BorderPaneCreator paneCreator) {
        if (this.root != null) {
            return this.root;
        }
        this.pane = paneCreator;
        this.stage = primaryStage;
        this.stage.setOnCloseRequest(event -> PosScene.onCloseRequestEvent(e -> PosShortcutsUtil.terminateAll(), event));
        this.root = new NamaBorderPane();
        Pane rightSide = this.createRightSide();
        this.root.setRight((Node)rightSide);
        Pane leftSide = this.createLeftSide();
        this.root.setLeft((Node)leftSide);
        primaryStage.widthProperty().addListener((observable, oldValue, newValue) -> {
            rightSide.setPrefWidth(newValue.doubleValue() / 1.9);
            leftSide.setPrefWidth(newValue.doubleValue() / this.LeftSideWidthPercent);
        });
        POSSettingsUtil.addStyleSheetFor("css/loginscreen.css", (Parent)this.root);
        return this.root;
    }

    private Pane createRightSide() {
        String welcomeMsg = "Namasoft";
        InputStream logo = POSImgUtil.convertToInputStream(POSResourcesUtil.loadImageFromResources("namaLogo.jpg"));
        POSRegistery posRegistery = POSResourcesUtil.fetchMainRegister();
        if (posRegistery != null) {
            welcomeMsg = posRegistery.fetchRegisterLoginTitle();
            logo = (InputStream)ObjectChecker.getFirstNotEmptyObj((Object[])new InputStream[]{posRegistery.fetchLogo(), logo});
        }
        NamaText welcomeMsgText = new NamaText(welcomeMsg, new Object[0]);
        welcomeMsgText.setId("welcome-msg");
        welcomeMsgText.styleProperty().bind((ObservableValue)Bindings.concat((Object[])new Object[]{"-fx-font-size: ", Bindings.divide((ObservableNumberValue)this.stage.widthProperty(), (ObservableNumberValue)welcomeMsgText.textProperty().length()).multiply(0.75).asString(), "px;"}));
        NamaVBox rightSide = new NamaVBox(10);
        rightSide.setId("right-side");
        rightSide.getChildren().add((Object)welcomeMsgText);
        if (ObjectChecker.isEmptyOrNull((Object)logo)) {
            return rightSide;
        }
        ImageView imageView = new ImageView(new Image(logo, this.stage.getWidth() / 1.9 - 100.0, 0.0, true, true));
        rightSide.prefWidthProperty().addListener(e -> {
            imageView.setFitWidth(this.stage.getWidth() / 1.9 - 100.0);
            imageView.setPreserveRatio(true);
        });
        rightSide.getChildren().add((Object)imageView);
        return rightSide;
    }

    private Pane createLeftSide() {
        NamaVBox leftSide = new NamaVBox();
        leftSide.setId("left-side");
        this.userNameLabel = new NamaLabel("Username");
        this.userName = new NamaTextField(POSFieldType.Text);
        this.passwordLabel = new NamaLabel("password");
        this.password = new NamaPasswordField();
        Platform.runLater(() -> this.userName.requestFocus());
        this.userName.setOnKeyPressed(e -> {
            if (e.getCode().equals((Object)KeyCode.ENTER)) {
                Platform.runLater(() -> this.password.requestFocus());
            }
        });
        this.password.setOnKeyPressed(e -> {
            if (e.getCode().equals((Object)KeyCode.ENTER)) {
                this.tryLogin(this.stage);
            }
        });
        this.loginBtn = new NamaButton("logIn");
        this.loginBtn.getStyleClass().add((Object)"apply-button");
        this.loginBtn.setOnAction(e -> this.tryLogin(this.stage));
        this.loginBtn.addEventFilter(KeyEvent.KEY_PRESSED, event -> {
            if (event.getCode() == KeyCode.TAB) {
                Platform.runLater(() -> this.userName.requestFocus());
            }
        });
        this.mobQrCodeBtn = new NamaButton("mobAppsQrCode");
        this.mobQrCodeBtn.setTooltip(new POSTooltip("mobAppsQrCode"));
        this.mobQrCodeBtn.setOnAction(event -> POSSlideMenu.showQrCodeForMobApps());
        this.loginBtnBox = new HBox();
        this.loginBtnBox.setId("login-btns-box");
        this.loginBtnBox.getChildren().addAll((Object[])new Node[]{this.loginBtn, this.mobQrCodeBtn});
        POSSettingsUtil.setFonts(25.0, this.getClass().getClassLoader(), new Node[]{this.userNameLabel, this.passwordLabel, this.userName, this.loginBtn, this.password, this.mobQrCodeBtn});
        this.mainGrid = new GridPane();
        NamaVBox.setVgrow((Node)this.mainGrid, (Priority)Priority.ALWAYS);
        ColumnConstraints col1 = new ColumnConstraints();
        ColumnConstraints col2 = new ColumnConstraints();
        leftSide.widthProperty().addListener((observable, oldValue, newValue) -> col2.setPrefWidth(newValue.doubleValue() * 0.7));
        this.mainGrid.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{col1, col2});
        leftSide.widthProperty().addListener((observable, oldValue, newValue) -> this.mainGrid.setPrefWidth(newValue.doubleValue() * 0.84));
        double height = Screen.getPrimary().getVisualBounds().getHeight();
        this.mainGrid.setPadding(new Insets(height / 3.5, 0.0, 0.0, 0.0));
        this.mainGrid.setId("login-grid");
        this.mainGrid.add((Node)this.userNameLabel, 0, 0);
        this.mainGrid.add((Node)this.userName, 1, 0);
        this.mainGrid.add((Node)this.passwordLabel, 0, 1);
        this.mainGrid.add((Node)this.password, 1, 1);
        this.mainGrid.add((Node)this.loginBtnBox, 0, 2, 2, 1);
        NamaText poweredByNamasoft = new NamaText("Powered By {0}", POSResourcesUtil.id("applicationName", new Object[0]));
        poweredByNamasoft.setId("poweredByNamasoft");
        leftSide.getChildren().addAll((Object[])new Node[]{this.createShortcutsBox(), this.mainGrid, poweredByNamasoft});
        return leftSide;
    }

    private void tryLogin(Stage primaryStage) {
        POSResult result = new POSResult();
        String userId = this.userName.getText();
        POSUser user = LoginUtil.authenticateUser(userId, this.password.getText(), result);
        if (result.isFailed().booleanValue()) {
            POSErrorAndInfoMessagesUtil.showError(result, primaryStage);
            return;
        }
        if (this.shouldPreventUserLogin(user)) {
            String preventedLoginMessage = user.getPreventedLoginMessage();
            if (ObjectChecker.isEmptyOrNull((Object)preventedLoginMessage)) {
                preventedLoginMessage = "You are prevented from login";
            }
            result.failure(preventedLoginMessage, new Object[0]);
            POSErrorAndInfoMessagesUtil.showError(result, primaryStage);
            return;
        }
        POSSettingsInfo settingsInfo = POSSettingsInfo.fetchConfiguration();
        settingsInfo.setCurrentUser(user);
        boolean savedLoginInfo = this.saveOrUpdateByUser(settingsInfo, primaryStage);
        if (ObjectChecker.isNotEmptyOrNull((Object)user) && savedLoginInfo) {
            POSCodeGenerator.fillLastDocsCodesInServerMap(POSResourcesUtil.fetchMainRegister());
            POSDataReaderUtil.cacheReportDefinitions();
            this.login(primaryStage);
            POSPersister.saveOrUpdate(POSActionHistory.create(null, POSActionType.LogIn));
        } else {
            result.failure("Wrong user name or password", new Object[0]);
            POSErrorAndInfoMessagesUtil.showError(result, primaryStage);
        }
    }

    private boolean shouldPreventUserLogin(POSUser user) {
        if (user == null) {
            return false;
        }
        return ObjectChecker.isTrue((Boolean)user.getPreventLogin());
    }

    private void login(Stage primaryStage) {
        this.pane.userName = new NamaLabel(POSSettingsInfo.fetchConfiguration().getCurrentUser().getName1());
        if (this.pane.toolBar != null) {
            ((IPOSToolBar)this.pane.toolBar).refreshLangBox(false);
        }
        this.startNotificationTaskIfNeeded(primaryStage);
        POSShiftOpen lastShift = POSResourcesUtil.fetchLastOpenShift();
        if (ObjectChecker.isEmptyOrNull((Object)lastShift)) {
            PosScene.drawShiftsScreen(primaryStage, null, null);
            return;
        }
        PosScene.drawSalesScreen(primaryStage);
        if (PosTempDocumentUtil.countCurrentTempDocs().intValue() > 0) {
            PosTempDocumentUtil.showTempDocsSelectDialogIfNeeded(true, this);
        }
    }

    private void startNotificationTaskIfNeeded(Stage stage) {
        if (POSSecurityUtil.userCan(POSSecurityCapability.CanViewNotification).isFailed().booleanValue()) {
            return;
        }
        POSNotificationsTask notificationsTask = new POSNotificationsTask();
        PosScene.setNotificationsTask(notificationsTask);
        notificationsTask.startTask(stage);
    }

    private Pane createShortcutsBox() {
        NamaHBox shortcutsBox = new NamaHBox();
        shortcutsBox.setId("shortcuts-box");
        NamaButton changeLanguage = new NamaButton();
        changeLanguage.setOnAction(event -> POSResourcesUtil.changeLanguage(POSResourcesUtil.currentScreen));
        changeLanguage.setSVGIcon("language.svg");
        changeLanguage.setTooltip(new POSTooltip(POSResourcesUtil.isArabic() ? "English" : "Arabic"));
        NamaButton keyBoardBtn = new NamaButton();
        keyBoardBtn.setTooltip(new POSTooltip("keyBoard"));
        keyBoardBtn.setSVGIcon("keyBoardIcon.svg");
        keyBoardBtn.setOnAction(event -> {
            try {
                Runtime.getRuntime().exec("cmd /c C:\\Windows\\System32\\osk.exe");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
        shortcutsBox.getChildren().addAll((Object[])new Node[]{changeLanguage, keyBoardBtn});
        return shortcutsBox;
    }

    public NamaButton getLoginBtn() {
        return this.loginBtn;
    }

    public void afterCashedScreenReDraw() {
        this.userName.clear();
        this.password.clear();
        Platform.runLater(() -> this.userName.requestFocus());
    }

    @Override
    public PosScene fetchScene() {
        return null;
    }

    @Override
    public Stage fetchStage() {
        return this.stage;
    }

    @Override
    public HashMap<String, IPOSFieldInfo> fetchFieldsMap() {
        return new HashMap<String, IPOSFieldInfo>();
    }
}

