/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.application;

import com.namasoft.common.NamaSingleValue;
import com.namasoft.common.Pair;
import com.namasoft.common.ResultDTO;
import com.namasoft.common.exceptions.NaMaServiceExcepption;
import com.namasoft.common.utilities.CollectionsUtility;
import com.namasoft.common.utilities.NaMaLogger;
import com.namasoft.common.utilities.NaMaMath;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.common.utilities.SafeBigDecimal;
import com.namasoft.common.utils.ServerStringUtils;
import com.namasoft.contracts.common.dtos.requests.SendRequest;
import com.namasoft.modules.commonbasic.contracts.valueobjects.DTOPGWProperties;
import com.namasoft.modules.namapos.contracts.common.DTOPOSCalcCouponValueRequest;
import com.namasoft.modules.namapos.contracts.valueobjects.DTOPaymentMethodInfo;
import com.namasoft.modules.namapos.enums.POSSecurityCapability;
import com.namasoft.namacontrols.NamaButton;
import com.namasoft.namacontrols.NamaCheckBox;
import com.namasoft.namacontrols.NamaDialog;
import com.namasoft.namacontrols.NamaHBox;
import com.namasoft.namacontrols.NamaLabel;
import com.namasoft.namacontrols.NamaPaymentTextField;
import com.namasoft.namacontrols.NamaTextArea;
import com.namasoft.namacontrols.NamaTextField;
import com.namasoft.namacontrols.NamaVBox;
import com.namasoft.namacontrols.POSErrorAndInfoMessagesUtil;
import com.namasoft.namacontrols.POSGridUtil;
import com.namasoft.namacontrols.POSSettingsUtil;
import com.namasoft.pos.PGW.PGWUtil;
import com.namasoft.pos.application.AbsPosSalesScreen;
import com.namasoft.pos.application.AdditionalPaymentMethodsDialog;
import com.namasoft.pos.application.ICustomPaymentMethod;
import com.namasoft.pos.application.IPosPaymentDialog;
import com.namasoft.pos.application.POSDocumentType;
import com.namasoft.pos.application.POSFieldType;
import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.application.POSResourcesUtil;
import com.namasoft.pos.application.POSTooltip;
import com.namasoft.pos.application.POSUISettingsUtil;
import com.namasoft.pos.application.PaymentDialogHelper;
import com.namasoft.pos.application.PaymentInfo;
import com.namasoft.pos.application.PosEntryPoint;
import com.namasoft.pos.application.PosKeyPad;
import com.namasoft.pos.application.PosPayMethodGroupPane;
import com.namasoft.pos.application.PosScene;
import com.namasoft.pos.application.PosShortcutsUtil;
import com.namasoft.pos.application.RewardPointsDialog;
import com.namasoft.pos.displayPole.DisplayPoleConnectorUtil;
import com.namasoft.pos.domain.AbsPOSSales;
import com.namasoft.pos.domain.POSPaymentMethod;
import com.namasoft.pos.domain.entities.POSCreditNote;
import com.namasoft.pos.domain.entities.POSCustomer;
import com.namasoft.pos.domain.entities.POSRegistery;
import com.namasoft.pos.domain.entities.POSSalesReplacement;
import com.namasoft.pos.domain.entities.POSSalesReturn;
import com.namasoft.pos.util.POSConfigurationUtil;
import com.namasoft.pos.util.POSEntityUtil;
import com.namasoft.pos.util.POSImgUtil;
import com.namasoft.pos.util.POSMediaUtil;
import com.namasoft.pos.util.POSMoneyUtils;
import com.namasoft.pos.util.POSPaymentMethodsUtil;
import com.namasoft.pos.util.POSResult;
import com.namasoft.pos.util.POSSecurityUtil;
import com.namasoft.pos.util.POSWSClient;
import com.namasoft.pos.util.PayRequest;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Control;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.stage.Screen;
import javafx.stage.Stage;

public class MultiplePaymentDialog
extends NamaDialog<ButtonType>
implements IPosPaymentDialog {
    public static final KeyCombination ALT_ENTER = KeyCodeCombination.keyCombination((String)"Alt+Enter");
    public static final KeyCombination ALT_1 = KeyCodeCombination.keyCombination((String)"Alt+1");
    public static final KeyCombination ALT_2 = KeyCodeCombination.keyCombination((String)"Alt+2");
    public static final KeyCombination ALT_3 = KeyCodeCombination.keyCombination((String)"Alt+3");
    public static final KeyCombination ALT_4 = KeyCodeCombination.keyCombination((String)"Alt+4");
    public static final KeyCombination ALT_5 = KeyCodeCombination.keyCombination((String)"Alt+5");
    public static final KeyCombination ALT_6 = KeyCodeCombination.keyCombination((String)"Alt+6");
    public static final KeyCombination ALT_7 = KeyCodeCombination.keyCombination((String)"Alt+7");
    public static final KeyCombination ALT_8 = KeyCodeCombination.keyCombination((String)"Alt+8");
    public static final KeyCombination ALT_9 = KeyCodeCombination.keyCombination((String)"Alt+9");
    public static final KeyCombination ALT_0 = KeyCodeCombination.keyCombination((String)"Alt+0");
    public static final KeyCombination ENTER = KeyCodeCombination.keyCombination((String)"Enter");
    public static final KeyCombination ALT_F2 = KeyCodeCombination.keyCombination((String)"Alt+f2");
    private List<POSPaymentMethod> paymentMethods;
    private BigDecimal value;
    private Map<POSPaymentMethod, List<PaymentInfo>> payments = new HashMap<POSPaymentMethod, List<PaymentInfo>>();
    private POSCustomer customer;
    private Stage stage;
    private ScrollPane scrollPane = new ScrollPane();
    private GridPane grid = new GridPane();
    private NamaTextField remainingAmount = new NamaTextField();
    private NamaLabel remainingLabel;
    private NamaCheckBox printFullInvoice = new NamaCheckBox("printFullInvoiceWithPayment");
    private NamaCheckBox delayPayment = new NamaCheckBox("delayPayment");
    private NamaCheckBox shouldNotPrintAfterPaymentCheckBox = new NamaCheckBox("shouldNotPrintAfterPayment");
    private boolean useCreditNotes = ObjectChecker.isTrue((Boolean)POSResourcesUtil.fetchPOSConfig().getUseCreditNotes());
    private boolean useCashWithMultiPay = ObjectChecker.isFalseOrNull((Boolean)POSResourcesUtil.fetchPOSConfig().getHideDefaultSystemCashMethod());
    private NamaTextField invoiceNet = new NamaTextField();
    private NamaPaymentTextField cash = new NamaPaymentTextField();
    private NamaPaymentTextField debit = new NamaPaymentTextField();
    private List<NamaTextField> paymentTextFields = new ArrayList<NamaTextField>();
    private List<PaymentInfo> creditNotesInfo = new ArrayList<PaymentInfo>();
    private List<PaymentInfo> couponsInfo = new ArrayList<PaymentInfo>();
    private boolean useCoupons = ObjectChecker.isTrue((Boolean)POSResourcesUtil.fetchPOSConfig().getUseCoupons());
    private CustomeCreditNotePaymentMethod creditNoteMethod = new CustomeCreditNotePaymentMethod();
    private CustomeCouponPaymentMethod couponMethod = new CustomeCouponPaymentMethod();
    private TextArea remarksField;
    private boolean amountAddedToFirstMethod = false;
    private List<PosPayMethodGroupPane> methodGroupPanes = new ArrayList<PosPayMethodGroupPane>();
    private GridPane gridToAddTo;
    private boolean containsGroupedMethods = false;
    private NamaTextArea paymentsSummary;
    private double dialogWidth;
    private UUID docCategoryId;
    private UUID invoiceClassificationId;
    private AbsPosSalesScreen salesScreen;
    private NamaButton redeemRewardPointsBtn;

    public AbsPosSalesScreen getSalesScreen() {
        return this.salesScreen;
    }

    public Stage getStage() {
        return this.stage;
    }

    public MultiplePaymentDialog(List<POSPaymentMethod> paymentMethods, BigDecimal value, String customerID) {
        super("payment");
        this.getDialogPane().setId("multiple-payment-dialog");
        this.customer = POSPersister.findByID(POSCustomer.class, customerID);
        this.paymentMethods = paymentMethods;
        this.value = NaMaMath.round((BigDecimal)value, (Integer)POSMoneyUtils.displayDecimalPlaces);
        if (ObjectChecker.isNotEmptyOrNull(POSResourcesUtil.pgwMethods)) {
            for (POSPaymentMethod method : POSResourcesUtil.pgwMethods) {
                if (this.paymentMethods.contains(method)) continue;
                this.paymentMethods.add(method);
            }
        }
        POSSettingsUtil.addStyleSheetFor("css/allfiles.css", (Parent)this.getDialogPane());
    }

    private POSPaymentMethod getDefaultPaymentMethod() {
        List defaultMethods = CollectionsUtility.filter(POSResourcesUtil.methods, object -> ObjectChecker.isTrue((Boolean)object.getDefaultMethod()));
        if (ObjectChecker.isNotEmptyOrNull((Object)defaultMethods)) {
            return (POSPaymentMethod)defaultMethods.get(0);
        }
        return null;
    }

    public void draw(AbsPOSSales salesDoc, boolean shouldPrintAfterPayment, AbsPosSalesScreen screen) {
        Stage stage = screen.stage;
        this.salesScreen = screen;
        if (salesDoc.getDocCategory() != null) {
            this.docCategoryId = salesDoc.getDocCategory().getId();
        }
        if (salesDoc.getPosInvoiceClassification() != null) {
            this.invoiceClassificationId = salesDoc.getPosInvoiceClassification().getId();
        }
        if (PaymentDialogHelper.serviceItemMustBeReCalculated(salesDoc, screen, false)) {
            return;
        }
        if (PaymentDialogHelper.checkAndShowOfferDialog(this, salesDoc, screen)) {
            return;
        }
        if (PaymentDialogHelper.checkAndShowFreeItemsOnInvoiceDialog(this, salesDoc, screen)) {
            return;
        }
        AbsPosSalesScreen.setActivatedDialog(this);
        DisplayPoleConnectorUtil.writeTotalMsg(salesDoc);
        POSMediaUtil.playPaymentSound();
        this.stage = stage;
        Rectangle2D primScreenBounds = Screen.getPrimary().getVisualBounds();
        this.setResizable(true);
        if (ObjectChecker.isTrue((Boolean)POSUISettingsUtil.getPosUISettingsOptions().getFullScreenPaymentDialogs())) {
            this.setHeight(primScreenBounds.getHeight());
            this.dialogWidth = primScreenBounds.getWidth();
            ((Stage)this.getDialogPane().getScene().getWindow()).setFullScreen(true);
            this.setWidth(this.dialogWidth);
        } else {
            this.dialogWidth = stage.getWidth() / 1.03;
            this.getDialogPane().setPrefWidth(this.dialogWidth);
            this.getDialogPane().setMaxHeight(stage.getHeight() / 1.03);
        }
        this.setOnCloseRequest(e -> this.hideDialog(screen));
        this.remainingAmount.setEditable(false);
        this.remainingLabel = new NamaLabel("remaining", false);
        this.cash.textProperty().addListener(AbsPosSalesScreen.preventNegativeSignAndChars(this.cash));
        this.debit.textProperty().addListener(AbsPosSalesScreen.preventNegativeSignAndChars(this.debit));
        ColumnConstraints labelConstraint = new ColumnConstraints();
        labelConstraint.setPercentWidth(15.0);
        ColumnConstraints fieldConstraint = new ColumnConstraints();
        fieldConstraint.setPercentWidth(20.0);
        ColumnConstraints btnsConstraint = new ColumnConstraints();
        btnsConstraint.setPercentWidth(4.0);
        this.grid.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{labelConstraint, fieldConstraint, labelConstraint, fieldConstraint, btnsConstraint, btnsConstraint, btnsConstraint, btnsConstraint});
        this.grid.setId("multiple-payment-dialog-payment-method-pane");
        this.addStaticPaymentMethodsLayouts(this.debit);
        this.addPaymentMethodsLayout(salesDoc);
        if (!this.amountAddedToFirstMethod && ObjectChecker.isFalseOrNull((Boolean)POSResourcesUtil.fetchPOSConfig().getDoNotAddAmountToAnyPaymentMethod())) {
            POSPaymentMethod defaultPaymentMethod = this.getDefaultPaymentMethod();
            NamaTextField amountField = (NamaTextField)ObjectChecker.getFirstNotNullObj((Object[])new NamaTextField[]{defaultPaymentMethod != null ? this.findPaymentMethodTextField(defaultPaymentMethod) : null, this.findCashMethodTextField()});
            amountField.setText(this.value.toString());
        }
        if (ObjectChecker.isTrue((Boolean)POSResourcesUtil.fetchPOSConfig().getDoNotAddAmountToAnyPaymentMethod())) {
            this.updateRemainingField();
        }
        if (this.shouldColorTextRed(salesDoc)) {
            BigDecimal returnNet = salesDoc.calcReturnNet().abs();
            BigDecimal invoiceNet = salesDoc.calcInvNet();
            this.findCashMethodTextField().setText(NaMaMath.round((BigDecimal)invoiceNet.subtract(returnNet).abs(), (Integer)POSMoneyUtils.displayDecimalPlaces).toString());
            if (returnNet.compareTo(invoiceNet) > 0) {
                for (Node child : this.grid.getChildren()) {
                    if (!(child instanceof NamaTextField)) continue;
                    child.setStyle("-fx-text-inner-color: red;");
                }
            }
        }
        NamaButton additionalMethods = this.keyboardBtn();
        additionalMethods.setTooltip(new POSTooltip("showAdditionalMethods"));
        additionalMethods.setSVGIcon("additionalMethods.svg");
        additionalMethods.setOnAction(event -> new AdditionalPaymentMethodsDialog(this, POSResourcesUtil.methods.stream().filter(POSPaymentMethod::showInAdditionalMethods).collect(Collectors.toList())).showDialog());
        this.scrollPane.setFitToWidth(true);
        this.scrollPane.setId("multiple-payment-dialog-scroll-pane");
        this.scrollPane.setContent((Node)this.grid);
        NamaHBox boardAndPgw = new NamaHBox(new Node[]{this.keyboardBtn()});
        boardAndPgw.setSpacing(5.0);
        if (this.paymentMethods.stream().filter(POSPaymentMethod::showInAdditionalMethods).count() > 0L) {
            boardAndPgw.getChildren().add((Object)additionalMethods);
        }
        NamaVBox leftPart = new NamaVBox(new Node[]{new PosKeyPad(stage).drawItemCodeKeys(), boardAndPgw});
        leftPart.setId("multiple-payment-dialog-left-pane");
        GridPane.setHgrow((Node)leftPart, (Priority)Priority.ALWAYS);
        GridPane dialogContainer = new GridPane();
        ColumnConstraints col1Const = new ColumnConstraints();
        col1Const.setPercentWidth(88.0);
        ColumnConstraints col2Const = new ColumnConstraints();
        col2Const.setPercentWidth(12.0);
        dialogContainer.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{col1Const, col2Const});
        dialogContainer.add((Node)new NamaVBox(new Node[]{this.scrollPane, this.createFooterPane(shouldPrintAfterPayment)}), 0, 0);
        dialogContainer.add((Node)leftPart, 1, 0);
        NamaHBox.setHgrow((Node)dialogContainer, (Priority)Priority.ALWAYS);
        this.content((Node)dialogContainer);
        this.addOkButton("");
        this.addCancelButton("");
        this.addScrollPane();
        this.expandGroupForCashMethodIfExist();
        this.getDialogPane().setOnKeyReleased(event -> {
            if (ALT_ENTER.match(event)) {
                this.processAction(salesDoc);
            } else if (ObjectChecker.isNotEmptyOrNull((Object)PosShortcutsUtil.payUsingRewardPoints) && PosShortcutsUtil.payUsingRewardPoints.match(event)) {
                if (this.redeemRewardPointsBtn != null) {
                    this.redeemRewardPointsBtn.fire();
                }
            } else if (PosShortcutsUtil.invoicePayShortcuts.match(event)) {
                this.processAction(salesDoc);
            } else if (ALT_1.match(event)) {
                this.loadRemainingToMethod(0);
            } else if (ALT_2.match(event)) {
                this.loadRemainingToMethod(1);
            } else if (ALT_3.match(event)) {
                this.loadRemainingToMethod(2);
            } else if (ALT_4.match(event)) {
                this.loadRemainingToMethod(3);
            } else if (ALT_5.match(event)) {
                this.loadRemainingToMethod(4);
            } else if (ALT_6.match(event)) {
                this.loadRemainingToMethod(5);
            } else if (ALT_7.match(event)) {
                this.loadRemainingToMethod(6);
            } else if (ALT_8.match(event)) {
                this.loadRemainingToMethod(7);
            } else if (ALT_9.match(event)) {
                this.loadRemainingToMethod(8);
            } else if (ALT_0.match(event)) {
                this.loadRemainingToMethod(9);
            } else if (ALT_F2.match(event)) {
                if (!(event.getTarget() instanceof NamaPaymentTextField)) {
                    return;
                }
                NamaPaymentTextField paymentTextField = (NamaPaymentTextField)event.getTarget();
                paymentTextField.getRelatedTerminalBtn().fire();
            }
        });
        this.setOkAction(e -> this.processAction(salesDoc));
        this.show();
    }

    private NamaVBox createFooterPane(boolean shouldPrintAfterPayment) {
        this.remarksField = new NamaTextArea(null, null);
        this.remarksField.setWrapText(true);
        this.remarksField.setPrefRowCount(1);
        NamaVBox footerPane = new NamaVBox(new Node[]{new NamaHBox(new Node[]{this.remainingLabel, this.remainingAmount}), new NamaHBox(new Node[]{new NamaLabel("remarks", false), this.remarksField})});
        footerPane.setId("multiple-payment-footer-pane");
        this.shouldNotPrintAfterPaymentCheckBox.setSelected(!shouldPrintAfterPayment);
        this.shouldNotPrintAfterPaymentCheckBox.setOnAction(e -> {
            POSResult result = POSSecurityUtil.checkIfHasCapability(POSSecurityCapability.CanPreventPrintingInvoices);
            if (result.isFailed().booleanValue()) {
                this.error(result.getMessageByLanguage());
                this.shouldNotPrintAfterPaymentCheckBox.setSelected(false);
            }
        });
        NamaHBox optionsBox = new NamaHBox(new Node[]{this.shouldNotPrintAfterPaymentCheckBox});
        this.printFullInvoice.setOnAction(e -> {
            POSResult result = POSSecurityUtil.checkIfHasCapability(POSSecurityCapability.CanPrintFullInvoice);
            if (result.isFailed().booleanValue()) {
                this.error(result.getMessageByLanguage());
                this.printFullInvoice.setSelected(false);
            }
        });
        this.printFullInvoice.setSelected(ObjectChecker.isTrue((Boolean)POSResourcesUtil.fetchMainRegister().getAlwaysPrintFullInvoice()));
        optionsBox.getChildren().add((Object)this.printFullInvoice);
        if (POSSecurityUtil.userCan(POSSecurityCapability.CanDelayInvoicePayment).isSucceeded().booleanValue()) {
            this.delayPayment.setOnAction(event -> {
                if (this.delayPayment.isSelected()) {
                    this.remainingAmount.setText(BigDecimal.ZERO.toString());
                    for (NamaTextField field : this.paymentTextFields) {
                        field.setText(BigDecimal.ZERO.toString());
                    }
                }
            });
            optionsBox.getChildren().add((Object)this.delayPayment);
        }
        footerPane.getChildren().add((Object)optionsBox);
        optionsBox.setId("multiple-payment-dialog-options-pane");
        if (this.containsGroupedMethods) {
            this.paymentsSummary = new NamaTextArea(null, null);
            this.paymentsSummary.setId("paymentsSummary");
            this.paymentsSummary.setEditable(false);
            footerPane.getChildren().add((Object)this.paymentsSummary);
        }
        return footerPane;
    }

    public void processAction(AbsPOSSales salesDoc) {
        if (ObjectChecker.isNotEmptyOrNull((Object)this.debit.getText()) && ObjectChecker.isEmptyOrNull((Object)this.customer)) {
            MultiplePaymentDialog.handleFailure(this, null, null, "customerRequired", new Object[0]);
        } else {
            PayRequest request = this.createPayRequest(salesDoc, this.salesScreen);
            POSResult result = MultiplePaymentDialog.process(request, this);
            if (result.isFailed().booleanValue()) {
                this.error(result.getMessageByLanguage());
            }
        }
    }

    private PayRequest createPayRequest(AbsPOSSales salesDoc, AbsPosSalesScreen screen) {
        PayRequest request = new PayRequest();
        request.setCashValue(this.calcCashVal());
        request.setPayments(this.payments);
        request.setCouponsInfo(this.couponsInfo);
        request.setCouponMethodName(this.couponMethod.methodName());
        request.setRemarks(this.remarksField.getText());
        request.setScreen(screen);
        request.setDelayPayment(this.delayPayment.isSelected());
        request.setDebitAmount(MultiplePaymentDialog.toZeroIfNullOrEmpty(this.debit.getText()));
        request.setSalesDoc(salesDoc);
        request.setCreditNoteMethodName(this.creditNoteMethod.methodName());
        request.setCreditNotesInfo(this.creditNotesInfo);
        request.setDefaultCashAmount(MultiplePaymentDialog.toZeroIfNullOrEmpty(this.cash.getText()));
        request.setValue(this.value);
        request.setDocType(screen.documentType());
        request.setShouldPrintAfterPayment(!this.shouldNotPrintAfterPaymentCheckBox.isSelected());
        request.setPrintFullInvoice(this.printFullInvoice.isSelected());
        request.setRemainingAmount(MultiplePaymentDialog.toZeroIfNullOrEmpty(this.remainingAmount.getText()));
        request.setRegister(POSResourcesUtil.fetchMainRegister());
        return request;
    }

    public static BigDecimal toZeroIfNullOrEmpty(String val) {
        return ObjectChecker.isEmptyOrNull((Object)val) ? BigDecimal.ZERO : new BigDecimal(val);
    }

    private boolean shouldColorTextRed(AbsPOSSales doc) {
        if (doc instanceof POSSalesReplacement) {
            return true;
        }
        return doc instanceof POSSalesReturn;
    }

    private NamaButton keyboardBtn() {
        NamaButton keyBoard = new NamaButton();
        keyBoard.setTooltip(new POSTooltip("keyBoard"));
        keyBoard.setSVGIcon("keyBoardIcon.svg");
        keyBoard.setOnAction(event -> {
            try {
                Runtime.getRuntime().exec("cmd /c C:\\Windows\\System32\\osk.exe");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
        return keyBoard;
    }

    private void expandGroupForCashMethodIfExist() {
        if (ObjectChecker.isEmptyOrNull(this.methodGroupPanes)) {
            return;
        }
        POSPaymentMethod posPaymentMethod = MultiplePaymentDialog.searchForCashMethod();
        if (ObjectChecker.isEmptyOrNull((Object)posPaymentMethod) || ObjectChecker.isEmptyOrNull((Object)posPaymentMethod.getMasterGroupId())) {
            return;
        }
        this.methodGroupPanes.stream().filter(m -> ObjectChecker.areEqual((Object)m.getGroupId(), (Object)posPaymentMethod.getMasterGroupId())).findFirst().ifPresent(p -> p.setExpanded(true));
    }

    private void addStaticPaymentMethodsLayouts(NamaTextField debit) {
        NamaLabel invoiceValueNamaLabel = new NamaLabel("invoiceValue", false);
        POSResourcesUtil.alignLabels(new Node[]{invoiceValueNamaLabel});
        this.invoiceNet.setPromptText("$");
        this.invoiceNet.setText(this.value.toString());
        this.invoiceNet.setEditable(false);
        this.grid.add((Node)invoiceValueNamaLabel, 0, 0);
        this.grid.add((Node)this.invoiceNet, 1, 0);
        if (this.useCashWithMultiPay && MultiplePaymentDialog.searchForCashMethod() == null) {
            this.grid.add((Node)new NamaLabel("cash", false), 0, 1);
            this.grid.add((Node)this.cash, 1, 1);
            this.paymentTextFields.add(this.cash);
        }
        if (ObjectChecker.isNotEmptyOrNull((Object)this.customer) && !POSSecurityUtil.userCan(POSSecurityCapability.CanPayWithCreditVal).isFailed().booleanValue()) {
            this.grid.add((Node)new NamaLabel("debitValue", false), 0, 2);
            this.grid.add((Node)debit, 1, 2);
            this.paymentTextFields.add(debit);
        }
        this.cash.setPromptText(MultiplePaymentDialog.searchForCashMethodName());
        this.cash.textProperty().addListener((observable, oldValue, newValue) -> this.amountAction(this.cash));
        debit.setPromptText("debitValue");
        debit.textProperty().addListener(e -> this.amountAction(debit));
    }

    private NamaTextField findCashMethodTextField() {
        POSPaymentMethod method = MultiplePaymentDialog.searchForCashMethod();
        if (method != null) {
            return this.findPaymentMethodTextField(method);
        }
        return this.cash;
    }

    private NamaTextField findPaymentMethodTextField(POSPaymentMethod method) {
        for (Node node : this.grid.getChildren()) {
            if (!(node instanceof NamaTextField) || !((NamaTextField)node).getPromptText().equalsIgnoreCase(method.nameByLanguage())) continue;
            return (NamaTextField)node;
        }
        return this.cash;
    }

    private static void validateCouponMethod(DTOPaymentMethodInfo dtoPaymentMethodInfo, POSResult result) {
        ResultDTO resultDto = (ResultDTO)POSWSClient.instance.validateCoupon((SendRequest<DTOPaymentMethodInfo>)new SendRequest((Object)dtoPaymentMethodInfo)).getData();
        if (resultDto.isFailed()) {
            result.failure(POSResourcesUtil.isArabic() ? resultDto.getArabicMessage() : resultDto.getEnglishMessage(), new Object[0]);
        }
    }

    private static void validateCreditNoteMethod(DTOPaymentMethodInfo dtoPaymentMethodInfo, POSResult result) {
        String creditNoteCode = dtoPaymentMethodInfo.getProcessNumber();
        POSCreditNote creditNote = (POSCreditNote)POSPersister.findByCode(POSCreditNote.class, creditNoteCode);
        if (creditNote.getDeactivated().booleanValue()) {
            result.failure("Credit note is paid {0}", dtoPaymentMethodInfo.getProcessNumber());
            return;
        }
        ResultDTO resultDto = (ResultDTO)POSWSClient.instance.validateCreditNote((SendRequest<DTOPaymentMethodInfo>)new SendRequest((Object)dtoPaymentMethodInfo)).getData();
        if (resultDto.isFailed()) {
            result.failure(POSResourcesUtil.isArabic() ? resultDto.getArabicMessage() : resultDto.getEnglishMessage(), new Object[0]);
        }
    }

    private static boolean needCheck(AbsPOSSales salesDoc) {
        return !(salesDoc instanceof POSSalesReturn);
    }

    private void addPaymentMethodsLayout(AbsPOSSales salesDoc) {
        this.sortPaymentMethods();
        int gridIndex = POSGridUtil.getRowCount(this.grid);
        int methodIndex = 0;
        while (methodIndex < this.paymentMethods.size()) {
            POSPaymentMethod paymentMethod = this.paymentMethods.get(methodIndex);
            if (!paymentMethod.mustNotBeAddedToPayDialog(this.docCategoryId, this.invoiceClassificationId)) {
                new PredefinedPaymentMethod(paymentMethod).addToGrid(gridIndex, methodIndex, salesDoc);
            }
            ++methodIndex;
            ++gridIndex;
        }
        if ((salesDoc instanceof POSSalesReturn || ObjectChecker.isFalseOrNull((Boolean)POSResourcesUtil.fetchPOSConfig().getMoveAmountToFirstPaymentMethod())) && this.useCashWithMultiPay) {
            this.findCashMethodTextField().setText(this.value.toString());
        }
        this.creditNoteMethod.addToGrid(gridIndex, methodIndex, salesDoc);
        this.couponMethod.addToGrid(gridIndex + 1, methodIndex + 1, salesDoc);
    }

    private void addMethodPartToGrid(int newIndex, int methodIndex, Boolean duplicatedMethod, ICustomPaymentMethod customePaymentMethod, AbsPOSSales salesDoc, boolean paidFromTerminal, DTOPGWProperties properties) {
        NamaPaymentTextField amountField = new NamaPaymentTextField();
        NamaTextField processNumberField = new NamaTextField(POSFieldType.Text);
        this.addMethodPartToGrid(amountField, processNumberField, newIndex, methodIndex, duplicatedMethod, customePaymentMethod, salesDoc, paidFromTerminal, properties);
    }

    private void addMethodPartToGrid(NamaPaymentTextField amountField, NamaTextField processNumberField, int gridIndex, int methodIndex, Boolean duplicatedMethod, ICustomPaymentMethod customePaymentMethod, AbsPOSSales salesDoc, boolean paidFromTerminal, DTOPGWProperties properties) {
        boolean returnWithCreditNote;
        boolean moveAmountToFirstPaymentMethod;
        if (salesDoc != null && !customePaymentMethod.allowedForType(salesDoc, salesDoc.calcNamaEntityType())) {
            return;
        }
        this.paymentTextFields.add(amountField);
        this.gridToAddTo = this.grid;
        boolean groupByMasterGroup = this.methodMustBeGrouped(customePaymentMethod);
        if (groupByMasterGroup) {
            this.gridToAddTo = this.fetchMethodGroupPaneOrCreateIt(gridIndex, customePaymentMethod);
        }
        String methodName = customePaymentMethod.methodName();
        amountField.setId(methodName + "_#_" + gridIndex);
        amountField.setTitle("amountField");
        processNumberField.setId(methodName + "_#_" + gridIndex);
        processNumberField.setTitle(methodName + "_#_authCodeField");
        amountField.setPromptText(methodName);
        processNumberField.setPromptText(methodName);
        amountField.setRelatedAuthCodeField(processNumberField);
        NamaLabel label = new NamaLabel((String)ObjectChecker.getFirstNotEmptyObj((Object[])new String[]{customePaymentMethod.valueFieldTitle(), methodName}), false);
        String defProcessNumberTitle = POSResourcesUtil.id("processNumber", new Object[0]);
        NamaLabel processNamaLabel = new NamaLabel((String)ObjectChecker.getFirstNotEmptyObj((Object[])new String[]{customePaymentMethod.processNumberFieldTitle(), defProcessNumberTitle}), false);
        boolean bl = moveAmountToFirstPaymentMethod = ObjectChecker.isFalseOrNull((Boolean)POSResourcesUtil.fetchPOSConfig().getDoNotAddAmountToAnyPaymentMethod()) && ObjectChecker.isTrue((Boolean)POSResourcesUtil.fetchPOSConfig().getMoveAmountToFirstPaymentMethod());
        if (methodIndex == 0 && moveAmountToFirstPaymentMethod) {
            this.amountAddedToFirstMethod = true;
            amountField.setText(this.value.toString());
            Platform.runLater(() -> amountField.requestFocus());
        }
        processNumberField.focusedProperty().addListener((observable, oldValue, newValue) -> customePaymentMethod.processNumAction(processNumberField, amountField, salesDoc));
        processNumberField.textProperty().addListener((observable, oldValue, newValue) -> customePaymentMethod.processNumAction(processNumberField, amountField, salesDoc));
        NamaButton addMethodBtn = new NamaButton();
        addMethodBtn.setTooltip(new POSTooltip("add"));
        addMethodBtn.setSVGIcon("Add.svg");
        addMethodBtn.setOnAction(action -> this.addMethodBtnAction(methodIndex, customePaymentMethod, salesDoc, false, new DTOPGWProperties()));
        addMethodBtn.setOnKeyPressed(event -> this.focusOnNextLineIfLastElement((KeyEvent)event));
        int colIndex = 0;
        this.gridToAddTo.add((Node)label, colIndex++, gridIndex + 1);
        this.gridToAddTo.add((Node)amountField, colIndex++, gridIndex + 1);
        boolean bl2 = returnWithCreditNote = salesDoc instanceof POSSalesReturn && customePaymentMethod.isNOTPredefinedMethod();
        if (!returnWithCreditNote) {
            this.gridToAddTo.add((Node)processNamaLabel, colIndex++, gridIndex + 1);
            this.gridToAddTo.add((Node)processNumberField, colIndex++, gridIndex + 1);
            POSResourcesUtil.alignLabels(new Node[]{processNamaLabel});
            if (ObjectChecker.isFalseOrNull((Boolean)customePaymentMethod.isCashMethod())) {
                this.gridToAddTo.add((Node)addMethodBtn, colIndex++, gridIndex + 1);
            }
        }
        if (duplicatedMethod.booleanValue()) {
            NamaButton removeMethodBtn = new NamaButton();
            removeMethodBtn.setTooltip(new POSTooltip("remove"));
            removeMethodBtn.setSVGIcon("remove.svg");
            removeMethodBtn.setOnAction(action -> {
                Integer rowIndex = GridPane.getRowIndex((Node)removeMethodBtn);
                this.deleteRowFromGrid(this.gridToAddTo, rowIndex);
                this.updateRemainingField();
            });
            removeMethodBtn.setOnKeyPressed(event -> this.focusOnNextLineIfLastElement((KeyEvent)event));
            this.gridToAddTo.add((Node)removeMethodBtn, colIndex++, gridIndex + 1);
        }
        if (customePaymentMethod.isCriticalMethod() && POSSecurityUtil.userCan(POSSecurityCapability.CanUseCriticalMethods).isFailed().booleanValue()) {
            NamaButton unLockBtn = new NamaButton();
            this.lockFields(amountField, processNumberField, unLockBtn);
            unLockBtn.setOnAction(action -> {
                boolean unLock = ObjectChecker.areEqual((Object)((Button)action.getTarget()).getTooltip().getText(), (Object)POSResourcesUtil.id("unLock", new Object[0]));
                if (unLock && POSSecurityUtil.checkIfHasCapability(POSSecurityCapability.CanUseCriticalMethods).isSucceeded().booleanValue()) {
                    amountField.setEditable(true);
                    processNumberField.setEditable(true);
                    unLockBtn.setSVGIcon("lock.svg");
                    unLockBtn.setTooltip(new POSTooltip("lock"));
                } else if (!unLock) {
                    this.lockFields(amountField, processNumberField, unLockBtn);
                }
            });
            unLockBtn.setOnKeyPressed(event -> this.focusOnNextLineIfLastElement((KeyEvent)event));
            this.gridToAddTo.add((Node)unLockBtn, colIndex++, gridIndex + 1);
        }
        NamaButton loadRemaining = new NamaButton();
        loadRemaining.setTooltip(new POSTooltip("loadRemainingToMethod"));
        loadRemaining.setSVGIcon("moneyLoad.svg");
        loadRemaining.setOnAction(action -> {
            int currentIndex = this.gridToAddTo.getChildren().stream().filter(c -> c instanceof Button && ObjectChecker.areEqual((Object)((Button)c).getTooltip().getText(), (Object)loadRemaining.getTooltip().getText())).collect(Collectors.toList()).indexOf(loadRemaining);
            this.loadRemainingToMethod(currentIndex);
        });
        loadRemaining.setOnKeyPressed(event -> this.focusOnNextLineIfLastElement((KeyEvent)event));
        this.gridToAddTo.add((Node)loadRemaining, colIndex++, gridIndex + 1);
        if (ObjectChecker.isNotEmptyOrNull(POSResourcesUtil.pgwMethods) && POSResourcesUtil.pgwMethods.contains(customePaymentMethod.getMethod())) {
            NamaButton sendAmountToTerminal = new NamaButton();
            sendAmountToTerminal.setTooltip(new POSTooltip(POSResourcesUtil.id("sendAmountToTerminal", new Object[0]) + " (Alt+F2)"));
            sendAmountToTerminal.setSVGIcon("pgw.svg");
            sendAmountToTerminal.setOnAction(event -> {
                BigDecimal amountToTerminal = MultiplePaymentDialog.toZeroIfNullOrEmpty(amountField.getText());
                this.sendAmountToTerminal(amountToTerminal, salesDoc, POSResourcesUtil.methods.get(methodIndex), amountField);
            });
            amountField.setRelatedTerminalBtn(sendAmountToTerminal);
            this.gridToAddTo.add((Node)sendAmountToTerminal, colIndex++, gridIndex + 1);
        }
        Boolean canNotModifyCreditNoteValue = POSSecurityUtil.userCan(POSSecurityCapability.CanNotModifyCreditNoteValueInPayment).isSucceeded();
        if (customePaymentMethod instanceof CustomeCreditNotePaymentMethod && canNotModifyCreditNoteValue.booleanValue()) {
            amountField.setEditable(false);
            NamaButton enableCreditNoteAmountField = new NamaButton();
            enableCreditNoteAmountField.setTooltip(new POSTooltip(POSResourcesUtil.id("enableCreditNoteAmountField", new Object[0]) + " (Alt+F2)"));
            enableCreditNoteAmountField.setSVGIcon("brush.svg");
            enableCreditNoteAmountField.setOnAction(event -> {
                POSResult result = POSSecurityUtil.checkIfNotHavePreventCapability(null, salesDoc, POSSecurityCapability.CanNotModifyCreditNoteValueInPayment);
                Boolean enableEdit = result.isSucceeded();
                if (!enableEdit.booleanValue()) {
                    this.error(result.getMessageByLanguage());
                } else {
                    this.removeErrors();
                }
                amountField.setEditable(enableEdit);
            });
            this.gridToAddTo.add((Node)enableCreditNoteAmountField, colIndex++, gridIndex + 1);
        }
        PaymentInfo info = new PaymentInfo(ObjectChecker.isEmptyOrNull((Object)amountField.getText()) ? BigDecimal.ZERO : new BigDecimal(amountField.getText()), processNumberField.getText(), gridIndex);
        info.setPaidFromTerminal(paidFromTerminal);
        info.setPgwProperties(properties);
        if (customePaymentMethod instanceof CustomeCouponPaymentMethod) {
            this.gridToAddTo.add((Node)this.addRedeemRewardPointsBtn(salesDoc, processNumberField, info), colIndex++, gridIndex + 1);
        }
        customePaymentMethod.addPaymentInfo(methodIndex, info);
        amountField.textProperty().addListener(AbsPosSalesScreen.preventNegativeSignAndChars(amountField));
        amountField.textProperty().addListener(e -> this.amountAction(amountField));
        processNumberField.textProperty().addListener(e -> this.processNumberAction(processNumberField));
    }

    private Button addRedeemRewardPointsBtn(AbsPOSSales doc, NamaTextField processNumberField, PaymentInfo info) {
        this.redeemRewardPointsBtn = new NamaButton();
        this.redeemRewardPointsBtn.setTooltip(new POSTooltip("redeemRewardPoints"));
        this.redeemRewardPointsBtn.setSVGIcon("loyalty-points.svg");
        POSResult result = new POSResult();
        RewardPointsDialog rewardPointsDialog = new RewardPointsDialog();
        rewardPointsDialog.fromDialog(this);
        rewardPointsDialog.addScrollPane();
        this.redeemRewardPointsBtn.setOnAction(action -> {
            rewardPointsDialog.showDialog(doc, processNumberField, info, result);
            if (result.isFailed().booleanValue()) {
                this.error(result.getMessageByLanguage());
            }
        });
        this.redeemRewardPointsBtn.setOnKeyPressed(this::focusOnNextLineIfLastElement);
        return this.redeemRewardPointsBtn;
    }

    private void loadRemainingToMethod(int index) {
        List amountFields = this.gridToAddTo.getChildren().stream().filter(c -> c instanceof NamaTextField && ObjectChecker.areEqual((Object)((NamaTextField)c).getTitle(), (Object)"amountField")).collect(Collectors.toList());
        if (index >= amountFields.size()) {
            return;
        }
        amountFields.stream().forEach(field -> ((TextField)field).setText(""));
        TextField amountText = (TextField)amountFields.get(index);
        BigDecimal net = ObjectChecker.toBigDecimalIfNumber((Object)this.invoiceNet.getText());
        amountText.setText(net.toString());
    }

    public void addMethodBtnAction(POSPaymentMethod paymentMethod) {
        this.addMethodBtnAction(this.paymentMethods.lastIndexOf(paymentMethod), new PredefinedPaymentMethod(paymentMethod), null, false, null, false);
    }

    private void addMethodBtnAction(int methodIndex, ICustomPaymentMethod customePaymentMethod, AbsPOSSales salesDoc, boolean paidFromTerminal, DTOPGWProperties dtopgwProperties, boolean duplicateMethod) {
        int maxIndex = this.gridToAddTo.getChildren().stream().mapToInt(n -> {
            Integer row = GridPane.getRowIndex((Node)n);
            Integer rowSpan = GridPane.getRowSpan((Node)n);
            return (row == null ? 0 : row) + (rowSpan == null ? 0 : rowSpan - 1);
        }).max().orElse(-1);
        this.addMethodPartToGrid(maxIndex, methodIndex, duplicateMethod, customePaymentMethod, salesDoc, paidFromTerminal, dtopgwProperties);
    }

    private void addMethodBtnAction(int methodIndex, ICustomPaymentMethod customePaymentMethod, AbsPOSSales salesDoc, boolean paidFromTerminal, DTOPGWProperties dtopgwProperties) {
        this.addMethodBtnAction(methodIndex, customePaymentMethod, salesDoc, paidFromTerminal, dtopgwProperties, true);
    }

    private void lockFields(NamaTextField amountField, NamaTextField processNumberField, NamaButton unLockBtn) {
        amountField.setEditable(false);
        processNumberField.setEditable(false);
        unLockBtn.setTooltip(new POSTooltip("unLock"));
        unLockBtn.setGraphic((Node)POSImgUtil.createSVGImageView("unlock.svg"));
    }

    private void focusOnNextLineIfLastElement(KeyEvent event) {
        if (!event.getCode().equals((Object)KeyCode.ENTER)) {
            return;
        }
        Node btn = (Node)event.getTarget();
        boolean isLastBtnOnLine = true;
        Integer btnRowIndex = GridPane.getRowIndex((Node)btn);
        Integer btnColIndex = GridPane.getColumnIndex((Node)btn);
        for (Node child : this.gridToAddTo.getChildren()) {
            Integer rowIndex = GridPane.getRowIndex((Node)child);
            Integer colIndex = GridPane.getColumnIndex((Node)child);
            int r = rowIndex == null ? 0 : rowIndex;
            if (r != btnRowIndex || !(child instanceof Button) || colIndex <= btnColIndex) continue;
            child.requestFocus();
            isLastBtnOnLine = false;
        }
        if (isLastBtnOnLine) {
            POSGridUtil.focusNextRowFirstNode(btnRowIndex + 1, this.gridToAddTo, (Control)this.remarksField);
        }
    }

    private GridPane fetchMethodGroupPaneOrCreateIt(int gridIndex, ICustomPaymentMethod customPaymentMethod) {
        if (!(customPaymentMethod instanceof PredefinedPaymentMethod)) {
            return this.grid;
        }
        POSPaymentMethod method = ((PredefinedPaymentMethod)customPaymentMethod).getMethod();
        if (ObjectChecker.isEmptyOrNull((Object)method.getMasterGroupId())) {
            return this.grid;
        }
        PosPayMethodGroupPane posPayMethodGroupPane = this.methodGroupPanes.stream().filter(p -> ObjectChecker.areEqual((Object)p.getGroupId(), (Object)method.getMasterGroupId())).findFirst().orElse(null);
        if (ObjectChecker.isEmptyOrNull((Object)((Object)posPayMethodGroupPane))) {
            posPayMethodGroupPane = new PosPayMethodGroupPane(method);
            Pane connectivityArrow = (Pane)posPayMethodGroupPane.lookup(".arrow");
            if (connectivityArrow != null) {
                connectivityArrow.translateXProperty().bind((ObservableValue)this.widthProperty().subtract((ObservableNumberValue)connectivityArrow.widthProperty().multiply(2)));
            }
            this.methodGroupPanes.add(posPayMethodGroupPane);
            this.containsGroupedMethods = true;
            posPayMethodGroupPane.getPaneContent().getColumnConstraints().addAll((Collection)this.grid.getColumnConstraints());
            GridPane.setColumnSpan((Node)posPayMethodGroupPane, (Integer)Integer.MAX_VALUE);
            this.grid.add((Node)posPayMethodGroupPane, 0, gridIndex + 1);
        }
        return posPayMethodGroupPane.getPaneContent();
    }

    private boolean methodMustBeGrouped(ICustomPaymentMethod customPaymentMethod) {
        if (!customPaymentMethod.hasMasterGroup()) {
            return false;
        }
        POSRegistery register = POSResourcesUtil.fetchMainRegister();
        if (ObjectChecker.isEmptyOrNull((Object)register)) {
            return false;
        }
        return ObjectChecker.isTrue((Boolean)register.getCollectPayMethodsByGroup());
    }

    private void couponAction(NamaTextField processNumberField, NamaTextField amountField, AbsPOSSales salesDoc) {
        POSResult result = new POSResult();
        String value = MultiplePaymentDialog.couponAction(processNumberField.getText(), amountField.getText(), this.findTotalPayments(true, false), salesDoc, result);
        if (result.isFailed().booleanValue()) {
            this.error(result.getMessageByLanguage());
        } else {
            amountField.setText(value);
        }
    }

    public static String couponAction(String processNumber, String amount, BigDecimal totalPaid, AbsPOSSales salesDoc, POSResult result) {
        if (ObjectChecker.isEmptyOrNull((Object)processNumber) || ObjectChecker.isNotEmptyOrZero((BigDecimal)MultiplePaymentDialog.toZeroIfNullOrEmpty(amount))) {
            return amount;
        }
        try {
            DTOPOSCalcCouponValueRequest request = new DTOPOSCalcCouponValueRequest(salesDoc.getNetPrice(), salesDoc.getNetPrice().subtract(totalPaid), processNumber);
            request.setRegisterBranchId(ServerStringUtils.toUUIDStr((Object)POSResourcesUtil.fetchRegisterId()));
            BigDecimal couponVal = (BigDecimal)POSWSClient.instance.calcCouponValue((SendRequest<DTOPOSCalcCouponValueRequest>)new SendRequest((Object)request)).getData();
            return NaMaMath.toString((BigDecimal)couponVal, (int)POSMoneyUtils.fractionalDecimalPlaces);
        }
        catch (NaMaServiceExcepption e) {
            result.accumulate(ResultDTO.findLeafFailureResults((ResultDTO)e.getFaultInfo()));
            NaMaLogger.error((Throwable)e);
            return amount;
        }
    }

    private void deleteRowFromGrid(GridPane grid, int row) {
        HashSet<Node> deleteNodes = new HashSet<Node>();
        for (Node child : grid.getChildren()) {
            int r;
            Integer rowIndex = GridPane.getRowIndex((Node)child);
            int n = r = rowIndex == null ? 0 : rowIndex;
            if (r > row) {
                GridPane.setRowIndex((Node)child, (Integer)(r - 1));
                continue;
            }
            if (r != row) continue;
            deleteNodes.add(child);
            if (!(child instanceof NamaTextField)) continue;
            this.findAndRemoveInfoIfFound((NamaTextField)child);
        }
        grid.getChildren().removeAll(deleteNodes);
    }

    private void findAndRemoveInfoIfFound(NamaTextField child) {
        PaymentInfo info = this.fetchPaymentInfo(child);
        if (info == null) {
            return;
        }
        if (this.couponsInfo.contains(info)) {
            this.couponsInfo.remove(info);
        }
        if (this.creditNotesInfo.contains(info)) {
            this.creditNotesInfo.remove(info);
        } else {
            for (Map.Entry<POSPaymentMethod, List<PaymentInfo>> entry : this.payments.entrySet()) {
                List<PaymentInfo> infos = entry.getValue();
                if (!infos.contains(info)) continue;
                infos.remove(info);
            }
        }
    }

    private void processNumberAction(NamaTextField processNumberField) {
        PaymentInfo info = this.fetchPaymentInfo(processNumberField);
        info.setProcessNumber(processNumberField.getText().trim());
    }

    private void creditNoteCodeNumber(NamaTextField processNumberField, NamaTextField amountField, AbsPOSSales salesDoc) {
        if (ObjectChecker.isNotEmptyOrNull((Object)processNumberField.getText()) && ObjectChecker.isEmptyOrNull((Object)amountField.getText())) {
            BigDecimal creditNoteVal = (BigDecimal)POSWSClient.instance.calcCreditNoteValue((SendRequest<String>)new SendRequest((Object)processNumberField.getText())).getData();
            BigDecimal remaining = salesDoc.getNetPrice().subtract(this.findTotalPayments(true, false));
            Boolean overpayByNonCash = POSConfigurationUtil.shouldAllowCustomerToOverpayByNonCash(POSResourcesUtil.fetchMainRegister());
            if (!overpayByNonCash.booleanValue() && creditNoteVal.compareTo(remaining) > 0 && remaining.compareTo(BigDecimal.ZERO) > 0) {
                creditNoteVal = remaining;
            }
            amountField.setText(NaMaMath.toString((BigDecimal)creditNoteVal, (int)POSMoneyUtils.fractionalDecimalPlaces));
        }
    }

    private void amountAction(NamaTextField amountField) {
        this.remainingAmount.clear();
        this.updatePaymentsValues(amountField);
        boolean allowCustomerToOverpayByNonCash = POSConfigurationUtil.shouldAllowCustomerToOverpayByNonCash(POSResourcesUtil.fetchMainRegister());
        boolean currentActionInOnCash = ObjectChecker.areEqual((Object)this.findCashMethodTextField(), (Object)amountField);
        boolean allowNonCashMethodOverpay = !currentActionInOnCash && allowCustomerToOverpayByNonCash;
        this.updateCashField(amountField, allowNonCashMethodOverpay);
        if (!allowNonCashMethodOverpay) {
            this.updateRemainingField();
        }
        if (ObjectChecker.isEmptyOrNull(this.methodGroupPanes)) {
            return;
        }
        Object usedMethods = "";
        for (Map.Entry<POSPaymentMethod, List<PaymentInfo>> entry : this.payments.entrySet()) {
            BigDecimal paidByMethod = SafeBigDecimal.totalize(entry.getValue(), PaymentInfo::getValue);
            if (ObjectChecker.isEmptyOrZero((BigDecimal)paidByMethod)) continue;
            usedMethods = (String)usedMethods + entry.getKey().nameByLanguage() + " : " + String.valueOf(paidByMethod) + " - ";
        }
        if (this.paymentsSummary != null) {
            this.paymentsSummary.setText((String)usedMethods);
        }
    }

    private BigDecimal calcCashVal() {
        return ObjectChecker.isNotEmptyOrNull((Object)this.findCashMethodTextField().getText()) ? new BigDecimal(this.findCashMethodTextField().getText()) : BigDecimal.ZERO;
    }

    private void updateCashField(NamaTextField amountField, boolean allowNegative) {
        boolean currentActionInOnDefault;
        boolean delayedPayment = ObjectChecker.isTrue((Boolean)this.delayPayment.isSelected());
        if (ObjectChecker.isTrue((Boolean)POSResourcesUtil.fetchPOSConfig().getPreventCashAmountAutoUpdate()) || delayedPayment) {
            return;
        }
        POSPaymentMethod defaultPaymentMethod = this.getDefaultPaymentMethod();
        boolean existDefaultPaymentMethod = ObjectChecker.isNotEmptyOrNull((Object)defaultPaymentMethod);
        NamaTextField defaultMethodTextField = existDefaultPaymentMethod ? this.findPaymentMethodTextField(defaultPaymentMethod) : null;
        NamaTextField cashMethodTextField = existDefaultPaymentMethod ? defaultMethodTextField : this.findCashMethodTextField();
        boolean currentActionInOnCash = ObjectChecker.areEqual((Object)cashMethodTextField, (Object)amountField);
        boolean bl = currentActionInOnDefault = existDefaultPaymentMethod ? ObjectChecker.areEqual((Object)defaultMethodTextField, (Object)amountField) : false;
        if (currentActionInOnDefault || currentActionInOnCash && defaultPaymentMethod == null) {
            return;
        }
        BigDecimal nonCashTotal = this.findTotalPayments(!existDefaultPaymentMethod, false, existDefaultPaymentMethod);
        BigDecimal cashVal = this.value.subtract(nonCashTotal);
        if (ObjectChecker.isNegative((BigDecimal)cashVal) && !allowNegative) {
            cashVal = BigDecimal.ZERO;
        }
        cashMethodTextField.setText(cashVal.toString());
    }

    private void updateRemainingField() {
        String netText = this.invoiceNet.getText();
        BigDecimal invoiceNet = ObjectChecker.isEmptyOrNull((Object)netText) ? BigDecimal.ZERO : new BigDecimal(netText);
        BigDecimal remainingVal = this.findTotalPayments(false, false).subtract(invoiceNet);
        this.remainingAmount.setText(NaMaMath.round((BigDecimal)remainingVal, (Integer)POSMoneyUtils.displayDecimalPlaces).toString());
    }

    private void updatePaymentsValues(NamaTextField amountField) {
        PaymentInfo info = this.fetchPaymentInfo(amountField);
        if (info == null) {
            return;
        }
        if (ObjectChecker.isEmptyOrNull((Object)amountField.getText())) {
            info.setValue(BigDecimal.ZERO);
            return;
        }
        try {
            if (amountField.getText().equals(".")) {
                return;
            }
            BigDecimal value = new BigDecimal(amountField.getText());
            info.setValue(value);
        }
        catch (NumberFormatException e) {
            amountField.clear();
        }
    }

    private PaymentInfo fetchPaymentInfo(NamaTextField field) {
        for (Map.Entry<POSPaymentMethod, List<PaymentInfo>> entry : this.payments.entrySet()) {
            for (PaymentInfo info : entry.getValue()) {
                if (!ObjectChecker.areEqual((Object)(entry.getKey().nameByLanguage() + "_#_" + info.getMethodIndex()), (Object)field.getId())) continue;
                return info;
            }
        }
        for (PaymentInfo info : this.creditNotesInfo) {
            if (!ObjectChecker.areEqual((Object)(this.creditNoteMethod.methodName() + "_#_" + info.getMethodIndex()), (Object)field.getId())) continue;
            return info;
        }
        for (PaymentInfo info : this.couponsInfo) {
            if (!ObjectChecker.areEqual((Object)(this.couponMethod.methodName() + "_#_" + info.getMethodIndex()), (Object)field.getId())) continue;
            return info;
        }
        return null;
    }

    private void sortPaymentMethods() {
        Collections.sort(this.paymentMethods, new Comparator<POSPaymentMethod>(this){

            @Override
            public int compare(POSPaymentMethod o1, POSPaymentMethod o2) {
                return o1.getOrderInPOS().compareTo(o2.getOrderInPOS());
            }
        });
    }

    public static POSResult process(PayRequest payRequest, MultiplePaymentDialog dialog) {
        boolean paymentIsNotDelayed;
        POSResult posResult = new POSResult();
        AbsPOSSales salesDoc = payRequest.getSalesDoc();
        NamaSingleValue fail = new NamaSingleValue((Object)false);
        if (MultiplePaymentDialog.emptyRequiredRemarks(salesDoc, payRequest.getRemarks())) {
            MultiplePaymentDialog.handleFailure(dialog, posResult, (NamaSingleValue<Boolean>)fail, "Remarks Required", new Object[0]);
        }
        Map<POSPaymentMethod, List<PaymentInfo>> payments = payRequest.getPayments();
        MultiplePaymentDialog.checkReturnRequiredMethods(salesDoc, payments, dialog, (NamaSingleValue<Boolean>)fail, posResult);
        if (payRequest.isUseCreditNotes()) {
            MultiplePaymentDialog.checkCustomizedMethods(MultiplePaymentDialog.createCheckCustomizedMethodsReqFromPayReq(payRequest, (NamaSingleValue<Boolean>)fail, false), dialog, posResult);
        }
        if (payRequest.isUseCoupons()) {
            MultiplePaymentDialog.checkCustomizedMethods(MultiplePaymentDialog.createCheckCustomizedMethodsReqFromPayReq(payRequest, (NamaSingleValue<Boolean>)fail, true), dialog, posResult);
        }
        boolean bl = paymentIsNotDelayed = !payRequest.isDelayPayment();
        if (paymentIsNotDelayed && !MultiplePaymentDialog.validatePayment(payRequest, posResult)) {
            MultiplePaymentDialog.handleFailure(dialog, posResult, (NamaSingleValue<Boolean>)fail, "invalidPayment", new Object[0]);
        } else {
            BigDecimal remainingAmount = payRequest.getRemainingAmount();
            if (paymentIsNotDelayed) {
                Boolean allowOverpayByNonCash = POSConfigurationUtil.shouldAllowCustomerToOverpayByNonCash(payRequest.getRegister());
                for (Map.Entry<POSPaymentMethod, List<PaymentInfo>> posPaymentMethod : payments.entrySet()) {
                    BigDecimal totalValByMethod = MultiplePaymentDialog.calcTotalPayByMethod(posPaymentMethod.getValue());
                    for (PaymentInfo info : posPaymentMethod.getValue()) {
                        BigDecimal currValByMethod;
                        if (totalValByMethod.compareTo(payRequest.getValue()) > 0 && ObjectChecker.areNotEqual((Object)posPaymentMethod.getKey(), (Object)MultiplePaymentDialog.searchForCashMethod()) && !allowOverpayByNonCash.booleanValue()) {
                            MultiplePaymentDialog.handleFailure(dialog, posResult, (NamaSingleValue<Boolean>)fail, "Invalid pay with payment method {0}", posPaymentMethod.getKey().nameByLanguage());
                        }
                        if (ObjectChecker.isNotEmptyOrZero((BigDecimal)(currValByMethod = info.getValue())) && (ObjectChecker.isTrue((Boolean)posPaymentMethod.getKey().getAuthorizationNumberRequire()) || info.isPaidFromTerminal()) && ObjectChecker.isEmptyOrNull((Object)info.getProcessNumber())) {
                            MultiplePaymentDialog.handleFailure(dialog, posResult, (NamaSingleValue<Boolean>)fail, "Authorization Number Require for method {0}", posPaymentMethod.getKey().nameByLanguage());
                        }
                        if (!ObjectChecker.isNotEmptyOrNull((Object)info.getProcessNumber()) || !ObjectChecker.isEmptyOrZero((BigDecimal)currValByMethod)) continue;
                        MultiplePaymentDialog.handleFailure(dialog, posResult, (NamaSingleValue<Boolean>)fail, "Process number with no value {0}", posPaymentMethod.getKey().nameByLanguage());
                    }
                    if (posPaymentMethod.getKey().getCashMethod().booleanValue() && (POSEntityUtil.isReturn(payRequest.getDocType()) || POSEntityUtil.isReplacement(payRequest.getDocType()) && salesDoc.calcReturnNet().abs().compareTo(salesDoc.calcInvNet().abs()) > 0)) {
                        POSResult result = new POSResult();
                        BigDecimal remaining = ObjectChecker.isEmptyOrNull((Object)remainingAmount) ? BigDecimal.ZERO : remainingAmount;
                        POSPaymentMethodsUtil.checkAvailableCash(payRequest.getRegister(), result, totalValByMethod.subtract(remaining));
                        if (result.isFailed().booleanValue()) {
                            MultiplePaymentDialog.handleFailure(dialog, posResult, (NamaSingleValue<Boolean>)fail, result.getMessageByLanguage(), new Object[0]);
                            fail.setValue((Object)true);
                        }
                    }
                    if (!((Boolean)fail.getValue()).booleanValue()) continue;
                    break;
                }
            }
            salesDoc.updateRemarksIfNotEmpty(payRequest.getRemarks());
            if (!((Boolean)fail.getValue()).booleanValue()) {
                POSResult okResult;
                BigDecimal defaultCashVal = BigDecimal.ZERO;
                BigDecimal remainingChange = BigDecimal.ZERO;
                if (paymentIsNotDelayed) {
                    if (ObjectChecker.isNotEmptyOrNull((Object)remainingAmount)) {
                        remainingChange = remainingAmount;
                    }
                    salesDoc.setRemainingChange(remainingChange);
                    salesDoc.addPaymentDetails(payRequest.getPayments(), payRequest.getRegister());
                    defaultCashVal = ObjectChecker.toZeroIfNull((BigDecimal)payRequest.getDefaultCashAmount());
                }
                if ((okResult = AbsPosSalesScreen.applyEffects(payRequest, defaultCashVal, remainingChange, !paymentIsNotDelayed, salesDoc)).isFailed().booleanValue()) {
                    posResult.accumulate(okResult);
                }
                if (dialog != null) {
                    dialog.hideDialog(payRequest.getScreen());
                    if (posResult.isFailed().booleanValue()) {
                        POSErrorAndInfoMessagesUtil.showError(posResult.getMessageByLanguage(), payRequest.getScreen().stage);
                    }
                }
            }
        }
        return posResult;
    }

    private static CheckCustomizedMethodsRequest createCheckCustomizedMethodsReqFromPayReq(PayRequest payRequest, NamaSingleValue<Boolean> fail, boolean createForCoupons) {
        CheckCustomizedMethodsRequest request = new CheckCustomizedMethodsRequest();
        if (createForCoupons) {
            request.infos = payRequest.getCouponsInfo();
            request.methodName = payRequest.getCouponMethodName();
        } else {
            request.infos = payRequest.getCreditNotesInfo();
            request.methodName = payRequest.getCreditNoteMethodName();
        }
        request.salesDoc = payRequest.getSalesDoc();
        request.defaultCashAmount = payRequest.getDefaultCashAmount();
        request.debitAmount = payRequest.getDebitAmount();
        request.payments = payRequest.getPayments();
        request.creditNotesInfo = payRequest.getCreditNotesInfo();
        request.couponsInfo = payRequest.getCouponsInfo();
        request.creditNoteMethodName = payRequest.getCreditNoteMethodName();
        request.couponMethodName = payRequest.getCouponMethodName();
        request.fail = fail;
        return request;
    }

    @Override
    public void hideDialog(AbsPosSalesScreen screen) {
        this.close();
        AbsPosSalesScreen.setActivatedDialog(null);
    }

    public static boolean emptyRequiredRemarks(AbsPOSSales salesDoc, String remarks) {
        return salesDoc instanceof POSSalesReturn && ObjectChecker.isTrue((Boolean)POSResourcesUtil.fetchPOSConfig().getRemarksRequiredInSalesReturn()) && ObjectChecker.isEmptyOrNull((Object)remarks);
    }

    private static void checkCustomizedMethods(CheckCustomizedMethodsRequest request, MultiplePaymentDialog dialog, POSResult result) {
        BigDecimal toPaidAmount = NaMaMath.zeroIfNull((BigDecimal)request.salesDoc.getNetPrice()).subtract(MultiplePaymentDialog.findTotalPayments(false, true, false, request.defaultCashAmount, request.debitAmount, request.payments, request.creditNotesInfo, request.couponsInfo));
        BigDecimal totalByMethod = MultiplePaymentDialog.totalBy(request.infos);
        if (request.salesDoc.getNetPrice().compareTo(totalByMethod) >= 0) {
            toPaidAmount = totalByMethod;
        }
        if (ObjectChecker.isNotEmptyOrZero((BigDecimal)totalByMethod) && totalByMethod.compareTo(toPaidAmount) > 0) {
            result.failure("Invalid amount for {0}", request.methodName);
        }
        HashMap<String, BigDecimal> paymentTotals = new HashMap<String, BigDecimal>();
        for (PaymentInfo paymentInfo : request.infos) {
            paymentTotals.computeIfAbsent(paymentInfo.getProcessNumber(), s -> BigDecimal.ZERO);
            paymentTotals.put(paymentInfo.getProcessNumber(), ((BigDecimal)paymentTotals.get(paymentInfo.getProcessNumber())).add(paymentInfo.getValue()));
            if (ObjectChecker.isNotEmptyOrZero((BigDecimal)paymentInfo.getValue()) && PosScene.connectionIsDown()) {
                result.failure("Connection Failed", new Object[0]);
            }
            if (paymentInfo.getValue().compareTo(BigDecimal.ZERO) < 0) {
                result.failure("Negative Payment for {0}", request.methodName);
            }
            if (paymentInfo.getValue().compareTo(BigDecimal.ZERO) > 0) {
                MultiplePaymentDialog.checkPaymentInfoVal(request.methodName, request.creditNoteMethodName, toPaidAmount, paymentInfo, request.salesDoc, request.couponMethodName, result);
            }
            if (paymentInfo.getValue().compareTo(BigDecimal.ZERO) != 0 || !ObjectChecker.isNotEmptyOrNull((Object)paymentInfo.getProcessNumber())) continue;
            result.failure("Please Enter value for {0}", request.methodName);
        }
        if (paymentTotals.entrySet().size() != request.infos.size()) {
            for (Map.Entry entry : paymentTotals.entrySet()) {
                MultiplePaymentDialog.checkCustomizedMethods(request.methodName, (BigDecimal)entry.getValue(), (String)entry.getKey(), toPaidAmount, request.salesDoc, request.creditNoteMethodName, request.couponMethodName, result);
            }
        }
        if (result.isFailed().booleanValue()) {
            MultiplePaymentDialog.handleFailure(dialog, null, request.fail, result.getMessageByLanguage(), new Object[0]);
        }
    }

    private static void checkPaymentInfoVal(String methodName, String creditNoteMethodName, BigDecimal toPaidAmount, PaymentInfo paymentInfo, AbsPOSSales salesDoc, String couponMethodName, POSResult result) {
        Boolean overpayByNonCash;
        if (ObjectChecker.areEqual((Object)methodName, (Object)creditNoteMethodName) && !MultiplePaymentDialog.needCheck(salesDoc)) {
            return;
        }
        if (ObjectChecker.isEmptyOrNull((Object)paymentInfo.getProcessNumber())) {
            result.failure("Please Enter Process Number for {0}", methodName);
        }
        if (!(overpayByNonCash = POSConfigurationUtil.shouldAllowCustomerToOverpayByNonCash(POSResourcesUtil.fetchMainRegister())).booleanValue() && paymentInfo.getValue().compareTo(salesDoc.getNetPrice().abs()) > 0) {
            result.failure("{0} value greater than invoice value", methodName);
        }
        try {
            MultiplePaymentDialog.checkCustomizedMethods(methodName, paymentInfo.getValue(), paymentInfo.getProcessNumber(), toPaidAmount, salesDoc, creditNoteMethodName, couponMethodName, result);
        }
        catch (Exception exception) {
            NaMaLogger.error((Throwable)exception);
            result.failure("Connection Failed", new Object[0]);
        }
    }

    private static void checkCustomizedMethods(String methodName, BigDecimal value, String processNumber, BigDecimal toPaidAmount, AbsPOSSales salesDoc, String creditNoteMethodName, String couponMethodName, POSResult result) {
        UUID customerID;
        if (value.compareTo(toPaidAmount) > 0) {
            result.failure("Invalid amount for {0} {1}", methodName, processNumber);
        }
        UUID uUID = customerID = salesDoc.getCustomer() == null ? null : salesDoc.getCustomer().getId();
        if (ObjectChecker.areEqual((Object)methodName, (Object)creditNoteMethodName)) {
            MultiplePaymentDialog.validateCreditNoteMethod(new DTOPaymentMethodInfo(value, salesDoc.getNetPrice(), toPaidAmount, POSMoneyUtils.displayDecimalPlaces, processNumber, customerID), result);
        } else if (ObjectChecker.areEqual((Object)methodName, (Object)couponMethodName)) {
            MultiplePaymentDialog.validateCouponMethod(new DTOPaymentMethodInfo(value, salesDoc.getNetPrice(), toPaidAmount, POSMoneyUtils.displayDecimalPlaces, processNumber, customerID), result);
        }
    }

    private static BigDecimal calcTotalPayByMethod(List<PaymentInfo> infos) {
        return CollectionsUtility.totalize(infos, PaymentInfo::getValue);
    }

    private static void checkReturnRequiredMethods(AbsPOSSales salesDoc, Map<POSPaymentMethod, List<PaymentInfo>> payments, MultiplePaymentDialog dialog, NamaSingleValue<Boolean> fail, POSResult result) {
        if (!(salesDoc instanceof POSSalesReturn)) {
            return;
        }
        List<Pair<POSPaymentMethod, BigDecimal>> methodsWithPercents = ((POSSalesReturn)salesDoc).fromInvoiceRequiredMethodsWithPercents();
        if (ObjectChecker.isEmptyOrNull(methodsWithPercents)) {
            return;
        }
        for (Pair<POSPaymentMethod, BigDecimal> pair : methodsWithPercents) {
            List<PaymentInfo> infos = payments.get(pair.getX());
            BigDecimal paidByReqMethod = MultiplePaymentDialog.calcTotalPayByMethod(infos);
            if (ObjectChecker.isEmptyOrZero((BigDecimal)paidByReqMethod)) {
                result.failure("Required payment method  - {0}", ((POSPaymentMethod)pair.getX()).nameByLanguage());
                continue;
            }
            BigDecimal currentMethodPercent = NaMaMath.divide((BigDecimal)paidByReqMethod, (BigDecimal)salesDoc.getNetPrice(), (Integer)salesDoc.getCurrency().getFractionDecimalPlaces()).multiply(BigDecimal.valueOf(100L));
            if (((BigDecimal)pair.getY()).compareTo(currentMethodPercent) <= 0) continue;
            result.failure("Invalid Payment percentage with method  - {0}", ((POSPaymentMethod)pair.getX()).nameByLanguage());
        }
        if (result.isFailed().booleanValue()) {
            MultiplePaymentDialog.handleFailure(dialog, null, fail, result.getMessageByLanguage(), new Object[0]);
        }
    }

    private static void handleFailure(MultiplePaymentDialog dialog, POSResult result, NamaSingleValue<Boolean> fail, String message, Object ... messageParams) {
        if (fail != null) {
            fail.setValue((Object)true);
        }
        if (result != null) {
            result.failure(message, messageParams);
        }
        if (dialog != null) {
            dialog.error(message);
        }
    }

    private static boolean paymentWithNegativeVal(PayRequest payRequest) {
        if (MultiplePaymentDialog.validateNegativePayments(payRequest)) {
            return true;
        }
        if (payRequest.getDefaultCashAmount().compareTo(BigDecimal.ZERO) < 0) {
            return true;
        }
        return payRequest.getDebitAmount().compareTo(BigDecimal.ZERO) < 0;
    }

    private static boolean validateNegativePayments(PayRequest payRequest) {
        for (Map.Entry<POSPaymentMethod, List<PaymentInfo>> entry : payRequest.getPayments().entrySet()) {
            if (entry.getKey() != null & ObjectChecker.isTrue((Boolean)entry.getKey().getCashMethod()) && POSConfigurationUtil.shouldAllowCustomerToOverpayByNonCash(payRequest.getRegister()).booleanValue()) continue;
            for (PaymentInfo info : entry.getValue()) {
                if (!ObjectChecker.isNotEmptyOrZero((BigDecimal)info.getValue()) || info.getValue().compareTo(BigDecimal.ZERO) >= 0) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean validatePayment(PayRequest payRequest, POSResult result) {
        return MultiplePaymentDialog.validateRemaining(payRequest, result) != false && !MultiplePaymentDialog.paymentWithNegativeVal(payRequest);
    }

    private static Boolean validateRemaining(PayRequest payRequest, POSResult result) {
        BigDecimal totalPaid = MultiplePaymentDialog.findTotalPayments(false, false, payRequest);
        BigDecimal value = payRequest.getValue();
        boolean isNotReservation = ObjectChecker.areNotEqual((Object)((Object)payRequest.getDocType()), (Object)((Object)POSDocumentType.POSOrderReservation));
        BigDecimal remaining = payRequest.getRemainingAmount();
        BigDecimal cashValue = payRequest.getCashValue();
        BigDecimal nonCashPayments = MultiplePaymentDialog.findTotalPayments(true, false, payRequest);
        boolean allowCustomerToOverpayByNonCash = POSConfigurationUtil.shouldAllowCustomerToOverpayByNonCash(payRequest.getRegister());
        if (!PaymentDialogHelper.isRemainingValid(value, totalPaid, payRequest.getDocType())) {
            result.failure("Invalid remaining", new Object[0]);
        } else if (isNotReservation && ObjectChecker.isNegative((BigDecimal)remaining)) {
            result.failure("Negative remaining", new Object[0]);
        } else if (isNotReservation && ObjectChecker.isNotEmptyOrZero((BigDecimal)remaining) && ObjectChecker.isEmptyOrZero((BigDecimal)cashValue) && !allowCustomerToOverpayByNonCash) {
            result.failure("Invalid remaining", new Object[0]);
        }
        if (ObjectChecker.isNegative((BigDecimal)cashValue) && !allowCustomerToOverpayByNonCash) {
            result.failure("Negative cash", new Object[0]);
        }
        if (isNotReservation && value.subtract(remaining).compareTo(totalPaid) > 0) {
            result.failure("Invalid payment", new Object[0]);
        } else if (nonCashPayments.compareTo(value) > 0 && !allowCustomerToOverpayByNonCash) {
            result.failure("Invalid payment", new Object[0]);
        }
        return result.isSucceeded();
    }

    private BigDecimal findTotalPayments(boolean excludeCash, boolean excludeCreditAndCoupon, boolean excludeDefaultMethod) {
        return MultiplePaymentDialog.findTotalPayments(excludeCash, excludeCreditAndCoupon, excludeDefaultMethod, ObjectChecker.isNotEmptyOrNull((Object)this.cash.getText()) ? new BigDecimal(this.cash.getText()) : BigDecimal.ZERO, ObjectChecker.isNotEmptyOrNull((Object)this.debit.getText()) ? new BigDecimal(this.debit.getText()) : BigDecimal.ZERO, this.payments, this.creditNotesInfo, this.couponsInfo);
    }

    private static BigDecimal findTotalPayments(boolean excludeCash, boolean excludeCreditAndCoupon, boolean excludeDefaultMethod, BigDecimal defaultCashAmount, BigDecimal debitAmount, Map<POSPaymentMethod, List<PaymentInfo>> payments, List<PaymentInfo> creditNotesInfo, List<PaymentInfo> couponsInfo) {
        BigDecimal total = ObjectChecker.toZeroIfNull((BigDecimal)debitAmount);
        if (!excludeCash) {
            total = NaMaMath.add((BigDecimal[])new BigDecimal[]{total, defaultCashAmount});
        }
        for (Map.Entry<POSPaymentMethod, List<PaymentInfo>> posPaymentMethod : payments.entrySet()) {
            if (ObjectChecker.isTrue((Boolean)posPaymentMethod.getKey().getCashMethod()) && excludeCash || ObjectChecker.isTrue((Boolean)posPaymentMethod.getKey().getDefaultMethod()) && excludeDefaultMethod) continue;
            for (PaymentInfo info : posPaymentMethod.getValue()) {
                if (!ObjectChecker.isNotEmptyOrZero((BigDecimal)info.getValue())) continue;
                total = total.add(info.getValue());
            }
        }
        if (!excludeCreditAndCoupon) {
            if (ObjectChecker.isNotEmptyOrNull(creditNotesInfo)) {
                total = total.add(MultiplePaymentDialog.totalBy(creditNotesInfo));
            }
            if (ObjectChecker.isNotEmptyOrNull(couponsInfo)) {
                total = total.add(MultiplePaymentDialog.totalBy(couponsInfo));
            }
        }
        return total;
    }

    private BigDecimal findTotalPayments(boolean excludeCash, boolean excludeCreditAndCoupon) {
        return this.findTotalPayments(excludeCash, excludeCreditAndCoupon, false);
    }

    private static BigDecimal findTotalPayments(boolean excludeCash, boolean excludeCreditAndCoupon, PayRequest payRequest) {
        return MultiplePaymentDialog.findTotalPayments(excludeCash, excludeCreditAndCoupon, false, payRequest.getDefaultCashAmount(), payRequest.getDebitAmount(), payRequest.getPayments(), payRequest.getCreditNotesInfo(), payRequest.getCouponsInfo());
    }

    private static BigDecimal totalBy(List<PaymentInfo> infos) {
        return CollectionsUtility.totalize(infos, PaymentInfo::getValue);
    }

    public static String searchForCashMethodName() {
        POSPaymentMethod cash = MultiplePaymentDialog.searchForCashMethod();
        if (ObjectChecker.isNotEmptyOrNull((Object)cash)) {
            return cash.nameByLanguage();
        }
        return POSResourcesUtil.id("cash", new Object[0]);
    }

    public static POSPaymentMethod searchForCashMethod() {
        if (ObjectChecker.isEmptyOrNull(POSResourcesUtil.methods)) {
            return null;
        }
        List cashMethods = CollectionsUtility.filter(POSResourcesUtil.methods, object -> object.getCashMethod());
        if (ObjectChecker.isEmptyOrNull((Object)cashMethods)) {
            return null;
        }
        return (POSPaymentMethod)cashMethods.get(0);
    }

    public static UUID cashMethodID() {
        POSPaymentMethod posPaymentMethod = MultiplePaymentDialog.searchForCashMethod();
        if (ObjectChecker.isEmptyOrNull((Object)posPaymentMethod)) {
            return null;
        }
        return posPaymentMethod.getId();
    }

    public void sendAmountToTerminal(BigDecimal amountToSend, AbsPOSSales salesDoc, POSPaymentMethod currentMethod, NamaPaymentTextField currentMethodField) {
        try {
            BigDecimal totalPaid;
            PaymentInfo paymentInfo;
            if (ObjectChecker.isEmptyOrZero((BigDecimal)amountToSend)) {
                this.error("Please enter amount to pay by terminal");
                return;
            }
            amountToSend = NaMaMath.absValue((BigDecimal)amountToSend);
            String url = "http://localhost:7842/payInvoice/" + String.valueOf(amountToSend);
            String resp = (String)PosEntryPoint.restTemplate.getForObject(url, String.class, new Object[0]);
            PGWUtil.TerminalPaymentResp terminalPaymentResp = PGWUtil.paymentLineFromPGWResponse(POSResourcesUtil.fetchMainRegister(), resp, amountToSend, null);
            POSResult result = new POSResult();
            PGWUtil.validatePGWResponse(terminalPaymentResp, result);
            if (result.isFailed().booleanValue()) {
                this.error(result.getMessageByLanguage());
                return;
            }
            POSPaymentMethod paymentMethod = terminalPaymentResp.getMethod();
            DTOPGWProperties pgwProperties = terminalPaymentResp.getLine().getPgwProperties();
            BigDecimal paymentValue = amountToSend;
            if (!this.paymentMethods.contains(paymentMethod)) {
                this.paymentMethods.add(paymentMethod);
            }
            if (ObjectChecker.areNotEqual((Object)paymentMethod, (Object)currentMethod)) {
                currentMethodField.clear();
                NamaPaymentTextField textField = this.fetchPaymentMethodField(paymentMethod);
                if (textField == null || textField != null && ObjectChecker.isNotEmptyOrNull((Object)textField.getText())) {
                    this.addMethodBtnAction(this.paymentMethods.lastIndexOf(paymentMethod), new PredefinedPaymentMethod(paymentMethod), salesDoc, true, pgwProperties, false);
                    textField = this.fetchPaymentMethodField(paymentMethod);
                }
                textField.setText(paymentValue.toString());
                if (textField.getRelatedAuthCodeField() != null) {
                    textField.getRelatedAuthCodeField().setText(pgwProperties.getAuthCode());
                }
            } else if (currentMethodField.getRelatedAuthCodeField() != null) {
                currentMethodField.getRelatedAuthCodeField().setText(pgwProperties.getAuthCode());
            }
            if (this.payments.containsKey(paymentMethod) && (paymentInfo = (PaymentInfo)this.payments.get(paymentMethod).stream().filter(p -> ObjectChecker.areEqual((Object)p.getValue(), (Object)paymentValue)).findFirst().orElse(null)) != null) {
                paymentInfo.setPaidFromTerminal(true);
            }
            if (ObjectChecker.isTrue((Boolean)POSResourcesUtil.fetchPOSConfig().getAutoSaveInvoiceAfterTerminalPayment()) && (totalPaid = this.gridToAddTo.getChildren().stream().filter(c -> c instanceof NamaTextField && ObjectChecker.areEqual((Object)((NamaTextField)c).getTitle(), (Object)"amountField")).map(c -> MultiplePaymentDialog.toZeroIfNullOrEmpty(((NamaTextField)c).getText())).reduce(BigDecimal.ZERO, BigDecimal::add)).compareTo(salesDoc.getNetPrice()) >= 0) {
                this.processAction(salesDoc);
            }
        }
        catch (Exception e) {
            this.error("There is no connection on port 7842, please make sure that the PGW server is running. You can download the setup file from <a href='https://www.namasoft.com/bin/PGWSetup.msi' target='_blank'>here</a>");
            NaMaLogger.error((Throwable)e);
        }
    }

    public NamaPaymentTextField fetchPaymentMethodField(POSPaymentMethod paymentMethod) {
        List fields = this.paymentTextFields.stream().filter(f -> f.getId() != null && f.getId().contains(paymentMethod.nameByLanguage() + "_#_")).collect(Collectors.toList());
        if (ObjectChecker.isEmptyOrNull(fields)) {
            return null;
        }
        return (NamaPaymentTextField)fields.get(fields.size() - 1);
    }

    class CustomeCreditNotePaymentMethod
    implements ICustomPaymentMethod {
        CustomeCreditNotePaymentMethod() {
        }

        @Override
        public boolean needCheck(AbsPOSSales salesDoc) {
            return MultiplePaymentDialog.needCheck(salesDoc);
        }

        @Override
        public String methodName() {
            return POSResourcesUtil.id("Credit Note", new Object[0]);
        }

        @Override
        public void addToGrid(int gridIndex, int methodIndex, AbsPOSSales salesDoc) {
            NamaPaymentTextField creditNote = new NamaPaymentTextField();
            NamaTextField creditNoteProcessNum = new NamaTextField(POSFieldType.Text);
            MultiplePaymentDialog.this.addMethodPartToGrid(creditNote, creditNoteProcessNum, gridIndex, methodIndex, false, this, salesDoc, false, new DTOPGWProperties());
        }

        @Override
        public void processNumAction(NamaTextField processNumberField, NamaTextField amountField, AbsPOSSales salesDoc) {
            MultiplePaymentDialog.this.creditNoteCodeNumber(processNumberField, amountField, salesDoc);
        }

        @Override
        public void addPaymentInfo(int methodIndex, PaymentInfo info) {
            MultiplePaymentDialog.this.creditNotesInfo.add(info);
        }

        @Override
        public void validateMethod(DTOPaymentMethodInfo dtoPaymentMethodInfo) {
            POSResult result = new POSResult();
            MultiplePaymentDialog.validateCreditNoteMethod(dtoPaymentMethodInfo, result);
            if (result.isFailed().booleanValue()) {
                MultiplePaymentDialog.handleFailure(MultiplePaymentDialog.this, null, null, result.getMessageByLanguage(), new Object[0]);
            }
        }

        @Override
        public boolean allowedForType(AbsPOSSales salesDoc, String type) {
            if (!MultiplePaymentDialog.this.useCreditNotes) {
                return false;
            }
            return ObjectChecker.isAnyEqualToFirst((Object)type, (Object[])new String[]{"NamaPOSSalesInvoice", "NamaPOSSalesReturn"}) || ObjectChecker.areEqual((Object)type, (Object)"NamaPOSSalesReplacement") && ((POSSalesReplacement)salesDoc).isTotalIsPositive();
        }

        @Override
        public String valueFieldTitle() {
            return POSResourcesUtil.id("Credit Note Value", new Object[0]);
        }

        @Override
        public String processNumberFieldTitle() {
            return POSResourcesUtil.id("Credit Note Code", new Object[0]);
        }
    }

    class CustomeCouponPaymentMethod
    implements ICustomPaymentMethod {
        CustomeCouponPaymentMethod() {
        }

        @Override
        public String methodName() {
            return POSResourcesUtil.id("Coupon", new Object[0]);
        }

        @Override
        public void addToGrid(int gridIndex, int methodIndex, AbsPOSSales salesDoc) {
            NamaPaymentTextField coupon = new NamaPaymentTextField();
            NamaTextField couponProcessNum = new NamaTextField(POSFieldType.Text);
            MultiplePaymentDialog.this.addMethodPartToGrid(coupon, couponProcessNum, gridIndex, methodIndex, false, this, salesDoc, false, new DTOPGWProperties());
        }

        @Override
        public void processNumAction(NamaTextField processNumberField, NamaTextField amountField, AbsPOSSales salesDoc) {
            MultiplePaymentDialog.this.couponAction(processNumberField, amountField, salesDoc);
        }

        @Override
        public void addPaymentInfo(int methodIndex, PaymentInfo info) {
            MultiplePaymentDialog.this.couponsInfo.add(info);
        }

        @Override
        public void validateMethod(DTOPaymentMethodInfo dtoPaymentMethodInfo) {
            POSResult result = new POSResult();
            MultiplePaymentDialog.validateCouponMethod(dtoPaymentMethodInfo, result);
            if (result.isFailed().booleanValue()) {
                MultiplePaymentDialog.handleFailure(MultiplePaymentDialog.this, null, null, result.getMessageByLanguage(), new Object[0]);
            }
        }

        @Override
        public boolean allowedForType(AbsPOSSales salesDoc, String type) {
            if (!MultiplePaymentDialog.this.useCoupons) {
                return false;
            }
            return ObjectChecker.areEqual((Object)type, (Object)"NamaPOSSalesInvoice") || ObjectChecker.areEqual((Object)type, (Object)"NamaPOSSalesReplacement") && ((POSSalesReplacement)salesDoc).isTotalIsPositive();
        }

        @Override
        public String valueFieldTitle() {
            return POSResourcesUtil.id("Coupon Value", new Object[0]);
        }

        @Override
        public String processNumberFieldTitle() {
            return POSResourcesUtil.id("Coupon Code", new Object[0]);
        }
    }

    class PredefinedPaymentMethod
    implements ICustomPaymentMethod {
        private POSPaymentMethod method;

        @Override
        public POSPaymentMethod getMethod() {
            return this.method;
        }

        @Override
        public boolean isCriticalMethod() {
            return ObjectChecker.isTrue((Boolean)this.method.getCriticalPosPaymentMethod());
        }

        @Override
        public boolean isCashMethod() {
            return ObjectChecker.isTrue((Boolean)this.method.getCashMethod());
        }

        @Override
        public boolean hasMasterGroup() {
            return ObjectChecker.isNotEmptyOrNull((Object)this.method.getMasterGroupId());
        }

        public PredefinedPaymentMethod(POSPaymentMethod posPaymentMethod) {
            this.method = posPaymentMethod;
        }

        @Override
        public String methodName() {
            return this.method.nameByLanguage();
        }

        @Override
        public void addToGrid(int gridIndex, int methodIndex, AbsPOSSales salesDoc) {
            MultiplePaymentDialog.this.addMethodPartToGrid(gridIndex, methodIndex, false, this, salesDoc, false, new DTOPGWProperties());
        }

        @Override
        public void processNumAction(NamaTextField processNumberField, NamaTextField amountField, AbsPOSSales salesDoc) {
        }

        @Override
        public void addPaymentInfo(int methodIndex, PaymentInfo info) {
            CollectionsUtility.getOrAdd((Object)MultiplePaymentDialog.this.paymentMethods.get(methodIndex), MultiplePaymentDialog.this.payments).add(info);
        }

        @Override
        public void validateMethod(DTOPaymentMethodInfo dtoPaymentMethodInfo) {
        }

        @Override
        public boolean isPredefinedMethod() {
            return true;
        }
    }

    private static class CheckCustomizedMethodsRequest {
        List<PaymentInfo> infos;
        String methodName;
        AbsPOSSales salesDoc;
        BigDecimal defaultCashAmount;
        BigDecimal debitAmount;
        Map<POSPaymentMethod, List<PaymentInfo>> payments;
        List<PaymentInfo> creditNotesInfo;
        List<PaymentInfo> couponsInfo;
        String creditNoteMethodName;
        String couponMethodName;
        NamaSingleValue<Boolean> fail;

        private CheckCustomizedMethodsRequest() {
        }
    }
}

