/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.application;

import com.namasoft.common.constants.POSDocsCodePrefix;
import com.namasoft.common.utilities.NaMaLogger;
import com.namasoft.common.utilities.NaMaMath;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.common.utils.ServerStringUtils;
import com.namasoft.contracts.common.dtos.requests.SendRequest;
import com.namasoft.contracts.common.dtos.results.ListResult;
import com.namasoft.modules.namapos.contracts.common.DTOPOSConfiguration;
import com.namasoft.modules.namapos.contracts.common.DTOPosGenCodingParamsReq;
import com.namasoft.modules.namapos.contracts.details.DTOPOSRegisterDocsCodingParam;
import com.namasoft.pos.application.POSDocumentType;
import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.application.POSResourcesUtil;
import com.namasoft.pos.domain.AbsPOSSales;
import com.namasoft.pos.domain.POSMasterFile;
import com.namasoft.pos.domain.POSPaymentToRegistery;
import com.namasoft.pos.domain.POSReceiptFromRegistery;
import com.namasoft.pos.domain.details.POSRegisteryCodingParam;
import com.namasoft.pos.domain.entities.POSCreditNote;
import com.namasoft.pos.domain.entities.POSInternalMessage;
import com.namasoft.pos.domain.entities.POSInventory;
import com.namasoft.pos.domain.entities.POSOrderReservation;
import com.namasoft.pos.domain.entities.POSRegistery;
import com.namasoft.pos.domain.entities.POSSalesInvoice;
import com.namasoft.pos.domain.entities.POSSalesReplacement;
import com.namasoft.pos.domain.entities.POSSalesReturn;
import com.namasoft.pos.domain.entities.POSScrapDoc;
import com.namasoft.pos.domain.entities.POSShiftOpen;
import com.namasoft.pos.domain.entities.POSShortfallsDoc;
import com.namasoft.pos.domain.entities.POSStockReceipt;
import com.namasoft.pos.domain.entities.POSStockTakingDetailsDoc;
import com.namasoft.pos.domain.entities.POSStockTransferReq;
import com.namasoft.pos.domain.entities.PosCancelReservation;
import com.namasoft.pos.util.POSGeneralSettings;
import com.namasoft.pos.util.POSWSClient;
import com.namasoft.specialserialization.ObjectCreatorUtil;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class POSCodeGenerator {
    private static Map<String, Integer> lastNumInServerMap = new HashMap<String, Integer>();

    public static String generateInvoiceCode(POSDocumentType type) {
        return POSCodeGenerator.generateInvoiceCode(type, POSResourcesUtil.fetchMainRegister());
    }

    public static String generateInvoiceCode(POSDocumentType type, POSRegistery register) {
        StringBuilder builder = new StringBuilder();
        Class klass = null;
        if (type.equals((Object)POSDocumentType.Invoice)) {
            builder.append(POSDocsCodePrefix.InvoicePrefix);
            klass = POSSalesInvoice.class;
        }
        if (type.equals((Object)POSDocumentType.POSOrderReservation)) {
            builder.append(POSDocsCodePrefix.ReservationPrefix);
            klass = POSOrderReservation.class;
        }
        if (type.equals((Object)POSDocumentType.POSCancelReservation)) {
            builder.append(POSDocsCodePrefix.CancelReservationPrefix);
            klass = PosCancelReservation.class;
        }
        if (type.equals((Object)POSDocumentType.Return)) {
            builder.append(POSDocsCodePrefix.ReturnPrefix);
            klass = POSSalesReturn.class;
        }
        if (type.equals((Object)POSDocumentType.Replacement)) {
            builder.append(POSDocsCodePrefix.ReplacementPrefix);
            klass = POSSalesReplacement.class;
        }
        if (type.equals((Object)POSDocumentType.CreditNote)) {
            builder.append(POSDocsCodePrefix.CreditNotePrefix);
            klass = POSCreditNote.class;
        }
        if (type.equals((Object)POSDocumentType.Msg)) {
            builder.append(POSDocsCodePrefix.InternalMsgPrefix);
            klass = POSInternalMessage.class;
        }
        if (type.equals((Object)POSDocumentType.StockTransferReq)) {
            builder.append(POSDocsCodePrefix.StockTransferReqPrefix);
            klass = POSStockTransferReq.class;
        }
        if (type.equals((Object)POSDocumentType.ScrapDoc)) {
            builder.append(POSDocsCodePrefix.ScrapDocPrefix);
            klass = POSScrapDoc.class;
        }
        if (type.equals((Object)POSDocumentType.ShortfallsDoc)) {
            builder.append(POSDocsCodePrefix.ShortfallsDocPrefix);
            klass = POSShortfallsDoc.class;
        }
        if (type.equals((Object)POSDocumentType.Payment)) {
            builder.append(POSDocsCodePrefix.PaymentPrefix);
            klass = POSPaymentToRegistery.class;
        }
        if (type.equals((Object)POSDocumentType.Receipt)) {
            builder.append(POSDocsCodePrefix.ReceiptPrefix);
            klass = POSReceiptFromRegistery.class;
        }
        if (type.equals((Object)POSDocumentType.StockTakingDetails)) {
            builder.append(POSDocsCodePrefix.StockTakingDetailsPrefix);
            klass = POSStockTakingDetailsDoc.class;
        }
        if (type.equals((Object)POSDocumentType.POSStockReceipt)) {
            builder.append(POSDocsCodePrefix.StockReceiptPrefix);
            klass = POSStockReceipt.class;
        }
        builder = POSCodeGenerator.constructDocCode(builder, klass, register);
        return builder.toString();
    }

    public static void fillLastDocsCodesInServerMap(POSRegistery register) {
        try {
            DTOPosGenCodingParamsReq req = new DTOPosGenCodingParamsReq();
            req.setRegisterId(ServerStringUtils.toUUIDStr((Object)register.getId()));
            req.setPrefix(POSGeneralSettings.codePrefix());
            ListResult<DTOPOSRegisterDocsCodingParam> response = POSWSClient.instance.genDocsCodingParams((SendRequest<DTOPosGenCodingParamsReq>)new SendRequest((Object)req));
            if (response.getResult().isFailed()) {
                return;
            }
            for (DTOPOSRegisterDocsCodingParam param : response.getList()) {
                lastNumInServerMap.put(register.getId().toString() + "-" + param.getEntityType(), param.getStartFrom() - 1);
            }
        }
        catch (Exception e) {
            NaMaLogger.error((Throwable)e);
        }
    }

    private static StringBuilder constructDocCode(StringBuilder builder, Class<? extends POSMasterFile> klass, POSRegistery register) {
        Integer codeSuffixLength;
        String entityType = ((POSMasterFile)ObjectCreatorUtil.creator(klass).create()).calcNamaEntityType();
        POSRegisteryCodingParam codingParam = register.fetchPOSRegisteryCodingParam(entityType);
        String codePrefix = POSGeneralSettings.codePrefix();
        if (codingParam != null && ObjectChecker.isTrue((Boolean)codingParam.getDoNotUseDefaultPrefix())) {
            builder.setLength(0);
        }
        if (codingParam == null || ObjectChecker.isFalseOrNull((Boolean)codingParam.getDoNotUseRegisterCode())) {
            builder.append(register.getCode());
        }
        if (codingParam != null) {
            codePrefix = (String)ObjectChecker.getFirstNotEmptyObj((Object[])new String[]{codingParam.getPerfix(), codePrefix});
        }
        if (ObjectChecker.isNotEmptyOrNull((Object)codePrefix)) {
            builder.insert(0, codePrefix);
        }
        DTOPOSConfiguration config = POSResourcesUtil.fetchPOSConfig();
        String codeDatePartFormat = (String)ObjectChecker.getFirstNotNullObj((Object[])new String[]{register.getCodeDatePartFormat(), config.getPosCodeDatePartFormat()});
        if (codingParam != null) {
            codeDatePartFormat = (String)ObjectChecker.getFirstNotNullObj((Object[])new String[]{codingParam.getCodeDatePartFormat(), codeDatePartFormat});
        }
        if (ObjectChecker.isNotEmptyOrNull((Object)codeDatePartFormat) && ObjectChecker.NOTisAnyEqualToFirst(klass, (Object[])new Class[]{POSInventory.class, POSShiftOpen.class})) {
            SimpleDateFormat format = new SimpleDateFormat(codeDatePartFormat);
            String date = format.format(Date.from(LocalDate.now().atStartOfDay(ZoneId.systemDefault()).toInstant()));
            builder.append(date);
        }
        if (ObjectChecker.isEmptyOrZero((Integer)(codeSuffixLength = config.getPosCodeSuffixLength()))) {
            codeSuffixLength = 8;
        }
        List<?> codes = POSPersister.searchFor("SELECT max(code) FROM " + klass.getSimpleName() + " where code like '" + builder.toString() + "%' and code not like '%draft%' and LENGTH(code)  = :length", POSPersister.params("length", builder.length() + codeSuffixLength));
        int lastNum = 0;
        if (codingParam != null) {
            int n = lastNum = codingParam.getStartFrom() == 0 ? 0 : codingParam.getStartFrom() - 1;
        }
        if (ObjectChecker.isNotEmptyOrNull(codes) && ObjectChecker.isNotEmptyOrNull(codes.get(0))) {
            String code = (String)codes.get(0);
            lastNum = NaMaMath.max((int[])new int[]{Integer.parseInt(code.substring(code.length() - codeSuffixLength, code.length())), lastNum});
        }
        builder.append(ServerStringUtils.leftPad((Integer)(NaMaMath.max((int[])new int[]{lastNum, ObjectChecker.toZeroIfNull((Integer)lastNumInServerMap.get(register.getId().toString() + "-" + entityType))}) + 1), (Integer)codeSuffixLength));
        return builder;
    }

    public static String generateShiftCode() {
        return POSCodeGenerator.generateShiftCode(POSResourcesUtil.fetchMainRegister());
    }

    public static String generateShiftCode(POSRegistery register) {
        StringBuilder builder = new StringBuilder();
        Class<POSShiftOpen> klass = POSShiftOpen.class;
        builder = POSCodeGenerator.constructDocCode(builder, klass, register);
        return builder.toString();
    }

    public static String generateInventoryCode() {
        return POSCodeGenerator.generateInventoryCode(POSResourcesUtil.fetchMainRegister());
    }

    public static String generateInventoryCode(POSRegistery register) {
        StringBuilder builder = new StringBuilder();
        Class<POSInventory> klass = POSInventory.class;
        builder = POSCodeGenerator.constructDocCode(builder, klass, register);
        return builder.toString();
    }

    public static String calcDraftCode(Class<? extends AbsPOSSales> klass, String docCode) {
        String code;
        Object draftCode = docCode;
        if (!((String)draftCode).contains("@draft")) {
            draftCode = docCode + "@draft";
        }
        List<?> codes = POSPersister.searchFor("SELECT max(code) FROM " + klass.getSimpleName() + " where code like '" + (String)draftCode + "%'");
        int lastNum = 1;
        if (ObjectChecker.isNotEmptyOrNull(codes) && ObjectChecker.isNotEmptyOrNull(codes.get(0)) && ObjectChecker.areNotEqual((Object)draftCode, (Object)(code = (String)codes.get(0)))) {
            lastNum = Integer.parseInt(code.substring(((String)draftCode).length()));
            ++lastNum;
        }
        if (((String)draftCode).endsWith("@draft")) {
            draftCode = (String)draftCode + lastNum;
        }
        return draftCode;
    }
}

