/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.application;

import com.namasoft.common.ResultDTO;
import com.namasoft.common.ServiceResponse;
import com.namasoft.common.constants.TimePeriodType;
import com.namasoft.common.utilities.Callback;
import com.namasoft.common.utilities.DiscountCouponUtil;
import com.namasoft.common.utilities.NaMaLogger;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.common.utils.TimePeriodUtilsNormal;
import com.namasoft.modules.basic.enums.CouponCodingMehod;
import com.namasoft.modules.namapos.contracts.details.DTOPOSConfigGiftCardLine;
import com.namasoft.modules.supplychain.enums.CouponDimensionsCopyMethod;
import com.namasoft.namacontrols.POSErrorAndInfoMessagesUtil;
import com.namasoft.pos.application.AbsPosSalesScreen;
import com.namasoft.pos.application.IHasToolBar;
import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.application.POSResourcesUtil;
import com.namasoft.pos.application.PaymentInfo;
import com.namasoft.pos.domain.AbsPOSSales;
import com.namasoft.pos.domain.POSMasterFile;
import com.namasoft.pos.domain.details.AbsPOSSalesLine;
import com.namasoft.pos.domain.details.POSCreditNoteLine;
import com.namasoft.pos.domain.details.POSDiscountCouponLine;
import com.namasoft.pos.domain.details.POSOfferCouponLine;
import com.namasoft.pos.domain.entities.POSCreditNote;
import com.namasoft.pos.domain.entities.POSCustomer;
import com.namasoft.pos.domain.entities.POSDiscountCoupon;
import com.namasoft.pos.domain.entities.POSRegistery;
import com.namasoft.pos.domain.entities.POSReportDefinition;
import com.namasoft.pos.domain.entities.POSSalesInvoice;
import com.namasoft.pos.domain.entities.POSSalesReturn;
import com.namasoft.pos.domain.valueobjects.POSDimInfo;
import com.namasoft.pos.domain.valueobjects.POSGenericDims;
import com.namasoft.pos.util.POSDataWriterUtil;
import com.namasoft.pos.util.POSEntityUtil;
import com.namasoft.pos.util.POSGeneralSettings;
import com.namasoft.pos.util.POSResult;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javafx.application.Platform;

public class POSCreditNoteAndCouponUtil {
    public static final ExecutorService executorService = Executors.newSingleThreadExecutor(r -> {
        Thread thread = new Thread(r, "Gen And Print Coupon Thread");
        thread.setDaemon(true);
        thread.setUncaughtExceptionHandler(POSResourcesUtil.uncaughtExceptionsHandler);
        return thread;
    });

    public static POSResult processCreditNotes(POSRegistery register, AbsPOSSales salesDoc, List<PaymentInfo> creditNoteInfos, POSResult result) {
        try {
            for (PaymentInfo creditNotePaymentInfo : creditNoteInfos) {
                POSCreditNoteAndCouponUtil.addPaidPartToCreditNote(register, creditNotePaymentInfo, salesDoc, result);
                if (!result.isFailed().booleanValue()) continue;
                return result;
            }
        }
        catch (Exception e) {
            NaMaLogger.error((Object)"cannot print receipt", (Throwable)e);
        }
        return result;
    }

    public static void genAndUpdateCreditNotes(AbsPOSSales salesDoc, List<PaymentInfo> creditNoteInfos) {
        try {
            for (PaymentInfo creditNotePaymentInfo : creditNoteInfos) {
                POSCreditNoteAndCouponUtil.genAndPrintPOSCreditNote(salesDoc, creditNotePaymentInfo.getValue());
            }
        }
        catch (Exception e) {
            NaMaLogger.error((Object)"cannot print receipt", (Throwable)e);
        }
    }

    public static void addPaidPartToCreditNote(POSRegistery register, PaymentInfo creditNotePaymentInfo, POSMasterFile<?> document, POSResult result) {
        POSCreditNote posCreditNote = (POSCreditNote)POSPersister.findByCode(POSCreditNote.class, creditNotePaymentInfo.getProcessNumber());
        if (ObjectChecker.isEmptyOrNull((Object)posCreditNote)) {
            return;
        }
        POSCreditNoteLine line = new POSCreditNoteLine();
        line.setInvoiceCode(document.getCode());
        line.setInvoiceType(document.calcNamaEntityType());
        line.setValue(creditNotePaymentInfo.getValue());
        line.setNote(posCreditNote);
        line.setInvoiceId(document.getId());
        line.setRegisterCode(POSGeneralSettings.getRegisterCode());
        posCreditNote.getDetails().add(line);
        posCreditNote.setSent(false);
        ServiceResponse response = (ServiceResponse)ObjectChecker.getFirstNotEmptyObj(POSDataWriterUtil.syncWritePOSCreditNote(register, List.of(posCreditNote)));
        if (!response.succeded()) {
            result.accumulate(ResultDTO.findLeafFailureResults((ResultDTO)response.getResult()));
            return;
        }
        if (ObjectChecker.isEmptyOrZero((BigDecimal)posCreditNote.calcUnPaidAmount())) {
            posCreditNote.setDeactivated(true);
        }
        POSPersister.saveOrUpdateWithActionHistory(posCreditNote, null).addToAccumulateResult(result);
        if (document instanceof POSSalesInvoice) {
            POSSalesInvoice inv = (POSSalesInvoice)document;
            inv.addCreditNoteLine(creditNotePaymentInfo);
        }
    }

    private static void genAndPrintPOSCreditNote(AbsPOSSales salesDoc, BigDecimal value) {
        if (ObjectChecker.isEmptyOrZero((BigDecimal)value)) {
            return;
        }
        int tryCount = 0;
        String genCode = "";
        do {
            genCode = DiscountCouponUtil.generateCouponCode((String)"", (int)POSResourcesUtil.couponCodeLength(), (Long)1L, (String)"Random", (int)tryCount);
            ++tryCount;
        } while (POSPersister.findByCode(POSDiscountCoupon.class, genCode) != null);
        POSCreditNote posCreditNote = new POSCreditNote(genCode, genCode, genCode, value, salesDoc.getCurrency());
        posCreditNote.setReturnId(salesDoc.getId());
        posCreditNote.setShiftCode(POSResourcesUtil.fetchLastOpenShift().getCode());
        posCreditNote.setCustomer(salesDoc.getCustomer());
        POSResult posResult = POSPersister.saveAndCreateActionHistoryEntry(posCreditNote);
        if (posResult.isFailed().booleanValue()) {
            POSErrorAndInfoMessagesUtil.showError(posResult, POSResourcesUtil.currentScreen.fetchStage());
            return;
        }
        ((POSSalesReturn)salesDoc).setWithCreditNote(true);
        ((POSSalesReturn)salesDoc).setCreditNote(posCreditNote);
        POSResult result = POSPersister.saveOrUpdateWithActionHistory(salesDoc, null);
        if (result.isFailed().booleanValue()) {
            POSErrorAndInfoMessagesUtil.showError(posResult, POSResourcesUtil.currentScreen.fetchStage());
            return;
        }
        POSDataWriterUtil.writePOSCreditNote(POSResourcesUtil.fetchMainRegister(), Arrays.asList(posCreditNote));
        POSReportDefinition.printForm(POSResourcesUtil.fetchMainRegister(), posCreditNote, (Callback<Void>)((Callback)c -> {}));
    }

    public static POSResult processCoupons(POSRegistery register, AbsPOSSales salesDoc, List<PaymentInfo> couponsInfoInPayments, POSResult result) {
        if (ObjectChecker.isEmptyOrNull(couponsInfoInPayments)) {
            return result;
        }
        for (PaymentInfo couponInfo : couponsInfoInPayments) {
            POSCreditNoteAndCouponUtil.addPaidPartToCoupon(register, couponInfo, salesDoc, result);
            if (!result.isFailed().booleanValue()) continue;
            return result;
        }
        return result;
    }

    private static POSResult addPaidPartToCoupon(POSRegistery register, PaymentInfo couponInfo, AbsPOSSales salesDoc, POSResult result) {
        POSDiscountCoupon coupon = (POSDiscountCoupon)POSPersister.findByCode(POSDiscountCoupon.class, couponInfo.getProcessNumber());
        if (ObjectChecker.isEmptyOrNull((Object)coupon)) {
            return result;
        }
        POSDiscountCouponLine line = new POSDiscountCouponLine();
        line.setInvCode(salesDoc.getCode());
        line.setValue(couponInfo.getValue());
        line.setCoupon(coupon);
        line.setRegisterCode(POSGeneralSettings.getRegisterCode());
        line.setInvoiceId(salesDoc.getId());
        coupon.getDetails().add(line);
        ((POSSalesInvoice)salesDoc).addCouponLine(couponInfo);
        POSPersister.saveOrUpdateWithActionHistory(coupon).addToAccumulateResult(result);
        if (result.isSucceeded().booleanValue()) {
            POSReportDefinition.printForm(register, coupon, (Callback<Void>)Callback.NULL);
        }
        return result;
    }

    public static void genAndPrintCouponFromSalesOffer(POSRegistery register, IHasToolBar view, AbsPOSSales salesDoc, BigDecimal couponVal, POSOfferCouponLine posSalesOffer, POSResult result) {
        if (ObjectChecker.isAnyEmptyOrNull((Object[])new Object[]{posSalesOffer.getCouponPeriodType(), posSalesOffer.getCouponPeriodVal()})) {
            result.failure(POSResourcesUtil.id("Cannot generate coupons as period is empty", new Object[0]), new Object[0]);
        }
        Date toDate = TimePeriodUtilsNormal.addTimePeriodToDate((Date)salesDoc.getValueDate(), (TimePeriodType)posSalesOffer.getCouponPeriodType(), (BigDecimal)posSalesOffer.getCouponPeriodVal());
        POSCreditNoteAndCouponUtil.genAndPrintCouponFromSalesOffer(register, view, salesDoc.getCustomer(), salesDoc.getValueDate(), toDate, couponVal, posSalesOffer.getCouponUsedOnce(), posSalesOffer, salesDoc);
    }

    public static void genAndPrintCouponFromSalesOffer(POSRegistery register, IHasToolBar view, POSCustomer customer, Date fromDate, Date toDate, BigDecimal couponVal, Boolean usedOnce, POSOfferCouponLine posSalesOffer, POSMasterFile doc) {
        executorService.submit(() -> {
            POSResult result = new POSResult();
            POSDiscountCoupon discountCoupon = POSCreditNoteAndCouponUtil.genAndPrintCoupon(new GenAndPrintCouponRequest(register, view, customer, fromDate, toDate, couponVal, usedOnce, posSalesOffer, doc, result));
            if (result.isFailed().booleanValue()) {
                if (view != null) {
                    Platform.runLater(() -> POSErrorAndInfoMessagesUtil.showError(result, view.fetchStage()));
                }
                return;
            }
            POSCreditNoteAndCouponUtil.writeCouponsToServer(register, List.of(discountCoupon));
            if (view != null || ObjectChecker.areNotEqual((Object)doc.calcNamaEntityType(), (Object)"NamaPOSSalesInvoice")) {
                view.doPostSaveAction();
            }
        });
    }

    private static void writeCouponsToServer(POSRegistery register, List<POSDiscountCoupon> coupons) {
        try {
            POSDataWriterUtil.syncWritePOSCoupons(register, coupons);
        }
        catch (Exception e) {
            NaMaLogger.error((Object)("cannot print receipt" + String.valueOf(e)));
        }
    }

    public static void processGiftCardsIfThere(POSRegistery register, AbsPosSalesScreen view, AbsPOSSales salesDoc) {
        List giftCards = POSResourcesUtil.fetchPOSConfig().getGiftCards();
        if (ObjectChecker.isEmptyOrNull((Object)giftCards)) {
            return;
        }
        boolean useCoupons = ObjectChecker.isTrue((Boolean)POSResourcesUtil.fetchPOSConfig().getUseCoupons());
        if (!POSEntityUtil.isInvoice(salesDoc.docType()) || !useCoupons) {
            return;
        }
        executorService.submit(() -> {
            POSResult result = new POSResult();
            ArrayList<POSDiscountCoupon> generatedCoupons = new ArrayList<POSDiscountCoupon>();
            for (AbsPOSSalesLine absPOSSalesLine : salesDoc.fetchDetails()) {
                DTOPOSConfigGiftCardLine giftCardLine = giftCards.stream().filter(l -> ObjectChecker.areEqual((Object)l.getItem().getId(), (Object)line.getItem().getId().toString())).findFirst().orElse(null);
                if (giftCardLine == null || ObjectChecker.isEmptyOrZero((BigDecimal)absPOSSalesLine.getNetPrice())) continue;
                for (int i = 0; i < absPOSSalesLine.getQty().getValue().intValue(); ++i) {
                    POSDiscountCoupon coupon = POSCreditNoteAndCouponUtil.genAndPrintCoupon(new GenAndPrintCouponRequest(register, view, absPOSSalesLine.getUnitPrice(), salesDoc, giftCardLine, result));
                    if (result.isFailed().booleanValue()) continue;
                    generatedCoupons.add(coupon);
                }
            }
            POSCreditNoteAndCouponUtil.writeCouponsToServer(register, generatedCoupons);
            if (view != null && result.isFailed().booleanValue()) {
                Platform.runLater(() -> POSErrorAndInfoMessagesUtil.showError(result, view.fetchStage()));
            }
        });
    }

    private static POSDiscountCoupon genAndPrintCoupon(GenAndPrintCouponRequest request) {
        POSMasterFile<Object> document;
        String genCode;
        int tryCount = 0;
        do {
            genCode = DiscountCouponUtil.generateCouponCode((String)request.prefix, (int)request.suffixLength, (Long)request.suffixFirstNumber, (String)((String)ObjectChecker.getFirstNotEmptyObj((Object[])new String[]{request.codingMethod, CouponCodingMehod.Random.name()})), (int)tryCount);
            ++tryCount;
        } while (POSPersister.findByCode(POSDiscountCoupon.class, genCode) != null);
        POSDiscountCoupon discountCoupon = new POSDiscountCoupon(genCode, genCode, genCode);
        discountCoupon.setCouponValue(request.couponVal);
        discountCoupon.setCustomer(request.customer);
        discountCoupon.setFromDate(request.fromDate);
        discountCoupon.setToDate(request.toDate);
        discountCoupon.setUsedOnce(request.usedOnce);
        POSMasterFile<Object> pOSMasterFile = document = request.view != null ? request.view.document() : request.doc;
        if (ObjectChecker.areEqual((Object)document.calcNamaEntityType(), (Object)"NamaPOSSalesInvoice")) {
            discountCoupon.setFromInvoiceId(document.getId());
        } else {
            discountCoupon.setFromRecId(document.getId());
        }
        discountCoupon.setGenericDims(POSCreditNoteAndCouponUtil.prepareCouponGenericDims(request.posSalesOffer));
        request.posResult.accumulate(POSPersister.saveAndCreateActionHistoryEntry(discountCoupon));
        if (request.posResult.isFailed().booleanValue()) {
            return null;
        }
        POSReportDefinition.printForm(request.register, discountCoupon, (Callback<Void>)((Callback)c -> Platform.runLater(() -> {})));
        return discountCoupon;
    }

    private static POSGenericDims prepareCouponGenericDims(POSOfferCouponLine posSalesOffer) {
        if (ObjectChecker.isEmptyOrNull((Object)posSalesOffer) || ObjectChecker.isEmptyOrNull((Object)posSalesOffer.getDimensionsCopyMethod()) || ObjectChecker.areEqual((Object)posSalesOffer.getDimensionsCopyMethod(), (Object)CouponDimensionsCopyMethod.FromInvoice.name())) {
            return POSResourcesUtil.fetchMainRegister().getGenericDims().cloneData();
        }
        return new POSGenericDims(new POSDimInfo(posSalesOffer.getLegalEntity().getId(), posSalesOffer.getLegalEntity().getCode()), new POSDimInfo(posSalesOffer.getSector().getId(), posSalesOffer.getSector().getCode()), new POSDimInfo(posSalesOffer.getBranch().getId(), posSalesOffer.getBranch().getCode()), new POSDimInfo(posSalesOffer.getDepartment().getId(), posSalesOffer.getDepartment().getCode()), new POSDimInfo(posSalesOffer.getAnalysisSet().getId(), posSalesOffer.getAnalysisSet().getCode()));
    }

    private static class GenAndPrintCouponRequest {
        public POSRegistery register;
        public IHasToolBar view;
        public POSCustomer customer;
        public Date fromDate;
        public Date toDate;
        public BigDecimal couponVal;
        public Boolean usedOnce;
        public POSOfferCouponLine posSalesOffer;
        public POSMasterFile<?> doc;
        public POSResult posResult;
        public String prefix;
        public int suffixLength;
        public long suffixFirstNumber;
        public String codingMethod;

        public GenAndPrintCouponRequest(POSRegistery register, IHasToolBar view, POSCustomer customer, Date fromDate, Date toDate, BigDecimal couponVal, Boolean usedOnce, POSOfferCouponLine posSalesOffer, POSMasterFile<?> doc, POSResult posResult) {
            this.register = register;
            this.view = view;
            this.customer = customer;
            this.fromDate = fromDate;
            this.toDate = toDate;
            this.couponVal = couponVal;
            this.usedOnce = usedOnce;
            this.posSalesOffer = posSalesOffer;
            this.doc = doc;
            this.posResult = posResult;
            this.prefix = "";
            this.suffixLength = POSResourcesUtil.couponCodeLength();
            this.suffixFirstNumber = 1L;
            this.codingMethod = CouponCodingMehod.Random.name();
        }

        public GenAndPrintCouponRequest(POSRegistery register, IHasToolBar view, BigDecimal couponVal, POSMasterFile doc, DTOPOSConfigGiftCardLine giftCardLine, POSResult posResult) {
            this.register = register;
            this.view = view;
            this.couponVal = couponVal;
            this.usedOnce = giftCardLine.getUsedOnce();
            this.doc = doc;
            this.posResult = posResult;
            this.prefix = ObjectChecker.toStringOrEmpty((Object)giftCardLine.getPrefix());
            this.suffixLength = ObjectChecker.getFirstNotEmptyOrZero((Integer[])new Integer[]{giftCardLine.getSuffixLength(), POSResourcesUtil.couponCodeLength()});
            this.suffixFirstNumber = (Long)ObjectChecker.getFirstNotNullObj((Object[])new Long[]{giftCardLine.getSuffixFirstNumber(), 1L});
            this.codingMethod = (String)ObjectChecker.getFirstNotEmptyObj((Object[])new String[]{giftCardLine.getCodingMethod()});
        }
    }
}

