/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.application;

import com.namasoft.common.flatobjects.EntityReferenceData;
import com.namasoft.common.utilities.CollectionsUtility;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.common.utils.ServerStringUtils;
import com.namasoft.namacontrols.NamaHBox;
import com.namasoft.namacontrols.POSCompositeFavouriteBtn;
import com.namasoft.namacontrols.POSFavouriteBtn;
import com.namasoft.namacontrols.POSNormalFavouriteBtn;
import com.namasoft.pos.application.AbsPosSalesScreen;
import com.namasoft.pos.application.POSResourcesUtil;
import com.namasoft.pos.application.POSSavable;
import com.namasoft.pos.application.POSUISettingsUtil;
import com.namasoft.pos.domain.POSLiteMasterFile;
import com.namasoft.pos.domain.POSMasterFile;
import com.namasoft.pos.domain.details.POSFavouriteLine;
import com.namasoft.pos.domain.entities.POSItem;
import com.namasoft.pos.domain.entities.POSRegistery;
import com.namasoft.pos.domain.valueobjects.POSFavouriteBtnLevel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.ListView;
import javafx.scene.layout.Priority;

public class POSFixedFavouriteItemsPane
extends ListView<POSFavouriteBtn> {
    public POSFixedFavouriteItemsPane(AbsPosSalesScreen screen) {
        this.setId("favourite-items-list-view");
        this.getItems().addAll(this.createFavouriteButtons(screen));
        this.setMinWidth(ObjectChecker.getFirstNotEmptyOrZero((Double[])new Double[]{POSUISettingsUtil.getPosUISettingsOptions().getFavouriteItemBtnWidth(), 110.0}));
        this.setMaxWidth(ObjectChecker.getFirstNotEmptyOrZero((Double[])new Double[]{POSUISettingsUtil.getPosUISettingsOptions().getFavouriteItemBtnWidth(), 110.0}));
        this.setPadding(new Insets(0.0));
        NamaHBox.setHgrow((Node)this, (Priority)Priority.ALWAYS);
        this.managedProperty().bind((ObservableValue)Bindings.isNotEmpty((ObservableList)this.getItems()));
        this.visibleProperty().bind((ObservableValue)Bindings.isNotEmpty((ObservableList)this.getItems()));
    }

    public List<POSFavouriteBtn> createFavouriteButtons(AbsPosSalesScreen screen) {
        ArrayList<POSFavouriteBtn> favouriteBtns = new ArrayList<POSFavouriteBtn>();
        for (POSFavouriteLine fixedFavouriteItem : POSFixedFavouriteItemsPane.readFixedFavouriteItems()) {
            if (ObjectChecker.isNotEmptyOrNull((Object)fixedFavouriteItem.getItem())) {
                POSNormalFavouriteBtn favouriteBtn = new POSNormalFavouriteBtn(new POSLiteMasterFile<POSItem>(fixedFavouriteItem.getItem()), screen);
                favouriteBtns.add(favouriteBtn);
                continue;
            }
            POSFavouriteLine line = POSFixedFavouriteItemsPane.fetchFavouriteLine(fixedFavouriteItem);
            POSCompositeFavouriteBtn compositeFavouriteBtn = new POSCompositeFavouriteBtn(line, screen, POSFavouriteBtnLevel.Level1, null, null);
            compositeFavouriteBtn.setResetBreadCrumbWithAction(true);
            favouriteBtns.add(compositeFavouriteBtn);
        }
        return favouriteBtns;
    }

    public static List<POSFavouriteLine> readFixedFavouriteItems() {
        List favouriteItems = POSFixedFavouriteItemsPane.calcFavouriteItemsFromRegister();
        if (ObjectChecker.isNotEmptyOrNull(favouriteItems)) {
            return favouriteItems;
        }
        favouriteItems = CollectionsUtility.convert((Collection)POSResourcesUtil.fetchPOSConfig().getFixedFavouriteItems(), object -> {
            if (ObjectChecker.areEqual((Object)object.getFavourite().getEntityType(), (Object)"InvItem")) {
                return POSFixedFavouriteItemsPane.createFavouriteLine(POSSavable.staticFromReference(object.getFavourite()));
            }
            return POSFixedFavouriteItemsPane.createCompositeFavouriteLine(object.getFavourite());
        });
        return favouriteItems;
    }

    public static List<POSFavouriteLine> calcFavouriteItemsFromRegister() {
        POSRegistery posRegistery = POSResourcesUtil.fetchMainRegister();
        if (posRegistery == null) {
            return null;
        }
        return CollectionsUtility.convert(posRegistery.getFixedFavouriteLines(), object -> {
            if (ObjectChecker.areEqual((Object)object.getFavourite().getNamaEntityType(), (Object)"InvItem")) {
                return POSFixedFavouriteItemsPane.createFavouriteLine(object.getFavourite().toReal());
            }
            return POSFixedFavouriteItemsPane.createCompositeFavouriteLine(object.getFavourite().toEntityRefData());
        });
    }

    private static POSFavouriteLine createFavouriteLine(POSMasterFile<?> object) {
        return new POSFavouriteLine((POSItem)object);
    }

    private static POSFavouriteLine createCompositeFavouriteLine(EntityReferenceData object) {
        return new POSFavouriteLine(null, ServerStringUtils.strToUUID((String)object.getId()), object.getEntityType(), null, null, null, null);
    }

    private static POSFavouriteLine fetchFavouriteLine(POSFavouriteLine fixedFavouriteItem) {
        return POSResourcesUtil.favouriteItems.stream().filter(i -> ObjectChecker.areEqual((Object)i.getFavouritesLevel1Id(), (Object)fixedFavouriteItem.getFavouritesLevel1Id()) && ObjectChecker.areEqual((Object)i.getFavouritesLevel1EntityType(), (Object)fixedFavouriteItem.getFavouritesLevel1EntityType())).findFirst().orElse(fixedFavouriteItem);
    }
}

