/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.application;

import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.pos.application.POSPersister;
import java.nio.ByteBuffer;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.hibernate.Session;
import org.hibernate.jdbc.Work;

public class POSJDBCQueryRunner {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Object[]> prepareAndExecuteJDBCQuery(Map<String, Object> parameters, String sql, List<String> returnColumnNamesHere, boolean updateStatement) {
        ArrayList<Object[]> retValue = new ArrayList<Object[]>();
        try (Session hibernateSession = null;){
            hibernateSession = POSPersister.openSession();
            Work runQuery = connection -> {
                NamedJDBParametersSetter parametersSetter = new NamedJDBParametersSetter(sql);
                PreparedStatement statement = connection.prepareStatement(parametersSetter.getModifiedQuery());
                parametersSetter.setParameters(parameters, statement);
                ResultSet rs = null;
                if (updateStatement) {
                    try {
                        statement.executeUpdate();
                    }
                    finally {
                        statement.close();
                    }
                    return;
                }
                try {
                    rs = statement.executeQuery();
                    ResultSetMetaData metaData = rs.getMetaData();
                    int columnCount = metaData.getColumnCount();
                    if (returnColumnNamesHere != null) {
                        for (int i = 1; i <= columnCount; ++i) {
                            returnColumnNamesHere.add(metaData.getColumnName(i));
                        }
                    }
                    while (rs.next()) {
                        ArrayList<Object> valuesLine = new ArrayList<Object>();
                        for (int i = 1; i <= columnCount; ++i) {
                            Object val = rs.getObject(i);
                            valuesLine.add(val);
                        }
                        retValue.add(valuesLine.toArray());
                    }
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                    if (statement != null) {
                        statement.close();
                    }
                }
            };
            hibernateSession.doWork(runQuery);
        }
        return retValue;
    }

    public static void setParameterValue(PreparedStatement statement, int i, Object param) throws SQLException {
        Object sqlValue = POSJDBCQueryRunner.sqlValue(param);
        if (sqlValue != null && sqlValue.getClass().isArray() && sqlValue.getClass().getComponentType() == Byte.TYPE) {
            statement.setBytes(i, (byte[])sqlValue);
        } else if (sqlValue != null && sqlValue instanceof Date) {
            statement.setDate(i, new java.sql.Date(((Date)sqlValue).getTime()));
        } else {
            statement.setObject(i, sqlValue);
        }
    }

    public static Object sqlValue(Object value) {
        if (value == null) {
            return value;
        }
        if (value instanceof List) {
            List listVal = (List)value;
            for (int i = 0; i < listVal.size(); ++i) {
                listVal.set(i, POSJDBCQueryRunner.sqlValue(listVal.get(i)));
            }
            return listVal;
        }
        if (value instanceof UUID) {
            UUID uniqueId = (UUID)value;
            return POSJDBCQueryRunner.toBytes(uniqueId);
        }
        return value;
    }

    private static byte[] toBytes(UUID uuid) {
        return ByteBuffer.allocate(16).putLong(uuid.getMostSignificantBits()).putLong(uuid.getLeastSignificantBits()).array();
    }

    private static class NamedJDBParametersSetter {
        private List<String> fields = new ArrayList<String>();
        private String modifiedQuery;

        public NamedJDBParametersSetter(String query) {
            int pos;
            while ((pos = ((String)query).indexOf("{")) != -1) {
                int end = ((String)query).substring(pos).indexOf("}");
                end = end == -1 ? ((String)query).length() : (end += pos);
                this.fields.add(((String)query).substring(pos + 1, end));
                query = ((String)query).substring(0, pos) + "?" + ((String)query).substring(end + 1);
            }
            this.modifiedQuery = query;
        }

        public String getModifiedQuery() {
            return this.modifiedQuery;
        }

        public void setParameters(Map<String, Object> parameters, PreparedStatement statement) throws SQLException {
            for (Map.Entry<String, Object> param : parameters.entrySet()) {
                for (int i = 0; i < this.fields.size(); ++i) {
                    if (!ObjectChecker.areEqual((Object)this.fields.get(i), (Object)param.getKey())) continue;
                    POSJDBCQueryRunner.setParameterValue(statement, i + 1, param.getValue());
                }
            }
        }
    }
}

