/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.application;

import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.modules.namapos.enums.POSProcedures;
import com.namasoft.modules.namapos.enums.POSSecurityCapability;
import com.namasoft.namacontrols.NamaButton;
import com.namasoft.pos.application.POSResourcesUtil;
import com.namasoft.pos.application.POSSlideMenu;
import com.namasoft.pos.util.POSSecurityUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javafx.scene.control.Control;

public class POSMenuButton
extends NamaButton {
    private boolean userHasBtnActionCapability = true;
    private String textId;
    private String shortcut;
    private String arabicText;
    private String englishText;
    private List<Control> nextBtns;
    private POSSlideMenu slideMenu;

    public POSMenuButton(String text, String shortcut_, List<Control> btns, POSSlideMenu menu) {
        super(POSResourcesUtil.id(text, new Object[0]) + (String)(ObjectChecker.isEmptyOrNull((Object)shortcut_) ? "" : " - " + POSResourcesUtil.id(shortcut_, new Object[0])));
        this.textId = text;
        this.shortcut = shortcut_;
        this.arabicText = POSResourcesUtil.idToArabic(text, new Object[0]);
        this.englishText = POSResourcesUtil.idToEnglish(text, new Object[0]);
        if (ObjectChecker.isNotEmptyOrNull(btns)) {
            this.nextBtns = new ArrayList<Control>(btns);
        }
        this.slideMenu = menu;
        this.setWrapText(true);
        this.setId("menu-child");
        if (ObjectChecker.areAllNotEmptyOrNull((Object[])new Object[]{this.nextBtns, this.slideMenu})) {
            this.setOnAction(event -> {
                this.slideMenu.fillContainer(this.nextBtns.stream().filter(b -> b instanceof POSMenuButton && ((POSMenuButton)b).canBeAddedToMenu()).collect(Collectors.toList()));
                this.slideMenu.addToBreadCrumbs(this);
            });
        }
    }

    public POSMenuButton(String text, List<Control> btns, POSSlideMenu menu) {
        this(text, null, btns, menu);
    }

    public POSMenuButton(POSProcedures text) {
        this(text.name(), null, null, null);
    }

    public POSMenuButton(String text) {
        this(text, null, null, null);
    }

    public POSMenuButton(POSProcedures text, String shortcut) {
        this(text.name(), shortcut, null, null);
    }

    public POSMenuButton(POSProcedures text, String shortcut, POSSecurityCapability securityCapability) {
        this(text, shortcut);
        if (POSSecurityUtil.userCan(securityCapability).isFailed().booleanValue() && ObjectChecker.isFalseOrNull((Boolean)POSResourcesUtil.fetchPOSConfig().getDoNotHideFieldsIfUserHasNotCapability())) {
            this.userHasBtnActionCapability = false;
        }
    }

    public POSMenuButton(POSProcedures text, POSSecurityCapability securityCapability) {
        this(text, null, securityCapability);
    }

    public boolean canBeAddedToMenu() {
        return ObjectChecker.isTrue((Boolean)this.userHasBtnActionCapability);
    }

    public String getTextId() {
        return this.textId;
    }

    public String getArabicText() {
        return this.arabicText;
    }

    public String getEnglishText() {
        return this.englishText;
    }

    public List<Control> getNextBtns() {
        return this.nextBtns;
    }
}

