/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.application;

import com.namasoft.common.flatobjects.LocalDateUtils;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.modules.namapos.enums.POSSalesHeaderField;
import com.namasoft.modules.namapos.enums.POSSecurityCapability;
import com.namasoft.modules.namapos.enums.PosSalesGridField;
import com.namasoft.namacontrols.NamaBorderPane;
import com.namasoft.namacontrols.NamaHBox;
import com.namasoft.namacontrols.NamaLabel;
import com.namasoft.namacontrols.NamaSearchBox;
import com.namasoft.namacontrols.NamaTextField;
import com.namasoft.namacontrols.NamaVBox;
import com.namasoft.namacontrols.POSSettingsUtil;
import com.namasoft.pos.application.AbsPosSalesScreen;
import com.namasoft.pos.application.BorderPaneCreator;
import com.namasoft.pos.application.POSDocumentType;
import com.namasoft.pos.application.POSNewCustomHeader;
import com.namasoft.pos.application.POSResourcesUtil;
import com.namasoft.pos.application.POSSubsidiaryBox;
import com.namasoft.pos.application.POSTotalsShowPanel;
import com.namasoft.pos.application.POSUISettingsUtil;
import com.namasoft.pos.application.PosScene;
import com.namasoft.pos.application.favouriteitems.FavouritesContainerBuilder;
import com.namasoft.pos.displayPole.DisplayPoleConnectorUtil;
import com.namasoft.pos.domain.AbsPOSSales;
import com.namasoft.pos.domain.PosUISettingsOptions;
import com.namasoft.pos.domain.WritalblePOSFile;
import com.namasoft.pos.domain.details.AbsPOSFieldLine;
import com.namasoft.pos.domain.entities.POSRegistery;
import com.namasoft.pos.domain.valueobjects.PosUiBasicInfo;
import com.namasoft.pos.util.POSScreenSettings;
import com.namasoft.pos.util.POSSecurityUtil;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.control.TableColumn;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javafx.util.Duration;

public class POSNewSalesScreen
extends AbsPosSalesScreen {
    private GridPane basicPane;
    private GridPane headerGrid;
    private NamaHBox mainHeaderFieldsPane;
    private Pane container;
    private GridPane mainContainer;
    private VBox moreContainer;
    private FavouritesContainerBuilder favouritesContainerBuilder;
    private POSNewCustomHeader customHeader;
    public NamaVBox favouritesContainer;
    private NamaHBox discountBox;
    private NamaVBox favOrHeaderPane = new NamaVBox();
    private HashMap<String, List<Node>> salesFieldsMap = new HashMap();

    @Override
    public void defineControllers() {
        super.defineControllers();
        this.discountBox = new NamaHBox(new Node[]{this.discountPercentTextField, this.discountValTextField});
        Class<?> klass = this.fetchDocumentClass();
        this.customerAddressLabel = new NamaLabel(POSResourcesUtil.id(klass, "customerAddress"));
        this.salesReturnCodeText = new NamaLabel(POSResourcesUtil.id(klass, "code"));
        this.tableLabel = new NamaLabel(POSResourcesUtil.id(klass, "table"));
        this.priceClassifier1Label = new NamaLabel(POSResourcesUtil.id(klass, "priceClassifier1"));
        this.priceClassifier2Label = new NamaLabel(POSResourcesUtil.id(klass, "priceClassifier2"));
        this.priceClassifier3Label = new NamaLabel(POSResourcesUtil.id(klass, "priceClassifier3"));
        this.priceClassifier4Label = new NamaLabel(POSResourcesUtil.id(klass, "priceClassifier4"));
        this.priceClassifier5Label = new NamaLabel(POSResourcesUtil.id(klass, "priceClassifier5"));
        this.invoiceClassificationLabel = new NamaLabel(POSResourcesUtil.id(klass, "invoiceClassification"));
        this.returnReasonLabel = new NamaLabel(POSResourcesUtil.id(klass, "returnReason"));
        this.customer = new NamaLabel(POSResourcesUtil.id(klass, "Customer"));
        this.salesMan = new NamaLabel(POSResourcesUtil.id(klass, "salesMan"));
        this.subsidiaryLabel = new NamaLabel(POSResourcesUtil.id("subsidiary", new Object[0]));
        this.addressRegionLabel = new NamaLabel(POSResourcesUtil.id("addressRegion", new Object[0]));
        this.driverLabel = new NamaLabel(POSResourcesUtil.id("driver", new Object[0]));
        this.reservationLabel = new NamaLabel(POSResourcesUtil.id("Reservation", new Object[0]));
        this.receiptSrcLabel = new NamaLabel(POSResourcesUtil.id("receiptSrc", new Object[0]));
        this.scrapSrcLabel = new NamaLabel(POSResourcesUtil.id("scrapSrc", new Object[0]));
        this.shortfallsSrcLabel = new NamaLabel(POSResourcesUtil.id("shortfallsSrc", new Object[0]));
        this.remainingAmountLabel = new NamaLabel(POSResourcesUtil.id("remainingCash", new Object[0]));
        this.discount2Text = new NamaLabel(POSResourcesUtil.id(klass, "disc2Value"));
        this.totalPrice = new NamaLabel(POSResourcesUtil.id(klass, "total"));
        this.currency = new NamaLabel(POSResourcesUtil.id(klass, "Currency"));
        this.wareLabel = new NamaLabel(POSResourcesUtil.id(klass, "Warehouse-Location"));
        this.itemCode = new NamaLabel(POSResourcesUtil.id(klass, "itemCode "));
        this.customerCode = new NamaLabel(POSResourcesUtil.id("customerCode", new Object[0]));
        this.invoiceCode = new NamaLabel("");
        this.tableLabel = new NamaLabel(POSResourcesUtil.id(klass, "table"));
        this.n5Label = new NamaLabel(POSResourcesUtil.id(klass, "n5"));
        this.n4Label = new NamaLabel(POSResourcesUtil.id(klass, "n4"));
        this.n3Label = new NamaLabel(POSResourcesUtil.id(klass, "n3"));
        this.n2Label = new NamaLabel(POSResourcesUtil.id(klass, "n2"));
        this.n1Label = new NamaLabel(POSResourcesUtil.id(klass, "n1"));
        this.itemsValueLabel = new NamaLabel(POSResourcesUtil.id(klass, "ItemsPrice"));
        this.description1Label = new NamaLabel(POSResourcesUtil.id(klass, "description1"));
        this.description2Label = new NamaLabel(POSResourcesUtil.id(klass, "description2"));
        this.description3Label = new NamaLabel(POSResourcesUtil.id(klass, "description3"));
        this.description4Label = new NamaLabel(POSResourcesUtil.id(klass, "description4"));
        this.description5Label = new NamaLabel(POSResourcesUtil.id(klass, "description5"));
        this.date1Label = new NamaLabel(POSResourcesUtil.id(klass, "date1"));
        this.date2Label = new NamaLabel(POSResourcesUtil.id(klass, "date2"));
        this.date3Label = new NamaLabel(POSResourcesUtil.id(klass, "date3"));
        this.date4Label = new NamaLabel(POSResourcesUtil.id(klass, "date4"));
        this.date5Label = new NamaLabel(POSResourcesUtil.id(klass, "date5"));
        this.remarksLabel = new NamaLabel(POSResourcesUtil.id(klass, "remarks"));
        this.fromTimeLabel = new NamaLabel(POSResourcesUtil.id(klass, "fromTime"));
        this.toTimeLabel = new NamaLabel(POSResourcesUtil.id(klass, "toTime"));
        this.reservationDateLabel = new NamaLabel(POSResourcesUtil.id(klass, "reservationDate"));
        this.reservationAmountLabel = new NamaLabel(POSResourcesUtil.id(klass, "reservationAmount"));
        this.deductionPercentLabel = new NamaLabel(POSResourcesUtil.id(klass, "deductionPercent"));
        this.deductionValueLabel = new NamaLabel(POSResourcesUtil.id(klass, "deductionValue"));
        this.netValueLabel = new NamaLabel(POSResourcesUtil.id(klass, "netValue"));
        this.deliveryTimeLabel = new NamaLabel(POSResourcesUtil.id(klass, "deliveryTime"));
        this.deliveryDateLabel = new NamaLabel(POSResourcesUtil.id(klass, "deliveryDate"));
        this.discsValueLabel = new NamaLabel(POSResourcesUtil.id(klass, "ItemsDiscountsAmount"));
        this.taxsValueLabel = new NamaLabel(POSResourcesUtil.id(klass, "ItemsTaxAmount"));
        this.docCategoryLabel = new NamaLabel(POSResourcesUtil.id(klass, "DocCategory"));
        this.warehouseLabel = new NamaLabel(POSResourcesUtil.id(klass, "Warehouse"));
        this.locatorLabel = new NamaLabel(POSResourcesUtil.id(klass, "Locator"));
        this.fromWarehouseLabel = new NamaLabel(POSResourcesUtil.id("fromWarehouse", new Object[0]));
        this.fromLocatorLabel = new NamaLabel(POSResourcesUtil.id("location", new Object[0]));
        this.toWarehouseLabel = new NamaLabel(POSResourcesUtil.id("toWarehouse", new Object[0]));
        this.toLocatorLabel = new NamaLabel(POSResourcesUtil.id("toLocation", new Object[0]));
    }

    public boolean doNotAddFavourites() {
        POSRegistery posRegistery = POSResourcesUtil.fetchMainRegister();
        if (ObjectChecker.isAnyEmptyOrNull((Object[])new Object[]{posRegistery, posRegistery.getUiSettings()})) {
            return false;
        }
        PosUiBasicInfo posUiBasicInfo = POSUISettingsUtil.basicUIInfoForTypes(this.documentType());
        if (ObjectChecker.isEmptyOrNull((Object)posUiBasicInfo)) {
            return false;
        }
        return ObjectChecker.isTrue((Boolean)posUiBasicInfo.getDoNotAddFavouritesPart());
    }

    @Override
    public FavouritesContainerBuilder getFavouritesContainerBuilder() {
        if (this.doNotAddFavourites()) {
            return null;
        }
        return this.favouritesContainerBuilder;
    }

    public static double screenWidth() {
        Rectangle2D primScreenBounds = Screen.getPrimary().getVisualBounds();
        return primScreenBounds.getWidth();
    }

    protected GridPane createMainTabContainer(Stage stage) {
        this.defineControllersInfo();
        this.customHeader = new POSNewCustomHeader(this);
        this.showPane = new POSTotalsShowPanel(this);
        this.posSubsidiaryBox = new POSSubsidiaryBox(this);
        this.createItemsTable();
        GridPane.setVgrow((Node)this.showPane, (Priority)Priority.ALWAYS);
        GridPane.setHgrow((Node)this.showPane, (Priority)Priority.ALWAYS);
        this.showPane.prefWidthProperty().bind((ObservableValue)stage.widthProperty().divide(40));
        this.createFavouriteBox();
        this.createHeaderBox();
        int row = 0;
        NamaHBox headerTitlePane = new NamaHBox(new Node[]{new NamaLabel("invoiceData")});
        headerTitlePane.setId("invoice-header-title-pane");
        this.headerGrid.add((Node)headerTitlePane, 0, row++);
        HBox customerBtns = new HBox();
        customerBtns.setId("customer-buttons-pane");
        if (!POSSecurityUtil.userCan(POSSecurityCapability.CanAddCustomer).isFailed().booleanValue()) {
            customerBtns.getChildren().add((Object)this.addCustomerBtn);
        }
        if (!POSSecurityUtil.userCan(POSSecurityCapability.CanEditCustomer).isFailed().booleanValue()) {
            customerBtns.getChildren().add((Object)this.editCustomerBtn);
        }
        if (customerBtns.getChildren().size() > 0) {
            this.headerGrid.add((Node)customerBtns, 0, row++);
        }
        GridPane.setColumnSpan((Node)customerBtns, (Integer)Integer.MAX_VALUE);
        this.headerGrid.add((Node)this.headerRightPaneGrid, 0, row++);
        this.headerGrid.autosize();
        GridPane.setHgrow((Node)this.headerGrid, (Priority)Priority.ALWAYS);
        this.constructMainPageGrid();
        return this.mainContainer;
    }

    private void constructMainPageGrid() {
        double favoritesWidthPercent = POSUISettingsUtil.favoritesWidthPercent(this);
        boolean isTraditionalMode = ObjectChecker.isTrue((String)POSScreenSettings.getProperty("traditionalMode"));
        if (!isTraditionalMode) {
            favoritesWidthPercent = Math.max(favoritesWidthPercent, (double)(POSUISettingsUtil.basicUIInfoForTypes(this.docType).getColsCountPerRow() * 18));
        }
        ColumnConstraints col1 = new ColumnConstraints();
        col1.setPercentWidth(favoritesWidthPercent);
        ColumnConstraints col2 = new ColumnConstraints();
        col2.setPercentWidth(100.0 - favoritesWidthPercent);
        this.mainContainer.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{col1, col2});
        if (isTraditionalMode && this.doNotAddFavourites()) {
            this.customHeader.setId("custom-header-in-traditional-mode");
            POSSettingsUtil.setVGrowAlways((List<Node>)this.customHeader.getChildren());
            this.mainContainer.add((Node)this.customHeader, 0, 0);
            this.mainContainer.add((Node)this.headerGrid, 1, 0);
            this.mainContainer.add((Node)this.salesTable, 0, 1, Integer.MAX_VALUE, 1);
        } else {
            NamaVBox rightSide = this.createRightSide(isTraditionalMode);
            NamaVBox leftSide = this.createLeftSide(isTraditionalMode);
            this.mainContainer.add((Node)leftSide, 0, 0);
            this.mainContainer.add((Node)rightSide, 1, 0);
        }
    }

    private NamaVBox createRightSide(boolean isTraditionalMode) {
        NamaVBox rightSide = new NamaVBox();
        rightSide.setId("right-side");
        GridPane.setVgrow((Node)rightSide, (Priority)Priority.ALWAYS);
        GridPane.setHgrow((Node)rightSide, (Priority)Priority.ALWAYS);
        if (isTraditionalMode) {
            rightSide.getChildren().addAll((Object[])new Node[]{this.headerGrid, this.salesTable});
        } else {
            this.mainHeaderFieldsPane = new NamaHBox(this.salesFieldsMap(POSSalesHeaderField.Code.name()));
            this.mainHeaderFieldsPane.setId("invoice-main-header-fields-pane");
            this.mainHeaderFieldsPane.getChildren().addAll(this.salesFieldsMap(POSSalesHeaderField.ItemCode.name()));
            POSSettingsUtil.setHGrowAlways((List<Node>)this.mainHeaderFieldsPane.getChildren());
            rightSide.getChildren().addAll((Object[])new Node[]{this.mainHeaderFieldsPane, this.salesTable});
        }
        return rightSide;
    }

    private NamaVBox createLeftSide(boolean isTraditionalMode) {
        NamaVBox leftSide = new NamaVBox();
        leftSide.setId("left-side");
        GridPane.setVgrow((Node)leftSide, (Priority)Priority.ALWAYS);
        if (isTraditionalMode) {
            if (this.doNotAddFavourites()) {
                return null;
            }
            leftSide.getChildren().addAll((Object[])new Node[]{this.customHeader, this.favouritesContainer});
        } else {
            NamaVBox.setVgrow((Node)this.headerGrid, (Priority)Priority.ALWAYS);
            GridPane.setVgrow((Node)this.headerRightPaneGrid, (Priority)Priority.ALWAYS);
            this.favOrHeaderPane.getChildren().add((Object)this.headerGrid);
            NamaVBox.setVgrow((Node)this.favOrHeaderPane, (Priority)Priority.ALWAYS);
            leftSide.getChildren().addAll((Object[])new Node[]{this.customHeader, this.favOrHeaderPane, this.showPane});
        }
        return leftSide;
    }

    public void switchToMore() {
        this.mainContainer.getChildren().clear();
        this.mainContainer.add((Node)this.moreContainer, 0, 0);
        GridPane.setColumnSpan((Node)this.moreContainer, (Integer)Integer.MAX_VALUE);
        this.moreContainer.setPrefHeight(Screen.getPrimary().getVisualBounds().getHeight() * 75.0 / 100.0);
    }

    public void switchToHome() {
        this.mainContainer.getChildren().clear();
        this.constructMainPageGrid();
    }

    @Override
    protected Node createSalesPage(Stage stage) {
        this.container = new NamaHBox();
        this.mainContainer = new GridPane();
        this.mainContainer.setId("main-container");
        NamaHBox.setHgrow((Node)this.mainContainer, (Priority)Priority.ALWAYS);
        this.headerGrid = new GridPane();
        this.headerGrid.setId("invoice-header-pane");
        this.createMainTabContainer(stage);
        this.createBasicFieldsPane();
        this.changeHeaderGridDisablility(false);
        this.discountFieldsEvents();
        this.wireDescriptionAndDatesAndNEvents();
        this.container.getChildren().add((Object)this.mainContainer);
        return this.container;
    }

    private void wireDescriptionAndDatesAndNEvents() {
        this.n1.textProperty().addListener(this.createSimpleDecimalSetter(WritalblePOSFile::setN1));
        this.n2.textProperty().addListener(this.createSimpleDecimalSetter(WritalblePOSFile::setN2));
        this.n3.textProperty().addListener(this.createSimpleDecimalSetter(WritalblePOSFile::setN3));
        this.n4.textProperty().addListener(this.createSimpleDecimalSetter(WritalblePOSFile::setN4));
        this.n5.textProperty().addListener(this.createSimpleDecimalSetter(WritalblePOSFile::setN5));
        this.description1.textProperty().addListener(this.createSimpleStringSetter(WritalblePOSFile::setDescription1));
        this.description2.textProperty().addListener(this.createSimpleStringSetter(WritalblePOSFile::setDescription2));
        this.description3.textProperty().addListener(this.createSimpleStringSetter(WritalblePOSFile::setDescription3));
        this.description4.textProperty().addListener(this.createSimpleStringSetter(WritalblePOSFile::setDescription4));
        this.description5.textProperty().addListener(this.createSimpleStringSetter(WritalblePOSFile::setDescription5));
        this.date1.valueProperty().addListener(this.createSimpleDateSetter(WritalblePOSFile::setDate1));
        this.date2.valueProperty().addListener(this.createSimpleDateSetter(WritalblePOSFile::setDate2));
        this.date3.valueProperty().addListener(this.createSimpleDateSetter(WritalblePOSFile::setDate3));
        this.date4.valueProperty().addListener(this.createSimpleDateSetter(WritalblePOSFile::setDate4));
        this.date5.valueProperty().addListener(this.createSimpleDateSetter(WritalblePOSFile::setDate5));
        this.deliveryDate.valueProperty().addListener(this.createSimpleDateSetter(AbsPOSSales::setDeliveryDate));
        this.deliveryTime.textProperty().addListener(this.createSimpleStringSetter(AbsPOSSales::setStrDeliveryTime));
        this.remarks.textProperty().addListener(this.createSimpleStringSetter(WritalblePOSFile::setRemarks));
    }

    private ChangeListener<String> createSimpleDecimalSetter(BiConsumer<AbsPOSSales, BigDecimal> setter) {
        return (observable, oldValue, newValue) -> {
            if (this.renderingExistDoc) {
                return;
            }
            setter.accept(this.salesDoc, ObjectChecker.tryParseDecimal((String)newValue));
        };
    }

    private ChangeListener<String> createSimpleStringSetter(BiConsumer<AbsPOSSales, String> setter) {
        return (observable, oldValue, newValue) -> {
            if (this.renderingExistDoc) {
                return;
            }
            setter.accept(this.salesDoc, (String)newValue);
        };
    }

    private ChangeListener<LocalDate> createSimpleDateSetter(BiConsumer<AbsPOSSales, Date> setter) {
        return (observable, oldValue, newValue) -> {
            if (this.renderingExistDoc) {
                return;
            }
            setter.accept(this.salesDoc, LocalDateUtils.localDateToDate((LocalDate)newValue));
        };
    }

    @Override
    protected List<Node> basicContainers() {
        ArrayList<GridPane> basicContainers = new ArrayList<GridPane>(Arrays.asList(this.basicPane, this.headerRightPaneGrid));
        if (this.mainHeaderFieldsPane != null) {
            basicContainers.add((GridPane)this.mainHeaderFieldsPane);
        }
        return basicContainers;
    }

    protected VBox createHeaderBox() {
        this.moreContainer = new VBox();
        this.headerRightPaneGrid = new GridPane();
        this.headerRightPaneGrid.setId("invoice-header-fields-pane");
        this.showPane.prefWidthProperty().bind((ObservableValue)this.stage.widthProperty().divide(25));
        if (this.invCodeTextField instanceof NamaSearchBox) {
            this.invoiceCodeBox.getChildren().clear();
            this.invoiceCodeBox.getChildren().addAll((Object[])new Node[]{this.invCodeTextField});
            this.salesReturnCodeTextField.setText(this.salesDoc.getCode());
            this.salesReturnCodeTextField.setEditable(false);
        }
        if (this.invCodeTextField instanceof NamaTextField) {
            ((NamaTextField)this.invCodeTextField).setText(this.salesDoc.getCode());
        }
        this.currencyBox.getChildren().add((Object)this.currencyName);
        boolean addCurrencyRate = ObjectChecker.isTrue((Boolean)POSUISettingsUtil.getPosUISettingsOptions().getAddCurrencyRateField());
        if (addCurrencyRate) {
            this.currencyName.getCodeBox().setPrefWidth(60.0);
            this.currencyName.getNameBox().setPrefWidth(100.0);
            this.currencyRate.setPrefWidth(80.0);
            this.currencyBox.getChildren().add((Object)this.currencyRate);
        }
        if (POSSecurityUtil.userCan(POSSecurityCapability.CanEditSalesMan).isFailed().booleanValue()) {
            this.salesManCodeTextField.setDisable(true);
        }
        this.itemsValue.setDisable(true);
        this.discsValue.setDisable(true);
        this.taxsValue.setDisable(true);
        List<String> mainPageFields = POSUISettingsUtil.mainLinesForTypes(this.documentType());
        List<String> otherPageFields = POSUISettingsUtil.otherLinesForTypes(this.documentType());
        List allFields = Stream.concat(mainPageFields.stream(), otherPageFields.stream()).distinct().collect(Collectors.toList());
        if (!allFields.contains(POSSalesHeaderField.Code.toString())) {
            mainPageFields.add(0, POSSalesHeaderField.Code.toString());
        }
        if (!allFields.contains(POSSalesHeaderField.Warehouse.toString()) && this.isStockTransfer()) {
            mainPageFields.add(1, POSSalesHeaderField.Warehouse.toString());
        }
        if (!allFields.contains(POSSalesHeaderField.AddressRegion.toString())) {
            POSUISettingsUtil.getPosUISettingsOptions();
            if (PosUISettingsOptions.shouldAddAddressRegionFieldWithDeliveryItem()) {
                mainPageFields.add(mainPageFields.size(), POSSalesHeaderField.AddressRegion.toString());
            }
        }
        if (!allFields.contains(POSSalesHeaderField.Driver.toString())) {
            POSUISettingsUtil.getPosUISettingsOptions();
            if (PosUISettingsOptions.shouldAddDriverFieldWithDeliveryItem()) {
                mainPageFields.add(mainPageFields.size(), POSSalesHeaderField.Driver.toString());
            }
        }
        if (!allFields.contains(POSSalesHeaderField.Reservation.toString()) && this.isInvoice() && ObjectChecker.isTrue((Boolean)POSResourcesUtil.fetchPOSConfig().getUseReservationDoc())) {
            mainPageFields.add(mainPageFields.size(), POSSalesHeaderField.Reservation.toString());
        }
        if (ObjectChecker.isTrue((Boolean)POSResourcesUtil.fetchMainRegister().getCallCenterMode())) {
            mainPageFields.add(mainPageFields.size(), POSSalesHeaderField.SendToRegister.name());
        }
        if (ObjectChecker.isEmptyOrNull(mainPageFields)) {
            this.fillSalesBasicPane();
        } else {
            this.advancedFillSalesFields(mainPageFields, this.headerRightPaneGrid);
        }
        this.headerRightPaneGrid.autosize();
        GridPane.setHgrow((Node)this.headerRightPaneGrid, (Priority)Priority.ALWAYS);
        this.moreContainer.setPadding(new Insets(0.0, 8.0, 0.0, 8.0));
        VBox.setVgrow((Node)this.moreContainer, (Priority)Priority.ALWAYS);
        POSResourcesUtil.alignLabels(new Node[]{this.salesReturnCodeTextField, this.invoiceCode, this.customerAddressLabel, this.customer, this.customerCode, this.tableLabel, this.taxsValueLabel, this.priceClassifier1Label, this.priceClassifier2Label, this.priceClassifier3Label, this.priceClassifier4Label, this.priceClassifier5Label, this.currency, this.wareLabel, this.totalPrice, this.docCategoryLabel, this.itemsValueLabel, this.discsValueLabel, this.salesMan, this.discountText, this.itemCode, this.warehouseLabel, this.locatorLabel, this.n1Label, this.n2Label, this.n3Label, this.n4Label, this.n5Label, this.description1Label, this.description2Label, this.description3Label, this.description4Label, this.description5Label, this.date1Label, this.date2Label, this.date3Label, this.date4Label, this.date5Label, this.remarksLabel, this.deliveryDateLabel, this.deliveryTimeLabel});
        return this.moreContainer;
    }

    private void createBasicFieldsPane() {
        this.basicPane = new GridPane();
        this.basicPane.setHgap(8.0);
        this.basicPane.setVgap(3.0);
        this.basicPane.setPadding(new Insets(10.0));
        List<String> otherPageFields = POSUISettingsUtil.otherLinesForTypes(this.documentType());
        if (ObjectChecker.isNotEmptyOrNull(otherPageFields)) {
            this.advancedFillSalesFields(otherPageFields, this.basicPane);
        }
        GridPane.setColumnSpan((Node)this.basicPane, (Integer)1);
        this.moreContainer.getChildren().addAll((Object[])new Node[]{this.basicPane});
    }

    public void fillSalesTableCols(ObservableList observableList) {
        List<? extends AbsPOSFieldLine> salesGridFields = POSUISettingsUtil.gridLinesForTypes(this.documentType());
        if (ObjectChecker.isEmptyOrNull(salesGridFields)) {
            super.fillSalesTableCols(observableList);
        } else {
            this.advancedFillSalesTableCols();
        }
        this.addReorderListenerToTable();
    }

    private void advancedFillSalesTableCols() {
        List<? extends AbsPOSFieldLine> salesGridFields = POSUISettingsUtil.gridLinesForTypes(this.documentType());
        boolean hasShoftcutsCol = false;
        for (AbsPOSFieldLine absPOSFieldLine : salesGridFields) {
            if (ObjectChecker.areEqual((Object)absPOSFieldLine.getField(), (Object)PosSalesGridField.ShortCuts.toString())) {
                hasShoftcutsCol = true;
            }
            TableColumn col = this.idsWithCols(absPOSFieldLine.getField());
            double colWidth = POSUISettingsUtil.calcWidthFromSize(absPOSFieldLine.getWidthSize());
            if (ObjectChecker.isNotEmptyOrZero((Double)colWidth)) {
                col.setPrefWidth(colWidth);
            }
            this.salesTable.getColumns().add((Object)col);
        }
        if (!hasShoftcutsCol) {
            this.salesTable.getColumns().add((Object)this.idsWithCols(PosSalesGridField.ShortCuts.toString()));
        }
        if (POSUISettingsUtil.doNoAddSalesLineButtons()) {
            this.salesTable.getColumns().remove((Object)this.idsWithCols(PosSalesGridField.ShortCuts.toString()));
        }
    }

    private void advancedFillSalesFields(List<String> fields, GridPane gridPane) {
        int salesColsCount = 2;
        PosUiBasicInfo posUiBasicInfo = POSUISettingsUtil.basicUIInfoForTypes(this.documentType());
        if (ObjectChecker.isNotEmptyOrNull((Object)posUiBasicInfo) && ObjectChecker.isNotEmptyOrZero((Integer)posUiBasicInfo.getColsCountPerRow())) {
            salesColsCount = posUiBasicInfo.getColsCountPerRow();
        }
        for (int i = 0; i < salesColsCount; ++i) {
            ColumnConstraints col = new ColumnConstraints();
            col.setPercentWidth((double)(100 / salesColsCount));
            gridPane.getColumnConstraints().add((Object)col);
        }
        int row = 0;
        int col = 0;
        for (int i = 0; i < fields.size(); ++i) {
            List<Node> nodesToAdd;
            if (!ObjectChecker.isTrue((String)POSScreenSettings.getProperty("traditionalMode")) && ObjectChecker.isAnyEqualToFirst((Object)fields.get(i), (Object[])new String[]{POSSalesHeaderField.Code.name(), POSSalesHeaderField.ItemCode.name()}) || ObjectChecker.areEqual((Object)fields.get(i), (Object)POSSalesHeaderField.Remarks.name()) || ObjectChecker.isEmptyOrNull(nodesToAdd = this.salesFieldsMap(fields.get(i)))) continue;
            POSSettingsUtil.setHGrowAlways(nodesToAdd);
            int nodesSize = nodesToAdd.size();
            for (int nodeIndex = 0; nodeIndex < nodesSize; ++nodeIndex) {
                if (col == salesColsCount) {
                    col = 0;
                    ++row;
                }
                gridPane.add(nodesToAdd.get(nodeIndex), col, row);
                ++col;
            }
        }
        if (fields.contains(POSSalesHeaderField.Remarks.name())) {
            if (col != 0) {
                ++row;
            }
            gridPane.add(this.salesFieldsMap(POSSalesHeaderField.Remarks.name()).get(0), 0, row, salesColsCount, 1);
        }
    }

    @Override
    protected void clearFieldsMaps() {
        this.salesFieldsMap.clear();
        this.idsWithCols.clear();
    }

    private List<Node> salesFieldsMap(String fieldId) {
        if (ObjectChecker.isNotEmptyOrNull(this.salesFieldsMap)) {
            return (List)ObjectChecker.getFirstNotNullObj((Object[])new List[]{this.salesFieldsMap.get(fieldId + "_#_" + String.valueOf((Object)this.docType)), this.salesFieldsMap.get(fieldId)});
        }
        NamaHBox fromTimeBox = new NamaHBox(new Node[]{this.fromTimeLabel, this.fromTime});
        NamaHBox toTimeBox = new NamaHBox(new Node[]{this.toTimeLabel, this.toTime});
        NamaHBox reservationDateBox = new NamaHBox(new Node[]{this.reservationDateLabel, this.reservationDate});
        this.salesFieldsMap.put(String.valueOf(POSSalesHeaderField.ReservationTimes) + "_#_" + String.valueOf((Object)POSDocumentType.POSOrderReservation), Arrays.asList(new Node[]{fromTimeBox, toTimeBox, reservationDateBox}));
        this.salesFieldsMap.put(String.valueOf(POSSalesHeaderField.ReservationTimes) + "_#_" + String.valueOf((Object)POSDocumentType.POSCancelReservation), Arrays.asList(new Node[]{fromTimeBox, toTimeBox, reservationDateBox}));
        this.salesFieldsMap.put(String.valueOf(POSSalesHeaderField.ReservationDeduction) + "_#_" + String.valueOf((Object)POSDocumentType.POSCancelReservation), Arrays.asList(new Node[]{new NamaHBox(new Node[]{this.deductionPercentLabel, this.deductionPercent}), new NamaHBox(new Node[]{this.deductionValueLabel, this.deductionValue})}));
        this.salesFieldsMap.put(String.valueOf(POSSalesHeaderField.ReservationNetValue) + "_#_" + String.valueOf((Object)POSDocumentType.POSCancelReservation), Arrays.asList(new Node[]{new NamaHBox(new Node[]{this.netValueLabel, this.netValue})}));
        NamaHBox reservationAmountBox = new NamaHBox(new Node[]{this.reservationAmountLabel, this.reservationAmount});
        this.salesFieldsMap.put(String.valueOf(POSSalesHeaderField.ReservationAmount) + "_#_" + String.valueOf((Object)POSDocumentType.Invoice), Arrays.asList(new Node[]{reservationAmountBox}));
        this.salesFieldsMap.put(String.valueOf(POSSalesHeaderField.ReservationAmount) + "_#_" + String.valueOf((Object)POSDocumentType.POSOrderReservation), Arrays.asList(new Node[]{reservationAmountBox}));
        this.salesFieldsMap.put(String.valueOf(POSSalesHeaderField.ReservationAmount) + "_#_" + String.valueOf((Object)POSDocumentType.POSCancelReservation), Arrays.asList(new Node[]{reservationAmountBox}));
        NamaHBox codeBox = new NamaHBox(new Node[]{this.invoiceCode, this.invCodeTextField});
        NamaHBox returnOrReplaceCodeBox = new NamaHBox(new Node[]{this.salesReturnCodeText, this.salesReturnCodeTextField});
        this.salesFieldsMap.put(POSSalesHeaderField.Code.toString() + "_#_" + String.valueOf((Object)POSDocumentType.Return), Arrays.asList(new Node[]{returnOrReplaceCodeBox, codeBox}));
        this.salesFieldsMap.put(POSSalesHeaderField.Code.toString() + "_#_" + String.valueOf((Object)POSDocumentType.Replacement), Arrays.asList(new Node[]{returnOrReplaceCodeBox, codeBox}));
        this.salesFieldsMap.put(POSSalesHeaderField.Code.toString(), Arrays.asList(new Node[]{codeBox}));
        this.salesFieldsMap.put(POSSalesHeaderField.GoToHeldInvoice.toString(), Arrays.asList(new Node[]{new NamaHBox(new Node[]{this.goToHeldInvoiceLabel, this.goToHeldInvoiceTextField})}));
        this.salesFieldsMap.put(POSSalesHeaderField.Warehouse.toString() + "_#_" + String.valueOf((Object)POSDocumentType.StockTransferReq), Arrays.asList(new Node[]{new NamaHBox(new Node[]{this.fromWarehouseLabel, this.fromWarehouse}), new NamaHBox(new Node[]{this.toWarehouseLabel, this.toWarehouse})}));
        this.salesFieldsMap.put(POSSalesHeaderField.Warehouse.toString(), Arrays.asList(new Node[]{new NamaHBox(new Node[]{this.warehouseLabel, this.warehouse})}));
        this.salesFieldsMap.put(POSSalesHeaderField.Locator.toString() + "_#_" + String.valueOf((Object)POSDocumentType.StockTransferReq), Arrays.asList(new Node[]{new NamaHBox(new Node[]{this.fromLocatorLabel, this.location}), new NamaHBox(new Node[]{this.toLocatorLabel, this.toLocation})}));
        this.salesFieldsMap.put(POSSalesHeaderField.Locator.toString(), Arrays.asList(new Node[]{new NamaHBox(new Node[]{this.locatorLabel, this.location})}));
        this.salesFieldsMap.put(POSSalesHeaderField.Customer.toString(), Arrays.asList(new Node[]{new NamaHBox(new Node[]{this.customerCode, this.customerCodeTextField})}));
        this.salesFieldsMap.put(POSSalesHeaderField.Currency.toString(), Arrays.asList(new Node[]{new NamaHBox(new Node[]{this.currency, this.currencyName})}));
        this.salesFieldsMap.put(POSSalesHeaderField.TableSearchField.toString(), Arrays.asList(new Node[]{new NamaHBox(new Node[]{this.searchField, this.posTableFilterField})}));
        this.salesFieldsMap.put(POSSalesHeaderField.SalesMan.toString(), Arrays.asList(new Node[]{new NamaHBox(new Node[]{this.salesMan, this.salesManCodeTextField})}));
        this.salesFieldsMap.put(POSSalesHeaderField.SalesMan.toString() + "_#_" + String.valueOf((Object)POSDocumentType.StockTransferReq), new ArrayList());
        this.salesFieldsMap.put(POSSalesHeaderField.SalesMan.toString() + "_#_" + String.valueOf((Object)POSDocumentType.StockTakingDetails), new ArrayList());
        this.salesFieldsMap.put(POSSalesHeaderField.ItemsPrice.toString(), Arrays.asList(new Node[]{new NamaHBox(new Node[]{this.itemsValueLabel, this.itemsValue})}));
        this.salesFieldsMap.put(POSSalesHeaderField.N1.toString(), Arrays.asList(new Node[]{new NamaHBox(new Node[]{this.n1Label, this.n1})}));
        this.salesFieldsMap.put(POSSalesHeaderField.N2.toString(), Arrays.asList(new Node[]{new NamaHBox(new Node[]{this.n2Label, this.n2})}));
        this.salesFieldsMap.put(POSSalesHeaderField.N3.toString(), Arrays.asList(new Node[]{new NamaHBox(new Node[]{this.n3Label, this.n3})}));
        this.salesFieldsMap.put(POSSalesHeaderField.N4.toString(), Arrays.asList(new Node[]{new NamaHBox(new Node[]{this.n4Label, this.n4})}));
        this.salesFieldsMap.put(POSSalesHeaderField.N5.toString(), Arrays.asList(new Node[]{new NamaHBox(new Node[]{this.n5Label, this.n5})}));
        this.salesFieldsMap.put(POSSalesHeaderField.Description1.toString(), Arrays.asList(new Node[]{new NamaHBox(new Node[]{this.description1Label, this.description1})}));
        this.salesFieldsMap.put(POSSalesHeaderField.Description2.toString(), Arrays.asList(new Node[]{new NamaHBox(new Node[]{this.description2Label, this.description2})}));
        this.salesFieldsMap.put(POSSalesHeaderField.Description3.toString(), Arrays.asList(new Node[]{new NamaHBox(new Node[]{this.description3Label, this.description3})}));
        this.salesFieldsMap.put(POSSalesHeaderField.Description4.toString(), Arrays.asList(new Node[]{new NamaHBox(new Node[]{this.description4Label, this.description4})}));
        this.salesFieldsMap.put(POSSalesHeaderField.Description5.toString(), Arrays.asList(new Node[]{new NamaHBox(new Node[]{this.description5Label, this.description5})}));
        this.salesFieldsMap.put(POSSalesHeaderField.Date1.toString(), Arrays.asList(new Node[]{new NamaHBox(new Node[]{this.date1Label, this.date1})}));
        this.salesFieldsMap.put(POSSalesHeaderField.Date2.toString(), Arrays.asList(new Node[]{new NamaHBox(new Node[]{this.date2Label, this.date2})}));
        this.salesFieldsMap.put(POSSalesHeaderField.Date3.toString(), Arrays.asList(new Node[]{new NamaHBox(new Node[]{this.date3Label, this.date3})}));
        this.salesFieldsMap.put(POSSalesHeaderField.Date4.toString(), Arrays.asList(new Node[]{new NamaHBox(new Node[]{this.date4Label, this.date4})}));
        this.salesFieldsMap.put(POSSalesHeaderField.Date5.toString(), Arrays.asList(new Node[]{new NamaHBox(new Node[]{this.date5Label, this.date5})}));
        this.salesFieldsMap.put(POSSalesHeaderField.Remarks.toString(), Arrays.asList(new Node[]{new NamaHBox(new Node[]{this.remarksLabel, this.remarks})}));
        this.salesFieldsMap.put(POSSalesHeaderField.DeliveryDate.toString(), Arrays.asList(new Node[]{new NamaHBox(new Node[]{this.deliveryDateLabel, this.deliveryDate})}));
        this.salesFieldsMap.put(POSSalesHeaderField.DeliveryTime.toString(), Arrays.asList(new Node[]{new NamaHBox(new Node[]{this.deliveryTimeLabel, this.deliveryTime})}));
        this.salesFieldsMap.put(POSSalesHeaderField.ItemsPrice.toString() + "_#_" + String.valueOf((Object)POSDocumentType.StockTransferReq), new ArrayList());
        this.salesFieldsMap.put(POSSalesHeaderField.ItemsPrice.toString() + "_#_" + String.valueOf((Object)POSDocumentType.StockTakingDetails), new ArrayList());
        this.salesFieldsMap.put(POSSalesHeaderField.DiscountsTotals.toString(), Arrays.asList(new Node[]{new NamaHBox(new Node[]{this.discsValueLabel, this.discsValue})}));
        this.salesFieldsMap.put(POSSalesHeaderField.DiscountsTotals.toString() + "_#_" + String.valueOf((Object)POSDocumentType.StockTransferReq), new ArrayList());
        this.salesFieldsMap.put(POSSalesHeaderField.DiscountsTotals.toString() + "_#_" + String.valueOf((Object)POSDocumentType.StockTakingDetails), new ArrayList());
        this.salesFieldsMap.put(POSSalesHeaderField.TaxesTotals.toString(), Arrays.asList(new Node[]{new NamaHBox(new Node[]{this.taxsValueLabel, this.taxsValue})}));
        this.salesFieldsMap.put(POSSalesHeaderField.TaxesTotals.toString() + "_#_" + String.valueOf((Object)POSDocumentType.StockTransferReq), new ArrayList());
        this.salesFieldsMap.put(POSSalesHeaderField.TaxesTotals.toString() + "_#_" + String.valueOf((Object)POSDocumentType.StockTakingDetails), new ArrayList());
        this.salesFieldsMap.put(POSSalesHeaderField.TotalPrice.toString(), Arrays.asList(new Node[]{new NamaHBox(new Node[]{this.totalPrice, this.totalPriceTextField})}));
        this.salesFieldsMap.put(POSSalesHeaderField.TotalPrice.toString() + "_#_" + String.valueOf((Object)POSDocumentType.StockTransferReq), new ArrayList());
        this.salesFieldsMap.put(POSSalesHeaderField.TotalPrice.toString() + "_#_" + String.valueOf((Object)POSDocumentType.StockTakingDetails), new ArrayList());
        this.salesFieldsMap.put(POSSalesHeaderField.Table.toString(), Arrays.asList(new Node[]{new NamaHBox(new Node[]{this.tableLabel, this.table})}));
        this.salesFieldsMap.put(POSSalesHeaderField.Table.toString() + "_#_" + String.valueOf((Object)POSDocumentType.StockTransferReq), new ArrayList());
        this.salesFieldsMap.put(POSSalesHeaderField.Table.toString() + "_#_" + String.valueOf((Object)POSDocumentType.StockTakingDetails), new ArrayList());
        this.salesFieldsMap.put(POSSalesHeaderField.DocCategory.toString(), Arrays.asList(new Node[]{new NamaHBox(new Node[]{this.docCategoryLabel, this.docCategory})}));
        this.salesFieldsMap.put(POSSalesHeaderField.PriceClassifier1.toString(), Arrays.asList(new Node[]{new NamaHBox(new Node[]{this.priceClassifier1Label, this.priceClassifier1})}));
        this.salesFieldsMap.put(POSSalesHeaderField.PriceClassifier2.toString(), Arrays.asList(new Node[]{new NamaHBox(new Node[]{this.priceClassifier2Label, this.priceClassifier2})}));
        this.salesFieldsMap.put(POSSalesHeaderField.PriceClassifier3.toString(), Arrays.asList(new Node[]{new NamaHBox(new Node[]{this.priceClassifier3Label, this.priceClassifier3})}));
        this.salesFieldsMap.put(POSSalesHeaderField.PriceClassifier4.toString(), Arrays.asList(new Node[]{new NamaHBox(new Node[]{this.priceClassifier4Label, this.priceClassifier4})}));
        this.salesFieldsMap.put(POSSalesHeaderField.PriceClassifier5.toString(), Arrays.asList(new Node[]{new NamaHBox(new Node[]{this.priceClassifier5Label, this.priceClassifier5})}));
        this.salesFieldsMap.put(POSSalesHeaderField.CustomerAddress.toString(), Arrays.asList(new Node[]{new NamaHBox(new Node[]{this.customerAddressLabel, this.customerAddress})}));
        this.salesFieldsMap.put(POSSalesHeaderField.Discount.toString(), Arrays.asList(new Node[]{new NamaHBox(new Node[]{this.discountText, this.discountBox})}));
        this.salesFieldsMap.put(POSSalesHeaderField.Discount.toString() + "_#_" + String.valueOf((Object)POSDocumentType.StockTransferReq), new ArrayList());
        this.salesFieldsMap.put(POSSalesHeaderField.Discount.toString() + "_#_" + String.valueOf((Object)POSDocumentType.StockTakingDetails), new ArrayList());
        this.salesFieldsMap.put(POSSalesHeaderField.ItemCode.toString(), Arrays.asList(new Node[]{new NamaHBox(new Node[]{this.itemCode, this.itemCodeField})}));
        this.salesFieldsMap.put(POSSalesHeaderField.FractionDiscount.toString(), Arrays.asList(new Node[]{new NamaHBox(new Node[]{this.discount2Text, this.discount2ValTextField})}));
        this.salesFieldsMap.put(POSSalesHeaderField.FractionDiscount.toString() + "_#_" + String.valueOf((Object)POSDocumentType.StockTransferReq), new ArrayList());
        this.salesFieldsMap.put(POSSalesHeaderField.FractionDiscount.toString() + "_#_" + String.valueOf((Object)POSDocumentType.StockTakingDetails), new ArrayList());
        this.salesFieldsMap.put(POSSalesHeaderField.InvoiceClassification.toString(), Arrays.asList(new Node[]{new NamaHBox(new Node[]{this.invoiceClassificationLabel, this.invoiceClassification})}));
        this.salesFieldsMap.put(POSSalesHeaderField.ReturnReason.toString(), Arrays.asList(new Node[]{new NamaHBox(new Node[]{this.returnReasonLabel, this.returnReason})}));
        this.salesFieldsMap.put(POSSalesHeaderField.Subsidiary.toString(), Arrays.asList(new Node[]{new NamaHBox(new Node[]{this.subsidiaryLabel, this.posSubsidiaryBox})}));
        this.salesFieldsMap.put(POSSalesHeaderField.Attachment1.toString(), Arrays.asList(new Node[]{new NamaHBox(new Node[]{this.attach1Label, this.attach1})}));
        this.salesFieldsMap.put(POSSalesHeaderField.Attachment2.toString(), Arrays.asList(new Node[]{new NamaHBox(new Node[]{this.attach2Label, this.attach2})}));
        this.salesFieldsMap.put(POSSalesHeaderField.Attachment3.toString(), Arrays.asList(new Node[]{new NamaHBox(new Node[]{this.attach3Label, this.attach3})}));
        this.salesFieldsMap.put(POSSalesHeaderField.Attachment4.toString(), Arrays.asList(new Node[]{new NamaHBox(new Node[]{this.attach4Label, this.attach4})}));
        this.salesFieldsMap.put(POSSalesHeaderField.Attachment5.toString(), Arrays.asList(new Node[]{new NamaHBox(new Node[]{this.attach5Label, this.attach5})}));
        this.salesFieldsMap.put(POSSalesHeaderField.AddressRegion.toString(), Arrays.asList(new Node[]{new NamaHBox(new Node[]{this.addressRegionLabel, this.addressRegion})}));
        this.salesFieldsMap.put(POSSalesHeaderField.Driver.toString(), Arrays.asList(new Node[]{new NamaHBox(new Node[]{this.driverLabel, this.driver})}));
        this.salesFieldsMap.put(POSSalesHeaderField.Reservation.toString(), Arrays.asList(new Node[]{new NamaHBox(new Node[]{this.reservationLabel, this.reservation}), new NamaHBox(new Node[]{this.remainingAmountLabel, this.remainingAmount})}));
        this.salesFieldsMap.put(String.valueOf(POSSalesHeaderField.ReceiptSource) + "_#_" + String.valueOf((Object)POSDocumentType.POSStockReceipt), Arrays.asList(new Node[]{new NamaHBox(new Node[]{this.receiptSrcLabel, this.receiptSrcBox})}));
        this.salesFieldsMap.put(String.valueOf(POSSalesHeaderField.FromDoc) + "_#_" + String.valueOf((Object)POSDocumentType.ScrapDoc), Arrays.asList(new Node[]{new NamaHBox(new Node[]{this.scrapSrcLabel, this.scrapSrcBox})}));
        this.salesFieldsMap.put(String.valueOf(POSSalesHeaderField.FromDoc) + "_#_" + String.valueOf((Object)POSDocumentType.ShortfallsDoc), Arrays.asList(new Node[]{new NamaHBox(new Node[]{this.shortfallsSrcLabel, this.shortfallsSrcBox})}));
        this.salesFieldsMap.put(String.valueOf(POSSalesHeaderField.Ref1) + "_#_" + String.valueOf((Object)POSDocumentType.ShortfallsDoc), Arrays.asList(new Node[]{new NamaHBox(new Node[]{this.shortfallsRef1Box.getRefLabel(), this.shortfallsRef1Box})}));
        this.salesFieldsMap.put(POSSalesHeaderField.SendToRegister.toString(), Arrays.asList(new Node[]{new NamaHBox(new Node[]{this.registerSearchBox.getLabel(), this.registerSearchBox.getField()})}));
        return (List)ObjectChecker.getFirstNotNullObj((Object[])new List[]{this.salesFieldsMap.get(fieldId + "_#_" + String.valueOf((Object)this.docType)), this.salesFieldsMap.get(fieldId)});
    }

    private void fillSalesBasicPane() {
        int r1ColumnsIndex = 1;
        if (!this.isInvoice()) {
            this.headerRightPaneGrid.add((Node)this.salesReturnCodeText, r1ColumnsIndex++, 1);
            this.headerRightPaneGrid.add((Node)this.salesReturnCodeTextField, r1ColumnsIndex++, 1);
            this.headerRightPaneGrid.add((Node)this.invoiceCode, r1ColumnsIndex++, 1);
            this.headerRightPaneGrid.add((Node)this.invoiceCodeBox, r1ColumnsIndex++, 1);
        }
        if (this.isInvoice()) {
            this.headerRightPaneGrid.add((Node)this.invoiceCode, r1ColumnsIndex++, 1);
            this.headerRightPaneGrid.add(this.invCodeTextField, r1ColumnsIndex++, 1);
        }
        if (ObjectChecker.isTrue((Boolean)POSUISettingsUtil.getPosUISettingsOptions().getAddAddressInSales())) {
            this.headerRightPaneGrid.add((Node)this.customerAddressLabel, r1ColumnsIndex++, 1);
            this.headerRightPaneGrid.add((Node)this.customerAddress, r1ColumnsIndex++, 1);
        }
        int r2ColumnsIndex = 1;
        this.headerRightPaneGrid.add((Node)this.currency, r2ColumnsIndex++, 2);
        this.headerRightPaneGrid.add((Node)this.currencyBox, r2ColumnsIndex++, 2);
        this.headerRightPaneGrid.add((Node)this.salesMan, r2ColumnsIndex++, 2);
        this.headerRightPaneGrid.add((Node)this.salesManCodeTextField, r2ColumnsIndex++, 2);
        if (ObjectChecker.isTrue((Boolean)POSUISettingsUtil.getPosUISettingsOptions().getAddWarehouseAndLocator())) {
            this.headerRightPaneGrid.add((Node)this.warehouseLabel, r2ColumnsIndex++, 2);
            this.headerRightPaneGrid.add((Node)this.warehouse, r2ColumnsIndex++, 2);
            this.headerRightPaneGrid.add((Node)this.locatorLabel, r2ColumnsIndex++, 2);
            this.headerRightPaneGrid.add((Node)this.location, r2ColumnsIndex++, 2);
        }
        int r3ColumnsIndex = 1;
        if (this.addDiscountFields) {
            this.headerRightPaneGrid.add((Node)this.itemsValueLabel, r3ColumnsIndex++, 3);
            this.headerRightPaneGrid.add((Node)this.itemsValue, r3ColumnsIndex++, 3);
        }
        if (this.addDiscountFields) {
            this.headerRightPaneGrid.add((Node)this.discsValueLabel, r3ColumnsIndex++, 3);
            this.headerRightPaneGrid.add((Node)this.discsValue, r3ColumnsIndex++, 3);
        }
        if (this.mustAddTax1.booleanValue() || this.mustAddTax2.booleanValue()) {
            this.headerRightPaneGrid.add((Node)this.taxsValueLabel, r3ColumnsIndex++, 3);
            this.headerRightPaneGrid.add((Node)this.taxsValue, r3ColumnsIndex++, 3);
        }
        boolean removeTaxesAndDiscounts = !this.addDiscountFields && this.mustAddTax1 == false && this.mustAddTax2 == false;
        int r4ColumnsIndex = 1;
        int r5ColumnsIndex = 1;
        if (removeTaxesAndDiscounts) {
            this.headerRightPaneGrid.add((Node)this.totalPrice, r3ColumnsIndex++, 3);
            this.headerRightPaneGrid.add((Node)this.totalPriceTextField, r3ColumnsIndex++, 3);
        } else {
            this.headerRightPaneGrid.add((Node)this.totalPrice, r4ColumnsIndex++, 4);
            this.headerRightPaneGrid.add((Node)this.totalPriceTextField, r4ColumnsIndex++, 4);
        }
        if (ObjectChecker.isTrue((Boolean)POSResourcesUtil.fetchPOSConfig().getUseTables())) {
            if (removeTaxesAndDiscounts) {
                this.headerRightPaneGrid.add((Node)this.tableLabel, r4ColumnsIndex++, 4);
                this.headerRightPaneGrid.add((Node)this.table, r4ColumnsIndex++, 4);
            } else {
                this.headerRightPaneGrid.add((Node)this.tableLabel, r5ColumnsIndex++, 5);
                this.headerRightPaneGrid.add((Node)this.table, r5ColumnsIndex++, 5);
            }
        }
        if (ObjectChecker.isTrue((Boolean)POSResourcesUtil.fetchPOSConfig().getAddDocCategoryField())) {
            this.headerRightPaneGrid.add((Node)this.docCategoryLabel, r4ColumnsIndex++, 4);
            this.headerRightPaneGrid.add((Node)this.docCategory, r4ColumnsIndex++, 4);
        }
        if (removeTaxesAndDiscounts) {
            if (ObjectChecker.isTrue((Boolean)POSResourcesUtil.fetchSupplyChainConfig().getUsePriceClassifier1())) {
                this.headerRightPaneGrid.add((Node)this.priceClassifier1Label, r4ColumnsIndex++, 4);
                this.headerRightPaneGrid.add((Node)this.priceClassifier1, r4ColumnsIndex++, 4);
            }
            if (ObjectChecker.isTrue((Boolean)POSResourcesUtil.fetchSupplyChainConfig().getUsePriceClassifier2())) {
                this.headerRightPaneGrid.add((Node)this.priceClassifier2Label, r4ColumnsIndex++, 4);
                this.headerRightPaneGrid.add((Node)this.priceClassifier2, r4ColumnsIndex++, 4);
            }
            if (ObjectChecker.isTrue((Boolean)POSResourcesUtil.fetchSupplyChainConfig().getUsePriceClassifier3())) {
                this.headerRightPaneGrid.add((Node)this.priceClassifier3Label, r5ColumnsIndex++, 5);
                this.headerRightPaneGrid.add((Node)this.priceClassifier3, r5ColumnsIndex++, 5);
            }
            if (ObjectChecker.isTrue((Boolean)POSResourcesUtil.fetchSupplyChainConfig().getUsePriceClassifier4())) {
                this.headerRightPaneGrid.add((Node)this.priceClassifier4Label, r5ColumnsIndex++, 5);
                this.headerRightPaneGrid.add((Node)this.priceClassifier4, r5ColumnsIndex++, 5);
            }
            if (ObjectChecker.isTrue((Boolean)POSResourcesUtil.fetchSupplyChainConfig().getUsePriceClassifier5())) {
                this.headerRightPaneGrid.add((Node)this.priceClassifier5Label, r5ColumnsIndex++, 5);
                this.headerRightPaneGrid.add((Node)this.priceClassifier5, r5ColumnsIndex++, 5);
            }
        }
    }

    private void createFavouriteBox() {
        if (this.doNotAddFavourites()) {
            return;
        }
        this.favouritesContainerBuilder = new FavouritesContainerBuilder();
        this.favouritesContainer = this.favouritesContainerBuilder.createFavouriteBox(this);
    }

    @Override
    public PosScene fetchScene() {
        return this.scene;
    }

    @Override
    public Stage fetchStage() {
        return this.stage;
    }

    @Override
    public NamaBorderPane fetchPane() {
        return this.pane;
    }

    @Override
    public BorderPaneCreator fetchPaneCreator() {
        return this.paneCreator;
    }

    @Override
    public double imgButtonsWidthFactor() {
        return 8.0;
    }

    @Override
    public double imgButtonsHeightFactor() {
        return 15.0;
    }

    @Override
    public String menuId() {
        return "new-menu";
    }

    @Override
    public void addNewDocument() {
        Timeline waitTimer = new Timeline(new KeyFrame[]{new KeyFrame(Duration.seconds((double)3.0), event -> DisplayPoleConnectorUtil.writeIdleMsg(POSResourcesUtil.fetchMainRegister()), new KeyValue[0])});
        waitTimer.play();
        POSResourcesUtil.lastScreensDocs.remove((Object)this.docType);
        if (ObjectChecker.areEqual((Object)((Object)this.docType), (Object)((Object)POSDocumentType.Invoice))) {
            this.afterCachedScreenReDraw();
        } else {
            PosScene.drawSalesScreen(this.stage);
        }
    }

    @Override
    public boolean fieldsPreDefinedByUser() {
        return ObjectChecker.isNotEmptyOrNull(POSUISettingsUtil.mainLinesForTypes(this.documentType()));
    }

    public String switchFavoriteAndHeaderView() {
        String fieldId = "invoiceData";
        if (this.doNotAddFavourites()) {
            return fieldId;
        }
        Node node = (Node)this.favOrHeaderPane.getChildren().removeFirst();
        if (ObjectChecker.areEqual((Object)node, (Object)this.headerGrid)) {
            this.favOrHeaderPane.getChildren().add((Object)this.favouritesContainer);
            fieldId = "invoiceData";
        } else {
            this.favOrHeaderPane.getChildren().add((Object)this.headerGrid);
            fieldId = "favouriteItems";
        }
        BorderPaneCreator.refresh((Node)this.favOrHeaderPane);
        return fieldId;
    }

    @Override
    protected void updateHeaderInformation(AbsPOSSales salesDoc) {
        super.updateHeaderInformation(salesDoc);
        this.customHeader.bindTotalProperty(this.getSalesDoc().totalProperty);
        if (ObjectChecker.areEqual((Object)((Object)this.documentType()), (Object)((Object)POSDocumentType.Invoice))) {
            this.customHeader.addInvoiceCustomHeaderStyleClass();
        } else {
            this.customHeader.removeInvoiceCustomHeaderStyleClass();
        }
    }
}

