/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.application;

import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.namacontrols.NamaButton;
import com.namasoft.namacontrols.NamaDialog;
import com.namasoft.namacontrols.NamaHBox;
import com.namasoft.namacontrols.NamaLabel;
import com.namasoft.namacontrols.NamaVBox;
import com.namasoft.pos.application.POSResourcesUtil;
import com.namasoft.pos.util.POSDataWriterUtil;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ListView;
import javafx.scene.control.cell.TextFieldListCell;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.StringConverter;

public class POSNotificationsDialog
extends NamaDialog<ButtonType> {
    private ListView<String> notificationsListView;
    private NamaLabel countLabel;
    private ObservableList<String> notificationItems;

    public POSNotificationsDialog(Stage owner) {
        super("notifications");
        this.initOwner((Window)owner);
        NamaVBox mainContent = new NamaVBox();
        mainContent.setSpacing(10.0);
        mainContent.setPadding(new Insets(10.0));
        mainContent.setPrefWidth(600.0);
        mainContent.setPrefHeight(500.0);
        this.countLabel = new NamaLabel();
        this.countLabel.setId("notification-count-label");
        this.countLabel.setStyle("-fx-font-size: 16px; -fx-font-weight: bold; -fx-padding: 10px; -fx-background-color: #f0f0f0; -fx-background-radius: 5px;");
        this.updateCountLabel();
        this.notificationItems = FXCollections.observableArrayList(POSDataWriterUtil.notifications);
        this.notificationsListView = new ListView(this.notificationItems);
        this.notificationsListView.setId("notifications-list-view");
        VBox.setVgrow(this.notificationsListView, (Priority)Priority.ALWAYS);
        this.notificationsListView.setCellFactory(TextFieldListCell.forListView((StringConverter)new StringConverter<String>(this){

            public String toString(String string) {
                return string;
            }

            public String fromString(String string) {
                return string;
            }
        }));
        this.notificationsListView.setStyle("-fx-cell-size: 80;");
        this.notificationsListView.setEditable(false);
        if (ObjectChecker.isEmptyOrNull(this.notificationItems)) {
            NamaLabel emptyLabel = new NamaLabel(POSResourcesUtil.id("Empty", new Object[0]));
            emptyLabel.setId("empty-notifications-label");
            this.notificationsListView.setPlaceholder((Node)emptyLabel);
        }
        NamaHBox buttonBar = new NamaHBox();
        buttonBar.setSpacing(10.0);
        buttonBar.setAlignment(Pos.CENTER_RIGHT);
        NamaButton clearAllBtn = new NamaButton(POSResourcesUtil.id("delete", new Object[0]));
        clearAllBtn.setId("clear-all-notifications-btn");
        clearAllBtn.setOnAction(e -> this.clearAllNotifications());
        NamaButton closeBtn = new NamaButton(POSResourcesUtil.id("close", new Object[0]));
        closeBtn.setId("close-notifications-btn");
        closeBtn.setOnAction(e -> this.close());
        buttonBar.getChildren().addAll((Object[])new Node[]{clearAllBtn, closeBtn});
        mainContent.getChildren().addAll((Object[])new Node[]{this.countLabel, this.notificationsListView, buttonBar});
        this.content((Node)mainContent);
    }

    private void updateCountLabel() {
        int count = POSDataWriterUtil.notifications.size();
        this.countLabel.setText(POSResourcesUtil.id("count", new Object[0]) + ": " + count);
    }

    private void clearAllNotifications() {
        POSDataWriterUtil.notifications.clear();
        this.notificationItems.clear();
        this.updateCountLabel();
    }

    public void showDialog() {
        this.notificationItems.clear();
        this.notificationItems.addAll(POSDataWriterUtil.notifications);
        this.updateCountLabel();
        this.showAndWait();
    }
}

