/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.application;

import com.namasoft.common.Pair;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.modules.namapos.enums.POSSecurityCapability;
import com.namasoft.namacontrols.NamaDialog;
import com.namasoft.namacontrols.NamaLabel;
import com.namasoft.pos.application.AbsPosSalesScreen;
import com.namasoft.pos.application.IPosPaymentDialog;
import com.namasoft.pos.application.POSResourcesUtil;
import com.namasoft.pos.domain.AbsPOSSales;
import com.namasoft.pos.domain.details.AbsPOSSalesLine;
import com.namasoft.pos.domain.details.POSOfferOnItemsCountLine;
import com.namasoft.pos.domain.entities.POSSalesOffers;
import com.namasoft.pos.util.POSSalesPriceUtil;
import com.namasoft.pos.util.POSSecurityUtil;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javafx.event.ActionEvent;
import javafx.scene.Node;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Dialog;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;

public class POSOfferOnItemsCountDialog
extends NamaDialog<ButtonType> {
    public POSOfferOnItemsCountDialog() {
        super("Offer");
    }

    public <T extends Dialog> void showDialog(ActionEvent e, T payDialog, AbsPOSSales salesDoc, List<Pair<POSOfferOnItemsCountLine, AbsPOSSalesLine>> toGetFree, AbsPosSalesScreen screen) {
        ((IPosPaymentDialog)payDialog).hideDialog(screen);
        POSSalesOffers salesOffer = toGetFree.stream().map(o -> ((POSOfferOnItemsCountLine)o.getX()).getSalesOffer()).filter(Objects::nonNull).findFirst().orElse(null);
        String offerName = salesOffer.nameByLanguage();
        Object offerDetails = salesOffer.getCode();
        this.title(POSResourcesUtil.id("Offer", new Object[0]) + " " + (String)offerDetails);
        if (ObjectChecker.areNotEqual((Object)offerDetails, (Object)offerName)) {
            offerDetails = (String)offerDetails + " - " + offerName;
        }
        VBox vBox = new VBox(15.0);
        HBox box = new HBox(10.0);
        NamaLabel offerLabel = new NamaLabel(POSResourcesUtil.id("There is a free item offer ", new Object[0]) + " " + (String)offerDetails);
        vBox.getChildren().addAll((Object[])new Node[]{offerLabel, box});
        CheckBox doNotShowAgain = null;
        Boolean allowHideOffersDialog = POSSecurityUtil.userCan(POSSecurityCapability.AllowHideOffersDialog).isSucceeded();
        if (allowHideOffersDialog.booleanValue()) {
            doNotShowAgain = new CheckBox();
            box.getChildren().addAll((Object[])new Node[]{new NamaLabel("Don't show offer again"), doNotShowAgain});
        }
        this.content((Node)vBox);
        this.addOkButton("");
        this.addCancelButton("");
        Optional result = this.showAndWait();
        if (result.isPresent() && ObjectChecker.areEqual((Object)((ButtonType)result.get()).getButtonData(), (Object)ButtonBar.ButtonData.APPLY)) {
            if (allowHideOffersDialog.booleanValue() && doNotShowAgain.isSelected()) {
                screen.setShowOfferDialogAgain(false);
            }
            salesDoc.addOfferLineToInvoice(POSResourcesUtil.fetchMainRegister(), toGetFree, salesDoc, screen);
            toGetFree.forEach(offerPair -> {
                if (ObjectChecker.isTrue((Boolean)((POSOfferOnItemsCountLine)offerPair.getX()).getIgnoreOtherOffers())) {
                    List srcLines = Arrays.stream(((POSOfferOnItemsCountLine)offerPair.getX()).getSrcLinesNumbers().split("_#_")).map(lineNum -> salesDoc.fetchDetails().get(Integer.parseInt(lineNum))).collect(Collectors.toList());
                    POSSalesPriceUtil.cancelOtherOffers(srcLines, salesDoc, screen);
                    screen.setShowOfferDialogAgain(false);
                }
            });
        } else {
            if (allowHideOffersDialog.booleanValue() && doNotShowAgain.isSelected()) {
                screen.setShowOfferDialogAgain(false);
            }
            this.hide();
            e.consume();
        }
    }
}

